/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.F2;
import swim.math.VectorZ2;
import swim.math.Z;

public class Z2
implements F2<VectorZ2, Long>,
Debug {
    private static Z2 module;

    protected Z2() {
    }

    public final Z scalar() {
        return Z.ring();
    }

    @Override
    public final VectorZ2 zero() {
        return VectorZ2.zero();
    }

    @Override
    public final VectorZ2 of(Long x, Long y) {
        return VectorZ2.of(x, y);
    }

    @Override
    public final Long getX(VectorZ2 v) {
        return v.x;
    }

    @Override
    public final Long getY(VectorZ2 v) {
        return v.y;
    }

    @Override
    public final VectorZ2 add(VectorZ2 u, VectorZ2 v) {
        return u.plus(v);
    }

    @Override
    public final VectorZ2 opposite(VectorZ2 v) {
        return v.opposite();
    }

    @Override
    public final VectorZ2 subtract(VectorZ2 u, VectorZ2 v) {
        return u.minus(v);
    }

    @Override
    public final VectorZ2 multiply(VectorZ2 u, Long a) {
        return u.times(a);
    }

    @Override
    public final VectorZ2 combine(Long a, VectorZ2 u, Long b, VectorZ2 v) {
        return new VectorZ2(a * u.x + b * v.x, a * u.y + b * v.y);
    }

    public void debug(Output<?> output) {
        output.write("Z2").write(46).write("module").write(40).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static Z2 module() {
        if (module == null) {
            module = new Z2();
        }
        return module;
    }
}

