/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.spring.boot.it;

import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.impl.io.jaxb.SolverConfigIO;
import ai.timefold.solver.spring.boot.it.domain.IntegrationTestEntity;
import ai.timefold.solver.spring.boot.it.domain.IntegrationTestSolution;
import ai.timefold.solver.spring.boot.it.domain.IntegrationTestValue;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.core.io.Resource;
import org.springframework.test.web.reactive.server.WebTestClient;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
class TimefoldSolverTestResourceIntegrationTest {
    @LocalServerPort
    String port;
    @Value(value="classpath:solver-full.xml")
    Resource exampleSolverConfigXml;

    TimefoldSolverTestResourceIntegrationTest() {
    }

    @Test
    void testSolve() {
        WebTestClient client = WebTestClient.bindToServer().baseUrl("http://localhost:" + this.port + "/integration-test").build();
        IntegrationTestSolution problem = new IntegrationTestSolution(List.of(new IntegrationTestEntity("0"), new IntegrationTestEntity("1"), new IntegrationTestEntity("2")), List.of(new IntegrationTestValue("0"), new IntegrationTestValue("1"), new IntegrationTestValue("2")));
        client.post().bodyValue((Object)problem).exchange().expectBody().jsonPath("score").isEqualTo((Object)"0").jsonPath("entityList").isArray().jsonPath("valueList").isArray().jsonPath("entityList[0].id").isEqualTo((Object)"0").jsonPath("entityList[0].value.id").isEqualTo((Object)"0").jsonPath("entityList[1].id").isEqualTo((Object)"1").jsonPath("entityList[1].value.id").isEqualTo((Object)"1").jsonPath("entityList[2].id").isEqualTo((Object)"2").jsonPath("entityList[2].value.id").isEqualTo((Object)"2");
    }

    @Test
    void testSolverXmlParsing() throws IOException {
        SolverConfigIO solverConfigIO = new SolverConfigIO();
        SolverConfig solverConfig = solverConfigIO.read((Reader)new InputStreamReader(this.exampleSolverConfigXml.getInputStream()));
        Assertions.assertThat((Object)solverConfig).isNotNull();
        Assertions.assertThat((Class)solverConfig.getSolutionClass()).isEqualTo(Object.class);
        Assertions.assertThat((List)solverConfig.getPhaseConfigList()).isNotEmpty();
    }
}

