/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.heuristic.selector.common.nearby;

import ai.timefold.solver.core.config.heuristic.selector.SelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionDistributionType;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.list.SubListSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;

@XmlType(propOrder={"originEntitySelectorConfig", "originSubListSelectorConfig", "originValueSelectorConfig", "nearbyDistanceMeterClass", "nearbySelectionDistributionType", "blockDistributionSizeMinimum", "blockDistributionSizeMaximum", "blockDistributionSizeRatio", "blockDistributionUniformDistributionProbability", "linearDistributionSizeMaximum", "parabolicDistributionSizeMaximum", "betaDistributionAlpha", "betaDistributionBeta"})
public class NearbySelectionConfig
extends SelectorConfig<NearbySelectionConfig> {
    @XmlElement(name="originEntitySelector")
    protected EntitySelectorConfig originEntitySelectorConfig = null;
    @XmlElement(name="originSubListSelector")
    protected SubListSelectorConfig originSubListSelectorConfig = null;
    @XmlElement(name="originValueSelector")
    protected ValueSelectorConfig originValueSelectorConfig = null;
    protected Class<? extends NearbyDistanceMeter> nearbyDistanceMeterClass = null;
    protected NearbySelectionDistributionType nearbySelectionDistributionType = null;
    protected Integer blockDistributionSizeMinimum = null;
    protected Integer blockDistributionSizeMaximum = null;
    protected Double blockDistributionSizeRatio = null;
    protected Double blockDistributionUniformDistributionProbability = null;
    protected Integer linearDistributionSizeMaximum = null;
    protected Integer parabolicDistributionSizeMaximum = null;
    protected Double betaDistributionAlpha = null;
    protected Double betaDistributionBeta = null;

    public EntitySelectorConfig getOriginEntitySelectorConfig() {
        return this.originEntitySelectorConfig;
    }

    public void setOriginEntitySelectorConfig(EntitySelectorConfig originEntitySelectorConfig) {
        this.originEntitySelectorConfig = originEntitySelectorConfig;
    }

    public SubListSelectorConfig getOriginSubListSelectorConfig() {
        return this.originSubListSelectorConfig;
    }

    public void setOriginSubListSelectorConfig(SubListSelectorConfig originSubListSelectorConfig) {
        this.originSubListSelectorConfig = originSubListSelectorConfig;
    }

    public ValueSelectorConfig getOriginValueSelectorConfig() {
        return this.originValueSelectorConfig;
    }

    public void setOriginValueSelectorConfig(ValueSelectorConfig originValueSelectorConfig) {
        this.originValueSelectorConfig = originValueSelectorConfig;
    }

    public Class<? extends NearbyDistanceMeter> getNearbyDistanceMeterClass() {
        return this.nearbyDistanceMeterClass;
    }

    public void setNearbyDistanceMeterClass(Class<? extends NearbyDistanceMeter> nearbyDistanceMeterClass) {
        this.nearbyDistanceMeterClass = nearbyDistanceMeterClass;
    }

    public NearbySelectionDistributionType getNearbySelectionDistributionType() {
        return this.nearbySelectionDistributionType;
    }

    public void setNearbySelectionDistributionType(NearbySelectionDistributionType nearbySelectionDistributionType) {
        this.nearbySelectionDistributionType = nearbySelectionDistributionType;
    }

    public Integer getBlockDistributionSizeMinimum() {
        return this.blockDistributionSizeMinimum;
    }

    public void setBlockDistributionSizeMinimum(Integer blockDistributionSizeMinimum) {
        this.blockDistributionSizeMinimum = blockDistributionSizeMinimum;
    }

    public Integer getBlockDistributionSizeMaximum() {
        return this.blockDistributionSizeMaximum;
    }

    public void setBlockDistributionSizeMaximum(Integer blockDistributionSizeMaximum) {
        this.blockDistributionSizeMaximum = blockDistributionSizeMaximum;
    }

    public Double getBlockDistributionSizeRatio() {
        return this.blockDistributionSizeRatio;
    }

    public void setBlockDistributionSizeRatio(Double blockDistributionSizeRatio) {
        this.blockDistributionSizeRatio = blockDistributionSizeRatio;
    }

    public Double getBlockDistributionUniformDistributionProbability() {
        return this.blockDistributionUniformDistributionProbability;
    }

    public void setBlockDistributionUniformDistributionProbability(Double blockDistributionUniformDistributionProbability) {
        this.blockDistributionUniformDistributionProbability = blockDistributionUniformDistributionProbability;
    }

    public Integer getLinearDistributionSizeMaximum() {
        return this.linearDistributionSizeMaximum;
    }

    public void setLinearDistributionSizeMaximum(Integer linearDistributionSizeMaximum) {
        this.linearDistributionSizeMaximum = linearDistributionSizeMaximum;
    }

    public Integer getParabolicDistributionSizeMaximum() {
        return this.parabolicDistributionSizeMaximum;
    }

    public void setParabolicDistributionSizeMaximum(Integer parabolicDistributionSizeMaximum) {
        this.parabolicDistributionSizeMaximum = parabolicDistributionSizeMaximum;
    }

    public Double getBetaDistributionAlpha() {
        return this.betaDistributionAlpha;
    }

    public void setBetaDistributionAlpha(Double betaDistributionAlpha) {
        this.betaDistributionAlpha = betaDistributionAlpha;
    }

    public Double getBetaDistributionBeta() {
        return this.betaDistributionBeta;
    }

    public void setBetaDistributionBeta(Double betaDistributionBeta) {
        this.betaDistributionBeta = betaDistributionBeta;
    }

    public NearbySelectionConfig withOriginEntitySelectorConfig(EntitySelectorConfig originEntitySelectorConfig) {
        this.setOriginEntitySelectorConfig(originEntitySelectorConfig);
        return this;
    }

    public NearbySelectionConfig withOriginSubListSelectorConfig(SubListSelectorConfig originSubListSelectorConfig) {
        this.setOriginSubListSelectorConfig(originSubListSelectorConfig);
        return this;
    }

    public NearbySelectionConfig withOriginValueSelectorConfig(ValueSelectorConfig originValueSelectorConfig) {
        this.setOriginValueSelectorConfig(originValueSelectorConfig);
        return this;
    }

    public NearbySelectionConfig withNearbyDistanceMeterClass(Class<? extends NearbyDistanceMeter> nearbyDistanceMeterClass) {
        this.setNearbyDistanceMeterClass(nearbyDistanceMeterClass);
        return this;
    }

    public NearbySelectionConfig withNearbySelectionDistributionType(NearbySelectionDistributionType nearbySelectionDistributionType) {
        this.setNearbySelectionDistributionType(nearbySelectionDistributionType);
        return this;
    }

    public NearbySelectionConfig withBlockDistributionSizeMinimum(Integer blockDistributionSizeMinimum) {
        this.setBlockDistributionSizeMinimum(blockDistributionSizeMinimum);
        return this;
    }

    public NearbySelectionConfig withBlockDistributionSizeMaximum(Integer blockDistributionSizeMaximum) {
        this.setBlockDistributionSizeMaximum(blockDistributionSizeMaximum);
        return this;
    }

    public NearbySelectionConfig withBlockDistributionSizeRatio(Double blockDistributionSizeRatio) {
        this.setBlockDistributionSizeRatio(blockDistributionSizeRatio);
        return this;
    }

    public NearbySelectionConfig withBlockDistributionUniformDistributionProbability(Double blockDistributionUniformDistributionProbability) {
        this.setBlockDistributionUniformDistributionProbability(blockDistributionUniformDistributionProbability);
        return this;
    }

    public NearbySelectionConfig withLinearDistributionSizeMaximum(Integer linearDistributionSizeMaximum) {
        this.setLinearDistributionSizeMaximum(linearDistributionSizeMaximum);
        return this;
    }

    public NearbySelectionConfig withParabolicDistributionSizeMaximum(Integer parabolicDistributionSizeMaximum) {
        this.setParabolicDistributionSizeMaximum(parabolicDistributionSizeMaximum);
        return this;
    }

    public NearbySelectionConfig withBetaDistributionAlpha(Double betaDistributionAlpha) {
        this.setBetaDistributionAlpha(betaDistributionAlpha);
        return this;
    }

    public NearbySelectionConfig withBetaDistributionBeta(Double betaDistributionBeta) {
        this.setBetaDistributionBeta(betaDistributionBeta);
        return this;
    }

    public void validateNearby(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder) {
        long originSelectorCount = Stream.of(this.originEntitySelectorConfig, this.originSubListSelectorConfig, this.originValueSelectorConfig).filter(Objects::nonNull).count();
        if (originSelectorCount == 0L) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") is nearby selection but lacks an origin selector config. Set one of originEntitySelectorConfig, originSubListSelectorConfig or originValueSelectorConfig.");
        }
        if (originSelectorCount > 1L) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") has multiple origin selector configs but exactly one is expected. Set one of originEntitySelectorConfig, originSubListSelectorConfig or originValueSelectorConfig.");
        }
        if (this.originEntitySelectorConfig != null && this.originEntitySelectorConfig.getMimicSelectorRef() == null) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") has an originEntitySelectorConfig (" + this.originEntitySelectorConfig + ") which has no MimicSelectorRef (" + this.originEntitySelectorConfig.getMimicSelectorRef() + "). A nearby's original entity should always be the same as an entity selected earlier in the move.");
        }
        if (this.originSubListSelectorConfig != null && this.originSubListSelectorConfig.getMimicSelectorRef() == null) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") has an originSubListSelectorConfig (" + this.originSubListSelectorConfig + ") which has no MimicSelectorRef (" + this.originSubListSelectorConfig.getMimicSelectorRef() + "). A nearby's original subList should always be the same as a subList selected earlier in the move.");
        }
        if (this.originValueSelectorConfig != null && this.originValueSelectorConfig.getMimicSelectorRef() == null) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") has an originValueSelectorConfig (" + this.originValueSelectorConfig + ") which has no MimicSelectorRef (" + this.originValueSelectorConfig.getMimicSelectorRef() + "). A nearby's original value should always be the same as a value selected earlier in the move.");
        }
        if (this.nearbyDistanceMeterClass == null) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") is nearby selection but lacks a nearbyDistanceMeterClass (" + this.nearbyDistanceMeterClass + ").");
        }
        if (resolvedSelectionOrder != SelectionOrder.ORIGINAL && resolvedSelectionOrder != SelectionOrder.RANDOM) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") with originEntitySelector (" + this.originEntitySelectorConfig + ") and originSubListSelector (" + this.originSubListSelectorConfig + ") and originValueSelector (" + this.originValueSelectorConfig + ") and nearbyDistanceMeterClass (" + this.nearbyDistanceMeterClass + ") has a resolvedSelectionOrder (" + resolvedSelectionOrder + ") that is not " + SelectionOrder.ORIGINAL + " or " + SelectionOrder.RANDOM + ".");
        }
        if (resolvedCacheType.isCached()) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") with originEntitySelector (" + this.originEntitySelectorConfig + ") and originSubListSelector (" + this.originSubListSelectorConfig + ") and originValueSelector (" + this.originValueSelectorConfig + ") and nearbyDistanceMeterClass (" + this.nearbyDistanceMeterClass + ") has a resolvedCacheType (" + resolvedCacheType + ") that is cached.");
        }
    }

    @Override
    public NearbySelectionConfig inherit(NearbySelectionConfig inheritedConfig) {
        this.originEntitySelectorConfig = ConfigUtils.inheritConfig(this.originEntitySelectorConfig, inheritedConfig.getOriginEntitySelectorConfig());
        this.originSubListSelectorConfig = ConfigUtils.inheritConfig(this.originSubListSelectorConfig, inheritedConfig.getOriginSubListSelectorConfig());
        this.originValueSelectorConfig = ConfigUtils.inheritConfig(this.originValueSelectorConfig, inheritedConfig.getOriginValueSelectorConfig());
        this.nearbyDistanceMeterClass = ConfigUtils.inheritOverwritableProperty(this.nearbyDistanceMeterClass, inheritedConfig.getNearbyDistanceMeterClass());
        this.nearbySelectionDistributionType = ConfigUtils.inheritOverwritableProperty(this.nearbySelectionDistributionType, inheritedConfig.getNearbySelectionDistributionType());
        this.blockDistributionSizeMinimum = ConfigUtils.inheritOverwritableProperty(this.blockDistributionSizeMinimum, inheritedConfig.getBlockDistributionSizeMinimum());
        this.blockDistributionSizeMaximum = ConfigUtils.inheritOverwritableProperty(this.blockDistributionSizeMaximum, inheritedConfig.getBlockDistributionSizeMaximum());
        this.blockDistributionSizeRatio = ConfigUtils.inheritOverwritableProperty(this.blockDistributionSizeRatio, inheritedConfig.getBlockDistributionSizeRatio());
        this.blockDistributionUniformDistributionProbability = ConfigUtils.inheritOverwritableProperty(this.blockDistributionUniformDistributionProbability, inheritedConfig.getBlockDistributionUniformDistributionProbability());
        this.linearDistributionSizeMaximum = ConfigUtils.inheritOverwritableProperty(this.linearDistributionSizeMaximum, inheritedConfig.getLinearDistributionSizeMaximum());
        this.parabolicDistributionSizeMaximum = ConfigUtils.inheritOverwritableProperty(this.parabolicDistributionSizeMaximum, inheritedConfig.getParabolicDistributionSizeMaximum());
        this.betaDistributionAlpha = ConfigUtils.inheritOverwritableProperty(this.betaDistributionAlpha, inheritedConfig.getBetaDistributionAlpha());
        this.betaDistributionBeta = ConfigUtils.inheritOverwritableProperty(this.betaDistributionBeta, inheritedConfig.getBetaDistributionBeta());
        return this;
    }

    @Override
    public NearbySelectionConfig copyConfig() {
        return new NearbySelectionConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(Consumer<Class<?>> classVisitor) {
        if (this.originEntitySelectorConfig != null) {
            this.originEntitySelectorConfig.visitReferencedClasses(classVisitor);
        }
        if (this.originSubListSelectorConfig != null) {
            this.originSubListSelectorConfig.visitReferencedClasses(classVisitor);
        }
        if (this.originValueSelectorConfig != null) {
            this.originValueSelectorConfig.visitReferencedClasses(classVisitor);
        }
        classVisitor.accept(this.nearbyDistanceMeterClass);
    }
}

