/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.heuristic.selector.list;

import ai.timefold.solver.core.config.heuristic.selector.SelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.function.Consumer;

@XmlType(propOrder={"entitySelectorConfig", "valueSelectorConfig", "nearbySelectionConfig"})
public class DestinationSelectorConfig
extends SelectorConfig<DestinationSelectorConfig> {
    @XmlElement(name="entitySelector")
    private EntitySelectorConfig entitySelectorConfig;
    @XmlElement(name="valueSelector")
    private ValueSelectorConfig valueSelectorConfig;
    @XmlElement(name="nearbySelection")
    private NearbySelectionConfig nearbySelectionConfig;

    public DestinationSelectorConfig() {
    }

    public DestinationSelectorConfig(DestinationSelectorConfig inheritedConfig) {
        if (inheritedConfig != null) {
            this.inherit(inheritedConfig);
        }
    }

    public EntitySelectorConfig getEntitySelectorConfig() {
        return this.entitySelectorConfig;
    }

    public void setEntitySelectorConfig(EntitySelectorConfig entitySelectorConfig) {
        this.entitySelectorConfig = entitySelectorConfig;
    }

    public ValueSelectorConfig getValueSelectorConfig() {
        return this.valueSelectorConfig;
    }

    public void setValueSelectorConfig(ValueSelectorConfig valueSelectorConfig) {
        this.valueSelectorConfig = valueSelectorConfig;
    }

    public NearbySelectionConfig getNearbySelectionConfig() {
        return this.nearbySelectionConfig;
    }

    public void setNearbySelectionConfig(NearbySelectionConfig nearbySelectionConfig) {
        this.nearbySelectionConfig = nearbySelectionConfig;
    }

    public DestinationSelectorConfig withEntitySelectorConfig(EntitySelectorConfig entitySelectorConfig) {
        this.setEntitySelectorConfig(entitySelectorConfig);
        return this;
    }

    public DestinationSelectorConfig withValueSelectorConfig(ValueSelectorConfig valueSelectorConfig) {
        this.setValueSelectorConfig(valueSelectorConfig);
        return this;
    }

    public DestinationSelectorConfig withNearbySelectionConfig(NearbySelectionConfig nearbySelectionConfig) {
        this.setNearbySelectionConfig(nearbySelectionConfig);
        return this;
    }

    @Override
    public DestinationSelectorConfig inherit(DestinationSelectorConfig inheritedConfig) {
        this.entitySelectorConfig = ConfigUtils.inheritConfig(this.entitySelectorConfig, inheritedConfig.getEntitySelectorConfig());
        this.valueSelectorConfig = ConfigUtils.inheritConfig(this.valueSelectorConfig, inheritedConfig.getValueSelectorConfig());
        this.nearbySelectionConfig = ConfigUtils.inheritConfig(this.nearbySelectionConfig, inheritedConfig.getNearbySelectionConfig());
        return this;
    }

    @Override
    public DestinationSelectorConfig copyConfig() {
        return new DestinationSelectorConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(Consumer<Class<?>> classVisitor) {
        if (this.entitySelectorConfig != null) {
            this.entitySelectorConfig.visitReferencedClasses(classVisitor);
        }
        if (this.valueSelectorConfig != null) {
            this.valueSelectorConfig.visitReferencedClasses(classVisitor);
        }
        if (this.nearbySelectionConfig != null) {
            this.nearbySelectionConfig.visitReferencedClasses(classVisitor);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelectorConfig + ", " + this.valueSelectorConfig + ")";
    }
}

