/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.constructionheuristic.decider;

import ai.timefold.solver.core.impl.constructionheuristic.decider.ConstructionHeuristicDecider;
import ai.timefold.solver.core.impl.constructionheuristic.decider.forager.ConstructionHeuristicForager;
import ai.timefold.solver.core.impl.constructionheuristic.placer.Placement;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicMoveScope;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicPhaseScope;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicStepScope;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.thread.ApplyStepOperation;
import ai.timefold.solver.core.impl.heuristic.thread.DestroyOperation;
import ai.timefold.solver.core.impl.heuristic.thread.MoveEvaluationOperation;
import ai.timefold.solver.core.impl.heuristic.thread.MoveThreadOperation;
import ai.timefold.solver.core.impl.heuristic.thread.MoveThreadRunner;
import ai.timefold.solver.core.impl.heuristic.thread.OrderByMoveIndexBlockingQueue;
import ai.timefold.solver.core.impl.heuristic.thread.SetupOperation;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import ai.timefold.solver.core.impl.solver.thread.ThreadUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;

public class MultiThreadedConstructionHeuristicDecider<Solution_>
extends ConstructionHeuristicDecider<Solution_> {
    protected final ThreadFactory threadFactory;
    protected final int moveThreadCount;
    protected final int selectedMoveBufferSize;
    protected boolean assertStepScoreFromScratch = false;
    protected boolean assertExpectedStepScore = false;
    protected boolean assertShadowVariablesAreNotStaleAfterStep = false;
    protected BlockingQueue<MoveThreadOperation<Solution_>> operationQueue;
    protected OrderByMoveIndexBlockingQueue<Solution_> resultQueue;
    protected CyclicBarrier moveThreadBarrier;
    protected ExecutorService executor;
    protected List<MoveThreadRunner<Solution_, ?>> moveThreadRunnerList;

    public MultiThreadedConstructionHeuristicDecider(String logIndentation, Termination<Solution_> termination, ConstructionHeuristicForager<Solution_> forager, ThreadFactory threadFactory, int moveThreadCount, int selectedMoveBufferSize) {
        super(logIndentation, termination, forager);
        this.threadFactory = threadFactory;
        this.moveThreadCount = moveThreadCount;
        this.selectedMoveBufferSize = selectedMoveBufferSize;
    }

    public void setAssertStepScoreFromScratch(boolean assertStepScoreFromScratch) {
        this.assertStepScoreFromScratch = assertStepScoreFromScratch;
    }

    public void setAssertExpectedStepScore(boolean assertExpectedStepScore) {
        this.assertExpectedStepScore = assertExpectedStepScore;
    }

    public void setAssertShadowVariablesAreNotStaleAfterStep(boolean assertShadowVariablesAreNotStaleAfterStep) {
        this.assertShadowVariablesAreNotStaleAfterStep = assertShadowVariablesAreNotStaleAfterStep;
    }

    @Override
    public void phaseStarted(ConstructionHeuristicPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.operationQueue = new ArrayBlockingQueue<MoveThreadOperation<Solution_>>(this.selectedMoveBufferSize + this.moveThreadCount + this.moveThreadCount);
        this.resultQueue = new OrderByMoveIndexBlockingQueue(this.selectedMoveBufferSize + this.moveThreadCount);
        this.moveThreadBarrier = new CyclicBarrier(this.moveThreadCount);
        InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
        this.executor = this.createThreadPoolExecutor();
        this.moveThreadRunnerList = new ArrayList(this.moveThreadCount);
        for (int moveThreadIndex = 0; moveThreadIndex < this.moveThreadCount; ++moveThreadIndex) {
            MoveThreadRunner moveThreadRunner = new MoveThreadRunner(this.logIndentation, moveThreadIndex, false, this.operationQueue, this.resultQueue, this.moveThreadBarrier, this.assertMoveScoreFromScratch, this.assertExpectedUndoMoveScore, this.assertStepScoreFromScratch, this.assertExpectedStepScore, this.assertShadowVariablesAreNotStaleAfterStep);
            this.moveThreadRunnerList.add(moveThreadRunner);
            this.executor.submit(moveThreadRunner);
            this.operationQueue.add(new SetupOperation(scoreDirector));
        }
    }

    @Override
    public void phaseEnded(ConstructionHeuristicPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        DestroyOperation destroyOperation = new DestroyOperation();
        for (int i = 0; i < this.moveThreadCount; ++i) {
            this.operationQueue.add(destroyOperation);
        }
        this.shutdownMoveThreads();
        long childThreadsScoreCalculationCount = 0L;
        for (MoveThreadRunner<Solution_, ?> moveThreadRunner : this.moveThreadRunnerList) {
            childThreadsScoreCalculationCount += moveThreadRunner.getCalculationCount();
        }
        phaseScope.addChildThreadsScoreCalculationCount(childThreadsScoreCalculationCount);
        this.operationQueue = null;
        this.resultQueue = null;
        this.moveThreadRunnerList = null;
    }

    @Override
    public void solvingError(SolverScope<Solution_> solverScope, Exception exception) {
        super.solvingError(solverScope, exception);
        this.shutdownMoveThreads();
    }

    protected ExecutorService createThreadPoolExecutor() {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(this.moveThreadCount, this.threadFactory);
        if (threadPoolExecutor.getMaximumPoolSize() < this.moveThreadCount) {
            throw new IllegalStateException("The threadPoolExecutor's maximumPoolSize (" + threadPoolExecutor.getMaximumPoolSize() + ") is less than the moveThreadCount (" + this.moveThreadCount + "), this is unsupported.");
        }
        return threadPoolExecutor;
    }

    @Override
    public void decideNextStep(ConstructionHeuristicStepScope<Solution_> stepScope, Placement<Solution_> placement) {
        int stepIndex = stepScope.getStepIndex();
        this.resultQueue.startNextStep(stepIndex);
        int selectMoveIndex = 0;
        int movesInPlay = 0;
        Iterator<Move<Solution_>> moveIterator = placement.iterator();
        do {
            boolean hasNextMove = moveIterator.hasNext();
            if (!(movesInPlay <= 0 || selectMoveIndex < this.selectedMoveBufferSize && hasNextMove)) {
                if (this.forageResult(stepScope, stepIndex)) break;
                --movesInPlay;
            }
            if (!hasNextMove) continue;
            Move<Solution_> move = moveIterator.next();
            this.operationQueue.add(new MoveEvaluationOperation<Solution_>(stepIndex, selectMoveIndex, move));
            ++selectMoveIndex;
            ++movesInPlay;
        } while (movesInPlay > 0);
        this.operationQueue.clear();
        this.pickMove(stepScope);
        if (stepScope.getStep() != null) {
            InnerScoreDirector scoreDirector = stepScope.getScoreDirector();
            if (scoreDirector.requiresFlushing() && stepIndex % 100 == 99) {
                scoreDirector.calculateScore();
            }
            ApplyStepOperation stepOperation = new ApplyStepOperation(stepIndex + 1, stepScope.getStep(), stepScope.getScore());
            for (int i = 0; i < this.moveThreadCount; ++i) {
                this.operationQueue.add(stepOperation);
            }
        }
    }

    private boolean forageResult(ConstructionHeuristicStepScope<Solution_> stepScope, int stepIndex) {
        OrderByMoveIndexBlockingQueue.MoveResult<Solution_> result;
        try {
            result = this.resultQueue.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return true;
        }
        if (stepIndex != result.getStepIndex()) {
            throw new IllegalStateException("Impossible situation: the solverThread's stepIndex (" + stepIndex + ") differs from the result's stepIndex (" + result.getStepIndex() + ").");
        }
        Move<Solution_> foragingMove = result.getMove().rebase(stepScope.getScoreDirector());
        int foragingMoveIndex = result.getMoveIndex();
        ConstructionHeuristicMoveScope<Solution_> moveScope = new ConstructionHeuristicMoveScope<Solution_>(stepScope, foragingMoveIndex, foragingMove);
        if (!result.isMoveDoable()) {
            throw new IllegalStateException("Impossible situation: Construction Heuristics move is not doable.");
        }
        moveScope.setScore(result.getScore());
        moveScope.getScoreDirector().incrementCalculationCount();
        this.logger.trace("{}        Move index ({}), score ({}), move ({}).", new Object[]{this.logIndentation, foragingMoveIndex, moveScope.getScore(), foragingMove});
        this.forager.addMove(moveScope);
        if (this.forager.isQuitEarly()) {
            return true;
        }
        stepScope.getPhaseScope().getSolverScope().checkYielding();
        return this.termination.isPhaseTerminated(stepScope.getPhaseScope());
    }

    private void shutdownMoveThreads() {
        if (this.executor != null && !this.executor.isShutdown()) {
            ThreadUtils.shutdownAwaitOrKill(this.executor, this.logIndentation, "Multi-threaded Construction Heuristic");
        }
    }
}

