/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.constructionheuristic.decider.forager;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.config.constructionheuristic.decider.forager.ConstructionHeuristicPickEarlyType;
import ai.timefold.solver.core.impl.constructionheuristic.decider.forager.AbstractConstructionHeuristicForager;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicMoveScope;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicPhaseScope;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicStepScope;

public class DefaultConstructionHeuristicForager<Solution_>
extends AbstractConstructionHeuristicForager<Solution_> {
    protected final ConstructionHeuristicPickEarlyType pickEarlyType;
    protected long selectedMoveCount;
    protected ConstructionHeuristicMoveScope<Solution_> earlyPickedMoveScope;
    protected ConstructionHeuristicMoveScope<Solution_> maxScoreMoveScope;

    public DefaultConstructionHeuristicForager(ConstructionHeuristicPickEarlyType pickEarlyType) {
        this.pickEarlyType = pickEarlyType;
    }

    @Override
    public void stepStarted(ConstructionHeuristicStepScope<Solution_> stepScope) {
        super.stepStarted(stepScope);
        this.selectedMoveCount = 0L;
        this.earlyPickedMoveScope = null;
        this.maxScoreMoveScope = null;
    }

    @Override
    public void stepEnded(ConstructionHeuristicStepScope<Solution_> stepScope) {
        super.stepEnded(stepScope);
        this.earlyPickedMoveScope = null;
        this.maxScoreMoveScope = null;
    }

    @Override
    public void addMove(ConstructionHeuristicMoveScope<Solution_> moveScope) {
        ++this.selectedMoveCount;
        this.checkPickEarly(moveScope);
        if (this.maxScoreMoveScope == null || moveScope.getScore().compareTo(this.maxScoreMoveScope.getScore()) > 0) {
            this.maxScoreMoveScope = moveScope;
        }
    }

    protected void checkPickEarly(ConstructionHeuristicMoveScope<Solution_> moveScope) {
        switch (this.pickEarlyType) {
            case NEVER: {
                break;
            }
            case FIRST_NON_DETERIORATING_SCORE: {
                Score<?> lastStepScore = ((ConstructionHeuristicPhaseScope)((ConstructionHeuristicStepScope)moveScope.getStepScope()).getPhaseScope()).getLastCompletedStepScope().getScore();
                if (moveScope.getScore().withInitScore(0).compareTo(lastStepScore.withInitScore(0)) < 0) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            case FIRST_FEASIBLE_SCORE: {
                if (!moveScope.getScore().withInitScore(0).isFeasible()) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            case FIRST_FEASIBLE_SCORE_OR_NON_DETERIORATING_HARD: {
                Score<?> lastStepScore2 = ((ConstructionHeuristicPhaseScope)((ConstructionHeuristicStepScope)moveScope.getStepScope()).getPhaseScope()).getLastCompletedStepScope().getScore();
                Object lastStepScoreDifference = moveScope.getScore().withInitScore(0).subtract(lastStepScore2.withInitScore(0));
                if (!lastStepScoreDifference.isFeasible()) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            default: {
                throw new IllegalStateException("The pickEarlyType (" + this.pickEarlyType + ") is not implemented.");
            }
        }
    }

    @Override
    public boolean isQuitEarly() {
        return this.earlyPickedMoveScope != null;
    }

    @Override
    public ConstructionHeuristicMoveScope<Solution_> pickMove(ConstructionHeuristicStepScope<Solution_> stepScope) {
        stepScope.setSelectedMoveCount(this.selectedMoveCount);
        if (this.earlyPickedMoveScope != null) {
            return this.earlyPickedMoveScope;
        }
        return this.maxScoreMoveScope;
    }
}

