/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class ReflectionHelper {
    private static final String PROPERTY_ACCESSOR_PREFIX_GET = "get";
    private static final String PROPERTY_ACCESSOR_PREFIX_IS = "is";
    private static final String[] PROPERTY_ACCESSOR_PREFIXES = new String[]{"get", "is"};
    private static final String PROPERTY_MUTATOR_PREFIX = "set";

    public static String getGetterPropertyName(Member member) {
        if (member instanceof Field) {
            return member.getName();
        }
        if (member instanceof Method) {
            String methodName = member.getName();
            for (String prefix : PROPERTY_ACCESSOR_PREFIXES) {
                if (!methodName.startsWith(prefix)) continue;
                return ReflectionHelper.decapitalizePropertyName(methodName.substring(prefix.length()));
            }
        }
        return null;
    }

    private static String decapitalizePropertyName(String propertyName) {
        if (propertyName.isEmpty() || ReflectionHelper.startsWithSeveralUpperCaseLetters(propertyName)) {
            return propertyName;
        }
        return propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
    }

    private static boolean startsWithSeveralUpperCaseLetters(String propertyName) {
        return propertyName.length() > 1 && Character.isUpperCase(propertyName.charAt(0)) && Character.isUpperCase(propertyName.charAt(1));
    }

    public static boolean isGetterMethod(Method method) {
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        String methodName = method.getName();
        if (methodName.startsWith(PROPERTY_ACCESSOR_PREFIX_GET) && method.getReturnType() != Void.TYPE) {
            return true;
        }
        return methodName.startsWith(PROPERTY_ACCESSOR_PREFIX_IS) && method.getReturnType() == Boolean.TYPE;
    }

    public static boolean hasGetterMethod(Class<?> containingClass, String propertyName) {
        return ReflectionHelper.getGetterMethod(containingClass, propertyName) != null;
    }

    public static Method getGetterMethod(Class<?> containingClass, String propertyName) {
        String getterName = PROPERTY_ACCESSOR_PREFIX_GET + (String)(propertyName.isEmpty() ? "" : propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1));
        try {
            return containingClass.getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String isserName = PROPERTY_ACCESSOR_PREFIX_IS + (String)(propertyName.isEmpty() ? "" : propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1));
            try {
                Method method = containingClass.getMethod(isserName, new Class[0]);
                if (method.getReturnType() == Boolean.TYPE) {
                    return method;
                }
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                // empty catch block
            }
            return null;
        }
    }

    public static boolean hasField(Class<?> containingClass, String fieldName) {
        return ReflectionHelper.getField(containingClass, fieldName) != null;
    }

    public static Field getField(Class<?> containingClass, String fieldName) {
        try {
            return containingClass.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static Method getSetterMethod(Class<?> containingClass, Class<?> propertyType, String propertyName) {
        String setterName = PROPERTY_MUTATOR_PREFIX + (String)(propertyName.isEmpty() ? "" : propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1));
        try {
            return containingClass.getMethod(setterName, propertyType);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getSetterMethod(Class<?> containingClass, String propertyName) {
        String setterName = PROPERTY_MUTATOR_PREFIX + (String)(propertyName.isEmpty() ? "" : propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1));
        Object[] methods = (Method[])Arrays.stream(containingClass.getMethods()).filter(method -> method.getName().equals(setterName)).toArray(Method[]::new);
        if (methods.length == 0) {
            return null;
        }
        if (methods.length > 1) {
            throw new IllegalStateException("The containingClass (" + containingClass + ") has multiple setter methods (" + Arrays.toString(methods) + ") with the propertyName (" + propertyName + ").");
        }
        return methods[0];
    }

    public static boolean isMethodOverwritten(Method parentMethod, Class<?> childClass) {
        Method leafMethod;
        try {
            leafMethod = childClass.getDeclaredMethod(parentMethod.getName(), parentMethod.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return !leafMethod.getDeclaringClass().equals(parentMethod.getClass());
    }

    public static void assertGetterMethod(Method getterMethod, Class<? extends Annotation> annotationClass) {
        if (getterMethod.getParameterTypes().length != 0) {
            throw new IllegalStateException("The getterMethod (" + getterMethod + ") with a " + annotationClass.getSimpleName() + " annotation must not have any parameters (" + Arrays.toString(getterMethod.getParameterTypes()) + ").");
        }
        String methodName = getterMethod.getName();
        if (methodName.startsWith(PROPERTY_ACCESSOR_PREFIX_GET)) {
            if (getterMethod.getReturnType() == Void.TYPE) {
                throw new IllegalStateException("The getterMethod (" + getterMethod + ") with a " + annotationClass.getSimpleName() + " annotation must have a non-void return type (" + getterMethod.getReturnType() + ").");
            }
        } else if (methodName.startsWith(PROPERTY_ACCESSOR_PREFIX_IS)) {
            if (getterMethod.getReturnType() != Boolean.TYPE) {
                throw new IllegalStateException("The getterMethod (" + getterMethod + ") with a " + annotationClass.getSimpleName() + " annotation must have a primitive boolean return type (" + getterMethod.getReturnType() + ") or use another prefix in its methodName (" + methodName + ").\nMaybe use 'get' instead of 'is'?");
            }
        } else {
            throw new IllegalStateException("The getterMethod (" + getterMethod + ") with a " + annotationClass.getSimpleName() + " annotation has a methodName (" + methodName + ") that does not start with a valid prefix (" + Arrays.toString(PROPERTY_ACCESSOR_PREFIXES) + ").");
        }
    }

    public static void assertReadMethod(Method readMethod, Class<? extends Annotation> annotationClass) {
        if (readMethod.getParameterTypes().length != 0) {
            throw new IllegalStateException("The readMethod (" + readMethod + ") with a " + annotationClass.getSimpleName() + " annotation must not have any parameters (" + Arrays.toString(readMethod.getParameterTypes()) + ").");
        }
        if (readMethod.getReturnType() == Void.TYPE) {
            throw new IllegalStateException("The readMethod (" + readMethod + ") with a " + annotationClass.getSimpleName() + " annotation must have a non-void return type (" + readMethod.getReturnType() + ").");
        }
    }

    public static boolean isMap(Type type) {
        if (type instanceof Class && Map.class.isAssignableFrom((Class)type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.isMap(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && ReflectionHelper.isMap(upperBounds[0]);
        }
        return false;
    }

    public static boolean isList(Type type) {
        if (type instanceof Class && List.class.isAssignableFrom((Class)type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.isList(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && ReflectionHelper.isList(upperBounds[0]);
        }
        return false;
    }

    public static List<Object> transformArrayToList(Object arrayObject) {
        if (arrayObject == null) {
            return null;
        }
        int arrayLength = Array.getLength(arrayObject);
        ArrayList<Object> list = new ArrayList<Object>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            list.add(Array.get(arrayObject, i));
        }
        return list;
    }

    private ReflectionHelper() {
    }
}

