/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.common.accessor;

import ai.timefold.solver.core.api.domain.common.DomainAccessType;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.impl.domain.common.ReflectionHelper;
import ai.timefold.solver.core.impl.domain.common.accessor.LambdaBeanPropertyMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.ReflectionBeanPropertyMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.ReflectionFieldMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.ReflectionMethodMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoClassLoader;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberAccessorFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class MemberAccessorFactory {
    static final String CLASSLOADER_NUDGE_MESSAGE = "Maybe add getClass().getClassLoader() as a parameter to the " + SolverFactory.class.getSimpleName() + ".create...() method call.";
    private final Map<String, MemberAccessor> memberAccessorCache;
    private final GizmoClassLoader gizmoClassLoader = new GizmoClassLoader();

    public static MemberAccessor buildMemberAccessor(Member member, MemberAccessorType memberAccessorType, Class<? extends Annotation> annotationClass, DomainAccessType domainAccessType, ClassLoader classLoader) {
        switch (domainAccessType) {
            case GIZMO: {
                return GizmoMemberAccessorFactory.buildGizmoMemberAccessor(member, annotationClass, (GizmoClassLoader)Objects.requireNonNull(classLoader));
            }
            case REFLECTION: {
                return MemberAccessorFactory.buildReflectiveMemberAccessor(member, memberAccessorType, annotationClass);
            }
        }
        throw new IllegalStateException("The domainAccessType (" + domainAccessType + ") is not implemented.");
    }

    private static MemberAccessor buildReflectiveMemberAccessor(Member member, MemberAccessorType memberAccessorType, Class<? extends Annotation> annotationClass) {
        if (member instanceof Field) {
            Field field = (Field)member;
            return new ReflectionFieldMemberAccessor(field);
        }
        if (member instanceof Method) {
            Method method = (Method)member;
            MemberAccessor memberAccessor = switch (memberAccessorType) {
                case MemberAccessorType.FIELD_OR_READ_METHOD -> {
                    if (!ReflectionHelper.isGetterMethod(method)) {
                        ReflectionHelper.assertReadMethod(method, annotationClass);
                        yield new ReflectionMethodMemberAccessor(method);
                    }
                }
                case MemberAccessorType.FIELD_OR_GETTER_METHOD, MemberAccessorType.FIELD_OR_GETTER_METHOD_WITH_SETTER -> {
                    boolean getterOnly = memberAccessorType != MemberAccessorType.FIELD_OR_GETTER_METHOD_WITH_SETTER;
                    ReflectionHelper.assertGetterMethod(method, annotationClass);
                    if (Modifier.isPublic(method.getModifiers()) && method.getDeclaringClass().getClassLoader().equals(MemberAccessor.class.getClassLoader())) {
                        yield new LambdaBeanPropertyMemberAccessor(method, getterOnly);
                    }
                    yield new ReflectionBeanPropertyMemberAccessor(method, getterOnly);
                }
                default -> throw new IllegalStateException("The memberAccessorType (" + memberAccessorType + ") is not implemented.");
            };
            if (memberAccessorType == MemberAccessorType.FIELD_OR_GETTER_METHOD_WITH_SETTER && !memberAccessor.supportSetter()) {
                throw new IllegalStateException("The class (" + method.getDeclaringClass() + ") has a @" + annotationClass.getSimpleName() + " annotated getter method (" + method + "), but lacks a setter for that property (" + memberAccessor.getName() + ").");
            }
            return memberAccessor;
        }
        throw new IllegalStateException("Impossible state: the member (" + member + ")'s type is not a " + Field.class.getSimpleName() + " or a " + Method.class.getSimpleName() + ".");
    }

    public MemberAccessorFactory() {
        this(null);
    }

    public MemberAccessorFactory(Map<String, MemberAccessor> memberAccessorMap) {
        this.memberAccessorCache = memberAccessorMap == null ? new ConcurrentHashMap<String, MemberAccessor>() : new ConcurrentHashMap<String, MemberAccessor>(memberAccessorMap);
    }

    public MemberAccessor buildAndCacheMemberAccessor(Member member, MemberAccessorType memberAccessorType, Class<? extends Annotation> annotationClass, DomainAccessType domainAccessType) {
        String generatedClassName = GizmoMemberAccessorFactory.getGeneratedClassName(member);
        return this.memberAccessorCache.computeIfAbsent(generatedClassName, k -> MemberAccessorFactory.buildMemberAccessor(member, memberAccessorType, annotationClass, domainAccessType, this.gizmoClassLoader));
    }

    public GizmoClassLoader getGizmoClassLoader() {
        return this.gizmoClassLoader;
    }

    public static enum MemberAccessorType {
        FIELD_OR_READ_METHOD,
        FIELD_OR_GETTER_METHOD,
        FIELD_OR_GETTER_METHOD_WITH_SETTER;

    }
}

