/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.common.accessor.gizmo;

import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberHandler;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Type;
import java.util.function.Consumer;

final class GizmoMethodHandler
implements GizmoMemberHandler {
    private final Class<?> declaringClass;
    private final MethodDescriptor methodDescriptor;

    GizmoMethodHandler(Class<?> declaringClass, MethodDescriptor methodDescriptor) {
        this.declaringClass = declaringClass;
        this.methodDescriptor = methodDescriptor;
    }

    @Override
    public void whenIsField(Consumer<FieldDescriptor> fieldDescriptorConsumer) {
    }

    @Override
    public void whenIsMethod(Consumer<MethodDescriptor> methodDescriptorConsumer) {
        methodDescriptorConsumer.accept(this.methodDescriptor);
    }

    @Override
    public ResultHandle readMemberValue(BytecodeCreator bytecodeCreator, ResultHandle thisObj) {
        return this.invokeMemberMethod(this.declaringClass, bytecodeCreator, this.methodDescriptor, thisObj, new ResultHandle[0]);
    }

    @Override
    public boolean writeMemberValue(MethodDescriptor setter, BytecodeCreator bytecodeCreator, ResultHandle thisObj, ResultHandle newValue) {
        if (setter == null) {
            return false;
        }
        this.invokeMemberMethod(this.declaringClass, bytecodeCreator, setter, thisObj, newValue);
        return true;
    }

    private ResultHandle invokeMemberMethod(Class<?> declaringClass, BytecodeCreator creator, MethodDescriptor method, ResultHandle bean, ResultHandle ... parameters) {
        if (declaringClass.isInterface()) {
            return creator.invokeInterfaceMethod(method, bean, parameters);
        }
        return creator.invokeVirtualMethod(method, bean, parameters);
    }

    @Override
    public String getDeclaringClassName() {
        return this.methodDescriptor.getDeclaringClass();
    }

    @Override
    public String getTypeName() {
        return this.methodDescriptor.getReturnType();
    }

    @Override
    public Type getType() {
        try {
            return this.declaringClass.getDeclaredMethod(this.methodDescriptor.getName(), new Class[0]).getGenericReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Cannot find method (" + this.methodDescriptor.getName() + ") on class (" + this.declaringClass + ").", e);
        }
    }

    public String toString() {
        return this.methodDescriptor.toString();
    }
}

