/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution.cloner.gizmo;

import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberDescriptor;
import ai.timefold.solver.core.impl.domain.solution.cloner.DeepCloningUtils;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class GizmoSolutionOrEntityDescriptor {
    SolutionDescriptor<?> solutionDescriptor;
    Map<Field, GizmoMemberDescriptor> solutionFieldToMemberDescriptorMap;
    Set<Field> deepClonedFields;
    Set<Field> shallowlyClonedFields;

    public GizmoSolutionOrEntityDescriptor(SolutionDescriptor<?> solutionDescriptor, Class<?> entityOrSolutionClass) {
        this(solutionDescriptor, entityOrSolutionClass, GizmoSolutionOrEntityDescriptor.getFieldsToSolutionFieldToMemberDescriptorMap(entityOrSolutionClass, new HashMap<Field, GizmoMemberDescriptor>()));
    }

    public GizmoSolutionOrEntityDescriptor(SolutionDescriptor<?> solutionDescriptor, Class<?> entityOrSolutionClass, Map<Field, GizmoMemberDescriptor> solutionFieldToMemberDescriptorMap) {
        this.solutionDescriptor = solutionDescriptor;
        this.solutionFieldToMemberDescriptorMap = solutionFieldToMemberDescriptorMap;
        this.deepClonedFields = new HashSet<Field>();
        this.shallowlyClonedFields = new HashSet<Field>();
        for (Field field : solutionFieldToMemberDescriptorMap.keySet()) {
            if (DeepCloningUtils.isDeepCloned(solutionDescriptor, field, entityOrSolutionClass, field.getType())) {
                this.deepClonedFields.add(field);
                continue;
            }
            this.shallowlyClonedFields.add(field);
        }
    }

    private static Map<Field, GizmoMemberDescriptor> getFieldsToSolutionFieldToMemberDescriptorMap(Class<?> clazz, Map<Field, GizmoMemberDescriptor> solutionFieldToMemberDescriptorMap) {
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            solutionFieldToMemberDescriptorMap.put(field, new GizmoMemberDescriptor(field));
        }
        if (clazz.getSuperclass() != null) {
            GizmoSolutionOrEntityDescriptor.getFieldsToSolutionFieldToMemberDescriptorMap(clazz.getSuperclass(), solutionFieldToMemberDescriptorMap);
        }
        return solutionFieldToMemberDescriptorMap;
    }

    public SolutionDescriptor<?> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public Set<GizmoMemberDescriptor> getShallowClonedMemberDescriptors() {
        return this.solutionFieldToMemberDescriptorMap.keySet().stream().filter(field -> this.shallowlyClonedFields.contains(field)).map(this.solutionFieldToMemberDescriptorMap::get).collect(Collectors.toSet());
    }

    public Set<Field> getDeepClonedFields() {
        return this.deepClonedFields;
    }

    public GizmoMemberDescriptor getMemberDescriptorForField(Field field) {
        return this.solutionFieldToMemberDescriptorMap.get(field);
    }
}

