/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution.descriptor;

import ai.timefold.solver.core.api.domain.autodiscover.AutoDiscoverMemberType;
import ai.timefold.solver.core.api.domain.common.DomainAccessType;
import ai.timefold.solver.core.api.domain.constraintweight.ConstraintConfiguration;
import ai.timefold.solver.core.api.domain.constraintweight.ConstraintConfigurationProvider;
import ai.timefold.solver.core.api.domain.entity.PlanningEntity;
import ai.timefold.solver.core.api.domain.solution.PlanningEntityCollectionProperty;
import ai.timefold.solver.core.api.domain.solution.PlanningEntityProperty;
import ai.timefold.solver.core.api.domain.solution.PlanningScore;
import ai.timefold.solver.core.api.domain.solution.PlanningSolution;
import ai.timefold.solver.core.api.domain.solution.ProblemFactCollectionProperty;
import ai.timefold.solver.core.api.domain.solution.ProblemFactProperty;
import ai.timefold.solver.core.api.domain.solution.cloner.SolutionCloner;
import ai.timefold.solver.core.api.domain.valuerange.ValueRangeProvider;
import ai.timefold.solver.core.api.score.IBendableScore;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.common.ReflectionHelper;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import ai.timefold.solver.core.impl.domain.common.accessor.ReflectionFieldMemberAccessor;
import ai.timefold.solver.core.impl.domain.constraintweight.descriptor.ConstraintConfigurationDescriptor;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.lookup.ClassAndPlanningIdComparator;
import ai.timefold.solver.core.impl.domain.lookup.LookUpStrategyResolver;
import ai.timefold.solver.core.impl.domain.policy.DescriptorPolicy;
import ai.timefold.solver.core.impl.domain.score.descriptor.ScoreDescriptor;
import ai.timefold.solver.core.impl.domain.solution.cloner.FieldAccessingSolutionCloner;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionClonerFactory;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.score.definition.AbstractBendableScoreDefinition;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.util.MutableInt;
import ai.timefold.solver.core.impl.util.MutableLong;
import ai.timefold.solver.core.impl.util.MutablePair;
import ai.timefold.solver.core.impl.util.Pair;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionDescriptor<Solution_> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolutionDescriptor.class);
    private static final EntityDescriptor<?> NULL_ENTITY_DESCRIPTOR = new EntityDescriptor(null, PlanningEntity.class);
    private final Class<Solution_> solutionClass;
    private final MemberAccessorFactory memberAccessorFactory;
    private DomainAccessType domainAccessType;
    private AutoDiscoverMemberType autoDiscoverMemberType;
    private LookUpStrategyResolver lookUpStrategyResolver;
    private MemberAccessor constraintConfigurationMemberAccessor;
    private final Map<String, MemberAccessor> problemFactMemberAccessorMap = new LinkedHashMap<String, MemberAccessor>();
    private final Map<String, MemberAccessor> problemFactCollectionMemberAccessorMap = new LinkedHashMap<String, MemberAccessor>();
    private final Map<String, MemberAccessor> entityMemberAccessorMap = new LinkedHashMap<String, MemberAccessor>();
    private final Map<String, MemberAccessor> entityCollectionMemberAccessorMap = new LinkedHashMap<String, MemberAccessor>();
    private Set<Class<?>> problemFactOrEntityClassSet;
    private List<ListVariableDescriptor<Solution_>> listVariableDescriptors;
    private ScoreDescriptor scoreDescriptor;
    private ConstraintConfigurationDescriptor<Solution_> constraintConfigurationDescriptor;
    private final Map<Class<?>, EntityDescriptor<Solution_>> entityDescriptorMap = new LinkedHashMap();
    private final List<Class<?>> reversedEntityClassList = new ArrayList();
    private final ConcurrentMap<Class<?>, EntityDescriptor<Solution_>> lowestEntityDescriptorMap = new ConcurrentHashMap();
    private SolutionCloner<Solution_> solutionCloner;
    private boolean assertModelForCloning = false;
    private Comparator<Object> classAndPlanningIdComparator;

    public static <Solution_> SolutionDescriptor<Solution_> buildSolutionDescriptor(Class<Solution_> solutionClass, Class<?> ... entityClasses) {
        return SolutionDescriptor.buildSolutionDescriptor(solutionClass, Arrays.asList(entityClasses));
    }

    public static <Solution_> SolutionDescriptor<Solution_> buildSolutionDescriptor(Class<Solution_> solutionClass, List<Class<?>> entityClassList) {
        return SolutionDescriptor.buildSolutionDescriptor(DomainAccessType.REFLECTION, solutionClass, null, null, entityClassList);
    }

    public static <Solution_> SolutionDescriptor<Solution_> buildSolutionDescriptor(DomainAccessType domainAccessType, Class<Solution_> solutionClass, Map<String, MemberAccessor> memberAccessorMap, Map<String, SolutionCloner> solutionClonerMap, List<Class<?>> entityClassList) {
        solutionClonerMap = Objects.requireNonNullElse(solutionClonerMap, Collections.emptyMap());
        SolutionDescriptor<Solution_> solutionDescriptor = new SolutionDescriptor<Solution_>(solutionClass, memberAccessorMap);
        DescriptorPolicy descriptorPolicy = new DescriptorPolicy();
        descriptorPolicy.setDomainAccessType(domainAccessType);
        descriptorPolicy.setGeneratedSolutionClonerMap(solutionClonerMap);
        descriptorPolicy.setMemberAccessorFactory(solutionDescriptor.getMemberAccessorFactory());
        solutionDescriptor.processAnnotations(descriptorPolicy, entityClassList);
        for (Class<?> entityClass : SolutionDescriptor.sortEntityClassList(entityClassList)) {
            EntityDescriptor<Solution_> entityDescriptor = new EntityDescriptor<Solution_>(solutionDescriptor, entityClass);
            solutionDescriptor.addEntityDescriptor(entityDescriptor);
            entityDescriptor.processAnnotations(descriptorPolicy);
        }
        solutionDescriptor.afterAnnotationsProcessed(descriptorPolicy);
        return solutionDescriptor;
    }

    private static List<Class<?>> sortEntityClassList(List<Class<?>> entityClassList) {
        ArrayList sortedEntityClassList = new ArrayList(entityClassList.size());
        for (Class<?> entityClass : entityClassList) {
            boolean added = false;
            for (int i = 0; i < sortedEntityClassList.size(); ++i) {
                Class sortedEntityClass = (Class)sortedEntityClassList.get(i);
                if (!entityClass.isAssignableFrom(sortedEntityClass)) continue;
                sortedEntityClassList.add(i, entityClass);
                added = true;
                break;
            }
            if (added) continue;
            sortedEntityClassList.add(entityClass);
        }
        return sortedEntityClassList;
    }

    private SolutionDescriptor(Class<Solution_> solutionClass, Map<String, MemberAccessor> memberAccessorMap) {
        this.solutionClass = solutionClass;
        if (solutionClass.getPackage() == null) {
            LOGGER.warn("The solutionClass ({}) should be in a proper java package.", solutionClass);
        }
        this.memberAccessorFactory = new MemberAccessorFactory(memberAccessorMap);
    }

    public void addEntityDescriptor(EntityDescriptor<Solution_> entityDescriptor) {
        Class<?> entityClass = entityDescriptor.getEntityClass();
        for (Class<?> otherEntityClass : this.entityDescriptorMap.keySet()) {
            if (!entityClass.isAssignableFrom(otherEntityClass)) continue;
            throw new IllegalArgumentException("An earlier entityClass (" + otherEntityClass + ") should not be a subclass of a later entityClass (" + entityClass + "). Switch their declaration so superclasses are defined earlier.");
        }
        this.entityDescriptorMap.put(entityClass, entityDescriptor);
        this.reversedEntityClassList.add(0, entityClass);
        this.lowestEntityDescriptorMap.put(entityClass, entityDescriptor);
    }

    public void processAnnotations(DescriptorPolicy descriptorPolicy, List<Class<?>> entityClassList) {
        this.domainAccessType = descriptorPolicy.getDomainAccessType();
        this.classAndPlanningIdComparator = new ClassAndPlanningIdComparator(this.memberAccessorFactory, this.domainAccessType, false);
        this.processSolutionAnnotations(descriptorPolicy);
        ArrayList potentiallyOverwritingMethodList = new ArrayList();
        for (Class<?> lineageClass : ConfigUtils.getAllAnnotatedLineageClasses(this.solutionClass, PlanningSolution.class)) {
            List<Member> memberList = ConfigUtils.getDeclaredMembers(lineageClass);
            for (Member member2 : memberList) {
                if (member2 instanceof Method && potentiallyOverwritingMethodList.stream().anyMatch(m -> member2.getName().equals(m.getName()) && ReflectionHelper.isMethodOverwritten((Method)member2, m.getDeclaringClass()))) continue;
                this.processValueRangeProviderAnnotation(descriptorPolicy, member2);
                this.processFactEntityOrScoreAnnotation(descriptorPolicy, member2, entityClassList);
            }
            potentiallyOverwritingMethodList.ensureCapacity(potentiallyOverwritingMethodList.size() + memberList.size());
            memberList.stream().filter(member -> member instanceof Method).forEach(member -> potentiallyOverwritingMethodList.add((Method)member));
        }
        if (this.entityCollectionMemberAccessorMap.isEmpty() && this.entityMemberAccessorMap.isEmpty()) {
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") must have at least 1 member with a " + PlanningEntityCollectionProperty.class.getSimpleName() + " annotation or a " + PlanningEntityProperty.class.getSimpleName() + " annotation.");
        }
        if (this.scoreDescriptor == null) {
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") must have 1 member with a @" + PlanningScore.class.getSimpleName() + " annotation.\nMaybe add a getScore() method with a @" + PlanningScore.class.getSimpleName() + " annotation.");
        }
        if (this.constraintConfigurationMemberAccessor != null) {
            this.constraintConfigurationDescriptor.processAnnotations(descriptorPolicy, this.scoreDescriptor.getScoreDefinition());
        }
    }

    private void processSolutionAnnotations(DescriptorPolicy descriptorPolicy) {
        PlanningSolution solutionAnnotation = this.solutionClass.getAnnotation(PlanningSolution.class);
        if (solutionAnnotation == null) {
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has been specified as a solution in the configuration, but does not have a @" + PlanningSolution.class.getSimpleName() + " annotation.");
        }
        this.autoDiscoverMemberType = solutionAnnotation.autoDiscoverMemberType();
        Class<? extends SolutionCloner> solutionClonerClass = solutionAnnotation.solutionCloner();
        if (solutionClonerClass != PlanningSolution.NullSolutionCloner.class) {
            this.solutionCloner = ConfigUtils.newInstance(this::toString, "solutionClonerClass", solutionClonerClass);
        }
        this.lookUpStrategyResolver = new LookUpStrategyResolver(descriptorPolicy, solutionAnnotation.lookUpStrategyType());
    }

    private void processValueRangeProviderAnnotation(DescriptorPolicy descriptorPolicy, Member member) {
        if (((AnnotatedElement)((Object)member)).isAnnotationPresent(ValueRangeProvider.class)) {
            MemberAccessor memberAccessor = descriptorPolicy.getMemberAccessorFactory().buildAndCacheMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_READ_METHOD, ValueRangeProvider.class, descriptorPolicy.getDomainAccessType());
            descriptorPolicy.addFromSolutionValueRangeProvider(memberAccessor);
        }
    }

    private void processFactEntityOrScoreAnnotation(DescriptorPolicy descriptorPolicy, Member member, List<Class<?>> entityClassList) {
        Class<Annotation> annotationClass = this.extractFactEntityOrScoreAnnotationClassOrAutoDiscover(member, entityClassList);
        if (annotationClass == null) {
            return;
        }
        if (annotationClass.equals(ConstraintConfigurationProvider.class)) {
            this.processConstraintConfigurationProviderAnnotation(descriptorPolicy, member, annotationClass);
        } else if (annotationClass.equals(ProblemFactProperty.class) || annotationClass.equals(ProblemFactCollectionProperty.class)) {
            this.processProblemFactPropertyAnnotation(descriptorPolicy, member, annotationClass);
        } else if (annotationClass.equals(PlanningEntityProperty.class) || annotationClass.equals(PlanningEntityCollectionProperty.class)) {
            this.processPlanningEntityPropertyAnnotation(descriptorPolicy, member, annotationClass);
        } else if (annotationClass.equals(PlanningScore.class)) {
            if (this.scoreDescriptor == null) {
                this.scoreDescriptor = ScoreDescriptor.buildScoreDescriptor(descriptorPolicy, member, this.solutionClass);
            } else {
                this.scoreDescriptor.failFastOnDuplicateMember(descriptorPolicy, member, this.solutionClass);
            }
        }
    }

    private Class<? extends Annotation> extractFactEntityOrScoreAnnotationClassOrAutoDiscover(Member member, List<Class<?>> entityClassList) {
        Class annotationClass = ConfigUtils.extractAnnotationClass(member, ConstraintConfigurationProvider.class, ProblemFactProperty.class, ProblemFactCollectionProperty.class, PlanningEntityProperty.class, PlanningEntityCollectionProperty.class, PlanningScore.class);
        if (annotationClass == null) {
            Class<?> type;
            if (this.autoDiscoverMemberType == AutoDiscoverMemberType.FIELD && member instanceof Field) {
                Field field = (Field)member;
                type = field.getType();
            } else if (this.autoDiscoverMemberType == AutoDiscoverMemberType.GETTER && member instanceof Method && ReflectionHelper.isGetterMethod((Method)member)) {
                Method method = (Method)member;
                type = method.getReturnType();
            } else {
                type = null;
            }
            if (type != null) {
                if (Score.class.isAssignableFrom(type)) {
                    annotationClass = PlanningScore.class;
                } else if (Collection.class.isAssignableFrom(type) || type.isArray()) {
                    Class<Object> elementType;
                    if (Collection.class.isAssignableFrom(type)) {
                        Type genericType = member instanceof Field ? ((Field)member).getGenericType() : ((Method)member).getGenericReturnType();
                        String memberName = member.getName();
                        if (!(genericType instanceof ParameterizedType)) {
                            throw new IllegalArgumentException("The solutionClass (" + this.solutionClass + ") has a auto discovered member (" + memberName + ") with a member type (" + type + ") that returns a " + Collection.class.getSimpleName() + " which has no generic parameters.\nMaybe the member (" + memberName + ") should return a typed " + Collection.class.getSimpleName() + ".");
                        }
                        elementType = ConfigUtils.extractCollectionGenericTypeParameterLeniently("solutionClass", this.solutionClass, type, genericType, null, member.getName()).orElse(Object.class);
                    } else {
                        elementType = type.getComponentType();
                    }
                    if (entityClassList.stream().anyMatch(entityClass -> entityClass.isAssignableFrom(elementType))) {
                        annotationClass = PlanningEntityCollectionProperty.class;
                    } else {
                        if (elementType.isAnnotationPresent(ConstraintConfiguration.class)) {
                            throw new IllegalStateException("The autoDiscoverMemberType (" + this.autoDiscoverMemberType + ") cannot accept a member (" + member + ") of type (" + type + ") with an elementType (" + elementType + ") that has a @" + ConstraintConfiguration.class.getSimpleName() + " annotation.\nMaybe use a member of the type (" + elementType + ") directly instead of a " + Collection.class.getSimpleName() + " or array of that type.");
                        }
                        annotationClass = ProblemFactCollectionProperty.class;
                    }
                } else {
                    if (Map.class.isAssignableFrom(type)) {
                        throw new IllegalStateException("The autoDiscoverMemberType (" + this.autoDiscoverMemberType + ") does not yet support the member (" + member + ") of type (" + type + ") which is an implementation of " + Map.class.getSimpleName() + ".");
                    }
                    annotationClass = entityClassList.stream().anyMatch(entityClass -> entityClass.isAssignableFrom(type)) ? PlanningEntityProperty.class : (type.isAnnotationPresent(ConstraintConfiguration.class) ? ConstraintConfigurationProvider.class : ProblemFactProperty.class);
                }
            }
        }
        return annotationClass;
    }

    private void processConstraintConfigurationProviderAnnotation(DescriptorPolicy descriptorPolicy, Member member, Class<? extends Annotation> annotationClass) {
        MemberAccessor memberAccessor = descriptorPolicy.getMemberAccessorFactory().buildAndCacheMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_READ_METHOD, annotationClass, descriptorPolicy.getDomainAccessType());
        if (this.constraintConfigurationMemberAccessor != null) {
            if (!this.constraintConfigurationMemberAccessor.getName().equals(memberAccessor.getName()) || !this.constraintConfigurationMemberAccessor.getClass().equals(memberAccessor.getClass())) {
                throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has a @" + ConstraintConfigurationProvider.class.getSimpleName() + " annotated member (" + memberAccessor + ") that is duplicated by another member (" + this.constraintConfigurationMemberAccessor + ").\nMaybe the annotation is defined on both the field and its getter.");
            }
            return;
        }
        this.assertNoFieldAndGetterDuplicationOrConflict(memberAccessor, annotationClass);
        this.constraintConfigurationMemberAccessor = memberAccessor;
        this.problemFactMemberAccessorMap.put(memberAccessor.getName(), memberAccessor);
        Class<?> constraintConfigurationClass = this.constraintConfigurationMemberAccessor.getType();
        if (!constraintConfigurationClass.isAnnotationPresent(ConstraintConfiguration.class)) {
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has a @" + ConstraintConfigurationProvider.class.getSimpleName() + " annotated member (" + member + ") that does not return a class (" + constraintConfigurationClass + ") that has a " + ConstraintConfiguration.class.getSimpleName() + " annotation.");
        }
        this.constraintConfigurationDescriptor = new ConstraintConfigurationDescriptor(this, constraintConfigurationClass);
    }

    private void processProblemFactPropertyAnnotation(DescriptorPolicy descriptorPolicy, Member member, Class<? extends Annotation> annotationClass) {
        MemberAccessor memberAccessor = descriptorPolicy.getMemberAccessorFactory().buildAndCacheMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_READ_METHOD, annotationClass, descriptorPolicy.getDomainAccessType());
        this.assertNoFieldAndGetterDuplicationOrConflict(memberAccessor, annotationClass);
        if (annotationClass == ProblemFactProperty.class) {
            this.problemFactMemberAccessorMap.put(memberAccessor.getName(), memberAccessor);
        } else if (annotationClass == ProblemFactCollectionProperty.class) {
            Class<?> type = memberAccessor.getType();
            if (!Collection.class.isAssignableFrom(type) && !type.isArray()) {
                throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has a @" + ProblemFactCollectionProperty.class.getSimpleName() + " annotated member (" + member + ") that does not return a " + Collection.class.getSimpleName() + " or an array.");
            }
            this.problemFactCollectionMemberAccessorMap.put(memberAccessor.getName(), memberAccessor);
        } else {
            throw new IllegalStateException("Impossible situation with annotationClass (" + annotationClass + ").");
        }
    }

    private void processPlanningEntityPropertyAnnotation(DescriptorPolicy descriptorPolicy, Member member, Class<? extends Annotation> annotationClass) {
        MemberAccessor memberAccessor = descriptorPolicy.getMemberAccessorFactory().buildAndCacheMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_GETTER_METHOD, annotationClass, descriptorPolicy.getDomainAccessType());
        this.assertNoFieldAndGetterDuplicationOrConflict(memberAccessor, annotationClass);
        if (annotationClass == PlanningEntityProperty.class) {
            this.entityMemberAccessorMap.put(memberAccessor.getName(), memberAccessor);
        } else if (annotationClass == PlanningEntityCollectionProperty.class) {
            Class<?> type = memberAccessor.getType();
            if (!Collection.class.isAssignableFrom(type) && !type.isArray()) {
                throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has a @" + PlanningEntityCollectionProperty.class.getSimpleName() + " annotated member (" + member + ") that does not return a " + Collection.class.getSimpleName() + " or an array.");
            }
            this.entityCollectionMemberAccessorMap.put(memberAccessor.getName(), memberAccessor);
        } else {
            throw new IllegalStateException("Impossible situation with annotationClass (" + annotationClass + ").");
        }
    }

    private void assertNoFieldAndGetterDuplicationOrConflict(MemberAccessor memberAccessor, Class<? extends Annotation> annotationClass) {
        Class otherAnnotationClass;
        MemberAccessor duplicate;
        String memberName = memberAccessor.getName();
        if (this.constraintConfigurationMemberAccessor != null && this.constraintConfigurationMemberAccessor.getName().equals(memberName)) {
            duplicate = this.constraintConfigurationMemberAccessor;
            otherAnnotationClass = ConstraintConfigurationProvider.class;
        } else if (this.problemFactMemberAccessorMap.containsKey(memberName)) {
            duplicate = this.problemFactMemberAccessorMap.get(memberName);
            otherAnnotationClass = ProblemFactProperty.class;
        } else if (this.problemFactCollectionMemberAccessorMap.containsKey(memberName)) {
            duplicate = this.problemFactCollectionMemberAccessorMap.get(memberName);
            otherAnnotationClass = ProblemFactCollectionProperty.class;
        } else if (this.entityMemberAccessorMap.containsKey(memberName)) {
            duplicate = this.entityMemberAccessorMap.get(memberName);
            otherAnnotationClass = PlanningEntityProperty.class;
        } else if (this.entityCollectionMemberAccessorMap.containsKey(memberName)) {
            duplicate = this.entityCollectionMemberAccessorMap.get(memberName);
            otherAnnotationClass = PlanningEntityCollectionProperty.class;
        } else {
            return;
        }
        throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has a @" + annotationClass.getSimpleName() + " annotated member (" + memberAccessor + ") that is duplicated by a @" + otherAnnotationClass.getSimpleName() + " annotated member (" + duplicate + ").\n" + (annotationClass.equals(otherAnnotationClass) ? "Maybe the annotation is defined on both the field and its getter." : "Maybe 2 mutually exclusive annotations are configured."));
    }

    private void afterAnnotationsProcessed(DescriptorPolicy descriptorPolicy) {
        for (EntityDescriptor<Solution_> entityDescriptor : this.entityDescriptorMap.values()) {
            entityDescriptor.linkEntityDescriptors(descriptorPolicy);
        }
        for (EntityDescriptor<Solution_> entityDescriptor : this.entityDescriptorMap.values()) {
            entityDescriptor.linkVariableDescriptors(descriptorPolicy);
        }
        this.determineGlobalShadowOrder();
        this.problemFactOrEntityClassSet = this.collectEntityAndProblemFactClasses();
        this.listVariableDescriptors = this.findListVariableDescriptors();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("    Model annotations parsed for solution {}:", (Object)this.solutionClass.getSimpleName());
            for (Map.Entry entry : this.entityDescriptorMap.entrySet()) {
                EntityDescriptor entityDescriptor = (EntityDescriptor)entry.getValue();
                LOGGER.trace("        Entity {}:", (Object)entityDescriptor.getEntityClass().getSimpleName());
                for (VariableDescriptor variableDescriptor : entityDescriptor.getDeclaredVariableDescriptors()) {
                    LOGGER.trace("            {} variable {} ({})", new Object[]{variableDescriptor instanceof GenuineVariableDescriptor ? "Genuine" : "Shadow", variableDescriptor.getVariableName(), variableDescriptor.getMemberAccessorSpeedNote()});
                }
            }
        }
        this.initSolutionCloner(descriptorPolicy);
    }

    private void determineGlobalShadowOrder() {
        ArrayList<MutablePair> pairList = new ArrayList<MutablePair>();
        HashMap<ShadowVariableDescriptor<Solution_>, MutablePair<ShadowVariableDescriptor<Solution_>, Integer>> shadowToPairMap = new HashMap<ShadowVariableDescriptor<Solution_>, MutablePair<ShadowVariableDescriptor<Solution_>, Integer>>();
        for (EntityDescriptor<Solution_> entityDescriptor : this.entityDescriptorMap.values()) {
            for (ShadowVariableDescriptor<Solution_> shadowVariableDescriptor : entityDescriptor.getDeclaredShadowVariableDescriptors()) {
                int sourceSize = shadowVariableDescriptor.getSourceVariableDescriptorList().size();
                MutablePair<ShadowVariableDescriptor<Solution_>, Integer> pair = MutablePair.of(shadowVariableDescriptor, sourceSize);
                pairList.add(pair);
                shadowToPairMap.put(shadowVariableDescriptor, pair);
            }
        }
        for (EntityDescriptor<Solution_> entityDescriptor : this.entityDescriptorMap.values()) {
            for (GenuineVariableDescriptor genuineVariableDescriptor : entityDescriptor.getDeclaredGenuineVariableDescriptors()) {
                for (ShadowVariableDescriptor sink : genuineVariableDescriptor.getSinkVariableDescriptorList()) {
                    MutablePair sinkPair = (MutablePair)shadowToPairMap.get(sink);
                    sinkPair.setValue((Integer)sinkPair.getValue() - 1);
                }
            }
        }
        int globalShadowOrder = 0;
        while (!pairList.isEmpty()) {
            pairList.sort(Comparator.comparingInt(Pair::getValue));
            Pair pair = (Pair)pairList.remove(0);
            ShadowVariableDescriptor shadow = (ShadowVariableDescriptor)pair.getKey();
            if ((Integer)pair.getValue() != 0) {
                if ((Integer)pair.getValue() < 0) {
                    throw new IllegalStateException("Impossible state because the shadowVariable (" + shadow.getSimpleEntityAndVariableName() + ") cannot be used more as a sink than it has sources.");
                }
                throw new IllegalStateException("There is a cyclic shadow variable path that involves the shadowVariable (" + shadow.getSimpleEntityAndVariableName() + ") because it must be later than its sources (" + shadow.getSourceVariableDescriptorList() + ") and also earlier than its sinks (" + shadow.getSinkVariableDescriptorList() + ").");
            }
            for (ShadowVariableDescriptor sink : shadow.getSinkVariableDescriptorList()) {
                MutablePair sinkPair = (MutablePair)shadowToPairMap.get(sink);
                sinkPair.setValue((Integer)sinkPair.getValue() - 1);
            }
            shadow.setGlobalShadowOrder(globalShadowOrder);
            ++globalShadowOrder;
        }
    }

    private Set<Class<?>> collectEntityAndProblemFactClasses() {
        Stream entityClassStream = this.entityDescriptorMap.keySet().stream();
        Stream<Class> factClassStream = this.problemFactMemberAccessorMap.values().stream().map(MemberAccessor::getType);
        Stream<Class> problemFactOrEntityClassStream = Stream.concat(entityClassStream, factClassStream);
        Stream<Class> factCollectionClassStream = this.problemFactCollectionMemberAccessorMap.values().stream().map(accessor -> ConfigUtils.extractCollectionGenericTypeParameterLeniently("solutionClass", this.getSolutionClass(), accessor.getType(), accessor.getGenericType(), ProblemFactCollectionProperty.class, accessor.getName()).orElse(Object.class));
        problemFactOrEntityClassStream = Stream.concat(problemFactOrEntityClassStream, factCollectionClassStream);
        if (this.constraintConfigurationDescriptor != null) {
            problemFactOrEntityClassStream = Stream.concat(problemFactOrEntityClassStream, Stream.of(this.constraintConfigurationDescriptor.getConstraintConfigurationClass()));
        }
        return problemFactOrEntityClassStream.collect(Collectors.toSet());
    }

    private List<ListVariableDescriptor<Solution_>> findListVariableDescriptors() {
        return this.getGenuineEntityDescriptors().stream().map(EntityDescriptor::getGenuineVariableDescriptorList).flatMap(Collection::stream).filter(GenuineVariableDescriptor::isListVariable).map(variableDescriptor -> (ListVariableDescriptor)variableDescriptor).collect(Collectors.toList());
    }

    private void initSolutionCloner(DescriptorPolicy descriptorPolicy) {
        SolutionCloner<Solution_> solutionCloner = this.solutionCloner = this.solutionCloner == null ? descriptorPolicy.getGeneratedSolutionClonerMap().get(GizmoSolutionClonerFactory.getGeneratedClassName(this)) : this.solutionCloner;
        if (this.solutionCloner == null) {
            switch (descriptorPolicy.getDomainAccessType()) {
                case GIZMO: {
                    this.solutionCloner = GizmoSolutionClonerFactory.build(this, this.memberAccessorFactory.getGizmoClassLoader());
                    break;
                }
                case REFLECTION: {
                    this.solutionCloner = new FieldAccessingSolutionCloner(this);
                    break;
                }
                default: {
                    throw new IllegalStateException("The domainAccessType (" + this.domainAccessType + ") is not implemented.");
                }
            }
        }
        if (this.assertModelForCloning) {
            // empty if block
        }
    }

    public Class<Solution_> getSolutionClass() {
        return this.solutionClass;
    }

    public MemberAccessorFactory getMemberAccessorFactory() {
        return this.memberAccessorFactory;
    }

    public DomainAccessType getDomainAccessType() {
        return this.domainAccessType;
    }

    public ScoreDefinition getScoreDefinition() {
        return this.scoreDescriptor.getScoreDefinition();
    }

    public Map<String, MemberAccessor> getProblemFactMemberAccessorMap() {
        return this.problemFactMemberAccessorMap;
    }

    public Map<String, MemberAccessor> getProblemFactCollectionMemberAccessorMap() {
        return this.problemFactCollectionMemberAccessorMap;
    }

    public List<String> getProblemFactMemberAndProblemFactCollectionMemberNames() {
        ArrayList<String> memberNames = new ArrayList<String>(this.problemFactMemberAccessorMap.size() + this.problemFactCollectionMemberAccessorMap.size());
        memberNames.addAll(this.problemFactMemberAccessorMap.keySet());
        memberNames.addAll(this.problemFactCollectionMemberAccessorMap.keySet());
        return memberNames;
    }

    public Map<String, MemberAccessor> getEntityMemberAccessorMap() {
        return this.entityMemberAccessorMap;
    }

    public Map<String, MemberAccessor> getEntityCollectionMemberAccessorMap() {
        return this.entityCollectionMemberAccessorMap;
    }

    public List<String> getEntityMemberAndEntityCollectionMemberNames() {
        ArrayList<String> memberNames = new ArrayList<String>(this.entityMemberAccessorMap.size() + this.entityCollectionMemberAccessorMap.size());
        memberNames.addAll(this.entityMemberAccessorMap.keySet());
        memberNames.addAll(this.entityCollectionMemberAccessorMap.keySet());
        return memberNames;
    }

    public Set<Class<?>> getProblemFactOrEntityClassSet() {
        return this.problemFactOrEntityClassSet;
    }

    public List<ListVariableDescriptor<Solution_>> getListVariableDescriptors() {
        return this.listVariableDescriptors;
    }

    public SolutionCloner<Solution_> getSolutionCloner() {
        return this.solutionCloner;
    }

    public Comparator<Object> getClassAndPlanningIdComparator() {
        return this.classAndPlanningIdComparator;
    }

    public void setAssertModelForCloning(boolean assertModelForCloning) {
        this.assertModelForCloning = assertModelForCloning;
    }

    public MemberAccessor getConstraintConfigurationMemberAccessor() {
        return this.constraintConfigurationMemberAccessor;
    }

    public ConstraintConfigurationDescriptor<Solution_> getConstraintConfigurationDescriptor() {
        return this.constraintConfigurationDescriptor;
    }

    public Set<Class<?>> getEntityClassSet() {
        return this.entityDescriptorMap.keySet();
    }

    public Collection<EntityDescriptor<Solution_>> getEntityDescriptors() {
        return this.entityDescriptorMap.values();
    }

    public Collection<EntityDescriptor<Solution_>> getGenuineEntityDescriptors() {
        ArrayList<EntityDescriptor<Solution_>> genuineEntityDescriptorList = new ArrayList<EntityDescriptor<Solution_>>(this.entityDescriptorMap.size());
        for (EntityDescriptor<Solution_> entityDescriptor : this.entityDescriptorMap.values()) {
            if (!entityDescriptor.hasAnyDeclaredGenuineVariableDescriptor()) continue;
            genuineEntityDescriptorList.add(entityDescriptor);
        }
        return genuineEntityDescriptorList;
    }

    public EntityDescriptor<Solution_> getEntityDescriptorStrict(Class<?> entityClass) {
        return this.entityDescriptorMap.get(entityClass);
    }

    public boolean hasEntityDescriptor(Class<?> entitySubclass) {
        EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptor(entitySubclass);
        return entityDescriptor != null;
    }

    public EntityDescriptor<Solution_> findEntityDescriptorOrFail(Class<?> entitySubclass) {
        EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptor(entitySubclass);
        if (entityDescriptor == null) {
            throw new IllegalArgumentException("A planning entity is an instance of a class (" + entitySubclass + ") that is not configured as a planning entity class (" + this.getEntityClassSet() + ").\nIf that class (" + entitySubclass.getSimpleName() + ") (or superclass thereof) is not a @" + PlanningEntity.class.getSimpleName() + " annotated class, maybe your @" + PlanningSolution.class.getSimpleName() + " annotated class has an incorrect @" + PlanningEntityCollectionProperty.class.getSimpleName() + " or @" + PlanningEntityProperty.class.getSimpleName() + " annotated member.\nOtherwise, if you're not using the Quarkus extension or Spring Boot starter, maybe that entity class (" + entitySubclass.getSimpleName() + ") is missing from your solver configuration.");
        }
        return entityDescriptor;
    }

    public EntityDescriptor<Solution_> findEntityDescriptor(Class<?> entitySubclass) {
        EntityDescriptor cachedEntityDescriptor = (EntityDescriptor)this.lowestEntityDescriptorMap.get(entitySubclass);
        if (cachedEntityDescriptor == NULL_ENTITY_DESCRIPTOR) {
            return null;
        }
        if (cachedEntityDescriptor != null) {
            return cachedEntityDescriptor;
        }
        EntityDescriptor<Solution_> newEntityDescriptor = this.innerFindEntityDescriptor(entitySubclass);
        if (newEntityDescriptor == null) {
            this.lowestEntityDescriptorMap.put(entitySubclass, NULL_ENTITY_DESCRIPTOR);
            return null;
        }
        this.lowestEntityDescriptorMap.put(entitySubclass, newEntityDescriptor);
        return newEntityDescriptor;
    }

    private EntityDescriptor<Solution_> innerFindEntityDescriptor(Class<?> entitySubclass) {
        for (Class<?> entityClass : this.reversedEntityClassList) {
            if (!entityClass.isAssignableFrom(entitySubclass)) continue;
            return this.entityDescriptorMap.get(entityClass);
        }
        return null;
    }

    public VariableDescriptor<Solution_> findVariableDescriptorOrFail(Object entity, String variableName) {
        EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
        VariableDescriptor<Solution_> variableDescriptor = entityDescriptor.getVariableDescriptor(variableName);
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(entityDescriptor.buildInvalidVariableNameExceptionMessage(variableName));
        }
        return variableDescriptor;
    }

    public LookUpStrategyResolver getLookUpStrategyResolver() {
        return this.lookUpStrategyResolver;
    }

    public void validateConstraintWeight(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        if (constraintWeight == null) {
            throw new IllegalArgumentException("The constraintWeight (" + constraintWeight + ") for constraintPackage (" + constraintPackage + ") and constraintName (" + constraintName + ") must not be null.\n" + (String)(this.constraintConfigurationDescriptor == null ? "Maybe check your constraint implementation." : "Maybe validate the data input of your constraintConfigurationClass (" + this.constraintConfigurationDescriptor.getConstraintConfigurationClass() + ") for that constraint (" + constraintName + ")."));
        }
        if (!this.scoreDescriptor.getScoreClass().isAssignableFrom(constraintWeight.getClass())) {
            throw new IllegalArgumentException("The constraintWeight (" + constraintWeight + ") of class (" + constraintWeight.getClass() + ") for constraintPackage (" + constraintPackage + ") and constraintName (" + constraintName + ") must be of the scoreClass (" + this.scoreDescriptor.getScoreClass() + ").\n" + (String)(this.constraintConfigurationDescriptor == null ? "Maybe check your constraint implementation." : "Maybe validate the data input of your constraintConfigurationClass (" + this.constraintConfigurationDescriptor.getConstraintConfigurationClass() + ") for that constraint (" + constraintName + ")."));
        }
        if (constraintWeight.initScore() != 0) {
            throw new IllegalArgumentException("The constraintWeight (" + constraintWeight + ") for constraintPackage (" + constraintPackage + ") and constraintName (" + constraintName + ") must have an initScore (" + constraintWeight.initScore() + ") equal to 0.\n" + (String)(this.constraintConfigurationDescriptor == null ? "Maybe check your constraint implementation." : "Maybe validate the data input of your constraintConfigurationClass (" + this.constraintConfigurationDescriptor.getConstraintConfigurationClass() + ") for that constraint (" + constraintName + ")."));
        }
        if (!this.scoreDescriptor.getScoreDefinition().isPositiveOrZero(constraintWeight)) {
            throw new IllegalArgumentException("The constraintWeight (" + constraintWeight + ") for constraintPackage (" + constraintPackage + ") and constraintName (" + constraintName + ") must have a positive or zero constraintWeight (" + constraintWeight + ").\n" + (String)(this.constraintConfigurationDescriptor == null ? "Maybe check your constraint implementation." : "Maybe validate the data input of your constraintConfigurationClass (" + this.constraintConfigurationDescriptor.getConstraintConfigurationClass() + ") for that constraint (" + constraintName + ")."));
        }
        if (constraintWeight instanceof IBendableScore) {
            IBendableScore bendableConstraintWeight = (IBendableScore)constraintWeight;
            AbstractBendableScoreDefinition bendableScoreDefinition = (AbstractBendableScoreDefinition)this.scoreDescriptor.getScoreDefinition();
            if (bendableConstraintWeight.hardLevelsSize() != bendableScoreDefinition.getHardLevelsSize() || bendableConstraintWeight.softLevelsSize() != bendableScoreDefinition.getSoftLevelsSize()) {
                throw new IllegalArgumentException("The bendable constraintWeight (" + constraintWeight + ") for constraintPackage (" + constraintPackage + ") and constraintName (" + constraintName + ") has a hardLevelsSize (" + bendableConstraintWeight.hardLevelsSize() + ") or a softLevelsSize (" + bendableConstraintWeight.softLevelsSize() + ") that doesn't match the score definition's hardLevelsSize (" + bendableScoreDefinition.getHardLevelsSize() + ") or softLevelsSize (" + bendableScoreDefinition.getSoftLevelsSize() + ").\n" + (String)(this.constraintConfigurationDescriptor == null ? "Maybe check your constraint implementation." : "Maybe validate the data input of your constraintConfigurationClass (" + this.constraintConfigurationDescriptor.getConstraintConfigurationClass() + ") for that constraint (" + constraintName + ")."));
            }
        }
    }

    public Collection<Object> getAllEntitiesAndProblemFacts(Solution_ solution) {
        ArrayList<Object> facts = new ArrayList<Object>();
        this.visitAll(solution, facts::add);
        return facts;
    }

    public int getEntityCount(Solution_ solution) {
        MutableInt entityCount = new MutableInt();
        this.visitAllEntities(solution, fact -> entityCount.increment(), collection -> entityCount.add(collection.size()));
        return entityCount.intValue();
    }

    public void visitAllEntities(Solution_ solution, Consumer<Object> visitor) {
        this.visitAllEntities(solution, visitor, collection -> collection.forEach(visitor));
    }

    private void visitAllEntities(Solution_ solution, Consumer<Object> visitor, Consumer<Collection<Object>> collectionVisitor) {
        for (MemberAccessor entityMemberAccessor : this.entityMemberAccessorMap.values()) {
            Object entity = this.extractMemberObject(entityMemberAccessor, solution);
            if (entity == null) continue;
            visitor.accept(entity);
        }
        for (MemberAccessor entityCollectionMemberAccessor : this.entityCollectionMemberAccessorMap.values()) {
            Collection<Object> entityCollection = this.extractMemberCollectionOrArray(entityCollectionMemberAccessor, solution, false);
            collectionVisitor.accept(entityCollection);
        }
    }

    public void visitEntitiesByEntityClass(Solution_ solution, Class<?> entityClass, Consumer<Object> visitor) {
        for (MemberAccessor entityMemberAccessor : this.entityMemberAccessorMap.values()) {
            Object entity = this.extractMemberObject(entityMemberAccessor, solution);
            if (!entityClass.isInstance(entity)) continue;
            visitor.accept(entity);
        }
        for (MemberAccessor entityCollectionMemberAccessor : this.entityCollectionMemberAccessorMap.values()) {
            Optional<Class<?>> optionalTypeParameter = ConfigUtils.extractCollectionGenericTypeParameterLeniently("solutionClass", entityCollectionMemberAccessor.getDeclaringClass(), entityCollectionMemberAccessor.getType(), entityCollectionMemberAccessor.getGenericType(), null, entityCollectionMemberAccessor.getName());
            boolean collectionGuaranteedToContainOnlyGivenEntityType = optionalTypeParameter.map(entityClass::isAssignableFrom).orElse(false);
            if (collectionGuaranteedToContainOnlyGivenEntityType) {
                Collection<Object> entityCollection = this.extractMemberCollectionOrArray(entityCollectionMemberAccessor, solution, false);
                entityCollection.forEach(visitor);
                continue;
            }
            boolean collectionCouldPossiblyContainGivenEntityType = optionalTypeParameter.map(e -> e.isAssignableFrom(entityClass)).orElse(true);
            if (!collectionCouldPossiblyContainGivenEntityType) continue;
            Collection<Object> entityCollection = this.extractMemberCollectionOrArray(entityCollectionMemberAccessor, solution, false);
            for (Object entity : entityCollection) {
                if (!entityClass.isInstance(entity)) continue;
                visitor.accept(entity);
            }
        }
    }

    public void visitAllProblemFacts(Solution_ solution, Consumer<Object> visitor) {
        for (MemberAccessor accessor : this.problemFactMemberAccessorMap.values()) {
            Object object = this.extractMemberObject(accessor, solution);
            if (object == null) continue;
            visitor.accept(object);
        }
        for (MemberAccessor accessor : this.problemFactCollectionMemberAccessorMap.values()) {
            Collection<Object> objects = this.extractMemberCollectionOrArray(accessor, solution, true);
            for (Object object : objects) {
                visitor.accept(object);
            }
        }
    }

    public void visitAll(Solution_ solution, Consumer<Object> visitor) {
        this.visitAllProblemFacts(solution, visitor);
        this.visitAllEntities(solution, visitor);
    }

    public boolean hasMovableEntities(ScoreDirector<Solution_> scoreDirector) {
        return this.extractAllEntitiesStream(scoreDirector.getWorkingSolution()).anyMatch(entity -> this.findEntityDescriptorOrFail(entity.getClass()).isMovable(scoreDirector, entity));
    }

    public long getGenuineVariableCount(Solution_ solution) {
        MutableLong result = new MutableLong();
        this.visitAllEntities(solution, entity -> result.add(this.findEntityDescriptorOrFail(entity.getClass()).getGenuineVariableCount()));
        return result.longValue();
    }

    public long getMaximumValueCount(Solution_ solution) {
        return this.extractAllEntitiesStream(solution).mapToLong(entity -> this.findEntityDescriptorOrFail(entity.getClass()).getMaximumValueCount(solution, entity)).max().orElse(0L);
    }

    public int getValueCount(Solution_ solution) {
        boolean valueCount = false;
        throw new UnsupportedOperationException("getValueCount is not yet supported - this blocks ValueRatioTabuSizeStrategy");
    }

    public long getProblemScale(Solution_ solution) {
        MutableLong result = new MutableLong();
        this.visitAllEntities(solution, entity -> result.add(this.findEntityDescriptorOrFail(entity.getClass()).getProblemScale(solution, entity)));
        return result.longValue();
    }

    public int countUninitialized(Solution_ solution) {
        return this.countUninitializedVariables(solution) + this.countUnassignedValues(solution);
    }

    private int countUninitializedVariables(Solution_ solution) {
        MutableInt result = new MutableInt();
        this.visitAllEntities(solution, entity -> result.add(this.findEntityDescriptorOrFail(entity.getClass()).countUninitializedVariables(entity)));
        return result.intValue();
    }

    private int countUnassignedValues(Solution_ solution) {
        int unassignedValueCount = 0;
        for (ListVariableDescriptor<Solution_> listVariableDescriptor : this.listVariableDescriptors) {
            unassignedValueCount += this.countUnassignedValues(solution, listVariableDescriptor);
        }
        return unassignedValueCount;
    }

    private int countUnassignedValues(Solution_ solution, ListVariableDescriptor<Solution_> variableDescriptor) {
        long totalValueCount = variableDescriptor.getValueCount(solution, null);
        MutableInt assignedValuesCount = new MutableInt();
        this.visitAllEntities(solution, entity -> assignedValuesCount.add(variableDescriptor.getListSize(entity)));
        return Math.toIntExact(totalValueCount - (long)assignedValuesCount.intValue());
    }

    private Stream<Object> extractAllEntitiesStream(Solution_ solution) {
        Stream<Object> stream = Stream.empty();
        for (MemberAccessor memberAccessor : this.entityMemberAccessorMap.values()) {
            Object entity = this.extractMemberObject(memberAccessor, solution);
            if (entity == null) continue;
            stream = Stream.concat(stream, Stream.of(entity));
        }
        for (MemberAccessor memberAccessor : this.entityCollectionMemberAccessorMap.values()) {
            Collection<Object> entityCollection = this.extractMemberCollectionOrArray(memberAccessor, solution, false);
            stream = Stream.concat(stream, entityCollection.stream());
        }
        return stream;
    }

    private Object extractMemberObject(MemberAccessor memberAccessor, Solution_ solution) {
        return memberAccessor.executeGetter(solution);
    }

    private Collection<Object> extractMemberCollectionOrArray(MemberAccessor memberAccessor, Solution_ solution, boolean isFact) {
        List<Object> collection;
        if (memberAccessor.getType().isArray()) {
            Object arrayObject = memberAccessor.executeGetter(solution);
            collection = ReflectionHelper.transformArrayToList(arrayObject);
        } else {
            collection = (List<Object>)memberAccessor.executeGetter(solution);
        }
        if (collection == null) {
            throw new IllegalArgumentException("The solutionClass (" + this.solutionClass + ")'s " + (isFact ? "factCollectionProperty" : "entityCollectionProperty") + " (" + memberAccessor + ") should never return null.\n" + (memberAccessor instanceof ReflectionFieldMemberAccessor ? "" : "Maybe the getter/method always returns null instead of the actual data.\n") + "Maybe that property (" + memberAccessor.getName() + ") was set with null instead of an empty collection/array when the class (" + this.solutionClass.getSimpleName() + ") instance was created.");
        }
        return collection;
    }

    public Score getScore(Solution_ solution) {
        return this.scoreDescriptor.getScore(solution);
    }

    public void setScore(Solution_ solution, Score score) {
        this.scoreDescriptor.setScore(solution, score);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.solutionClass.getName() + ")";
    }
}

