/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution.mutation;

import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import java.util.Iterator;
import java.util.List;

public class MutationCounter<Solution_> {
    protected final SolutionDescriptor<Solution_> solutionDescriptor;

    public MutationCounter(SolutionDescriptor<Solution_> solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
    }

    public int countMutations(Solution_ a, Solution_ b) {
        int mutationCount = 0;
        for (EntityDescriptor<Solution_> entityDescriptor : this.solutionDescriptor.getGenuineEntityDescriptors()) {
            List<Object> aEntities = entityDescriptor.extractEntities(a);
            List<Object> bEntities = entityDescriptor.extractEntities(b);
            Iterator<Object> aIt = aEntities.iterator();
            Iterator<Object> bIt = bEntities.iterator();
            while (aIt.hasNext() && bIt.hasNext()) {
                Object aEntity = aIt.next();
                Object bEntity = bIt.next();
                for (GenuineVariableDescriptor<Solution_> variableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
                    if (variableDescriptor.getValue(aEntity) == variableDescriptor.getValue(bEntity)) continue;
                    ++mutationCount;
                }
            }
            if (aEntities.size() == bEntities.size()) continue;
            mutationCount += Math.abs(aEntities.size() - bEntities.size()) * entityDescriptor.getGenuineVariableDescriptorList().size();
        }
        return mutationCount;
    }

    public String toString() {
        return "MutationCounter(" + this.solutionDescriptor + ")";
    }
}

