/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.valuerange.buildin.bigdecimal;

import ai.timefold.solver.core.impl.domain.valuerange.AbstractCountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.util.ValueRangeIterator;
import ai.timefold.solver.core.impl.solver.random.RandomUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;

public class BigDecimalValueRange
extends AbstractCountableValueRange<BigDecimal> {
    private final BigDecimal from;
    private final BigDecimal to;
    private final BigDecimal incrementUnit;

    public BigDecimalValueRange(BigDecimal from, BigDecimal to) {
        this(from, to, BigDecimal.valueOf(1L, from.scale()));
    }

    public BigDecimalValueRange(BigDecimal from, BigDecimal to, BigDecimal incrementUnit) {
        this.from = from;
        this.to = to;
        this.incrementUnit = incrementUnit;
        int scale = from.scale();
        if (scale != to.scale()) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + " cannot have a to (" + to + ") scale (" + to.scale() + ") which is different than its from (" + from + ") scale (" + scale + ").");
        }
        if (scale != incrementUnit.scale()) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + " cannot have a from (" + incrementUnit + ") scale (" + incrementUnit.scale() + ") which is different than its from (" + from + ") scale (" + scale + ").");
        }
        if (to.compareTo(from) < 0) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + " cannot have a from (" + from + ") which is strictly higher than its to (" + to + ").");
        }
        if (incrementUnit.compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + " must have strictly positive incrementUnit (" + incrementUnit + ").");
        }
        if (!to.unscaledValue().subtract(from.unscaledValue()).remainder(incrementUnit.unscaledValue()).equals(BigInteger.ZERO)) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + "'s incrementUnit (" + incrementUnit + ") must fit an integer number of times between from (" + from + ") and to (" + to + ").");
        }
    }

    @Override
    public long getSize() {
        return this.to.unscaledValue().subtract(this.from.unscaledValue()).divide(this.incrementUnit.unscaledValue()).longValue();
    }

    @Override
    public BigDecimal get(long index) {
        if (index < 0L || index >= this.getSize()) {
            throw new IndexOutOfBoundsException("The index (" + index + ") must be >= 0 and < size (" + this.getSize() + ").");
        }
        return this.incrementUnit.multiply(BigDecimal.valueOf(index)).add(this.from);
    }

    @Override
    public boolean contains(BigDecimal value) {
        if (value == null || value.compareTo(this.from) < 0 || value.compareTo(this.to) >= 0) {
            return false;
        }
        return value.subtract(this.from).remainder(this.incrementUnit).compareTo(BigDecimal.ZERO) == 0;
    }

    @Override
    public Iterator<BigDecimal> createOriginalIterator() {
        return new OriginalBigDecimalValueRangeIterator();
    }

    @Override
    public Iterator<BigDecimal> createRandomIterator(Random workingRandom) {
        return new RandomBigDecimalValueRangeIterator(workingRandom);
    }

    public String toString() {
        return "[" + this.from + "-" + this.to + ")";
    }

    private class OriginalBigDecimalValueRangeIterator
    extends ValueRangeIterator<BigDecimal> {
        private BigDecimal upcoming;

        private OriginalBigDecimalValueRangeIterator() {
            this.upcoming = BigDecimalValueRange.this.from;
        }

        @Override
        public boolean hasNext() {
            return this.upcoming.compareTo(BigDecimalValueRange.this.to) < 0;
        }

        @Override
        public BigDecimal next() {
            if (this.upcoming.compareTo(BigDecimalValueRange.this.to) >= 0) {
                throw new NoSuchElementException();
            }
            BigDecimal next = this.upcoming;
            this.upcoming = this.upcoming.add(BigDecimalValueRange.this.incrementUnit);
            return next;
        }
    }

    private class RandomBigDecimalValueRangeIterator
    extends ValueRangeIterator<BigDecimal> {
        private final Random workingRandom;
        private final long size;

        public RandomBigDecimalValueRangeIterator(Random workingRandom) {
            this.size = BigDecimalValueRange.this.getSize();
            this.workingRandom = workingRandom;
        }

        @Override
        public boolean hasNext() {
            return this.size > 0L;
        }

        @Override
        public BigDecimal next() {
            if (this.size <= 0L) {
                throw new NoSuchElementException();
            }
            long index = RandomUtils.nextLong(this.workingRandom, this.size);
            return BigDecimalValueRange.this.incrementUnit.multiply(BigDecimal.valueOf(index)).add(BigDecimalValueRange.this.from);
        }
    }
}

