/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.valuerange.buildin.primlong;

import ai.timefold.solver.core.impl.domain.valuerange.AbstractCountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.util.ValueRangeIterator;
import ai.timefold.solver.core.impl.solver.random.RandomUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;

public class LongValueRange
extends AbstractCountableValueRange<Long> {
    private final long from;
    private final long to;
    private final long incrementUnit;

    public LongValueRange(long from, long to) {
        this(from, to, 1L);
    }

    public LongValueRange(long from, long to, long incrementUnit) {
        this.from = from;
        this.to = to;
        this.incrementUnit = incrementUnit;
        if (to < from) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + " cannot have a from (" + from + ") which is strictly higher than its to (" + to + ").");
        }
        if (incrementUnit <= 0L) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + " must have strictly positive incrementUnit (" + incrementUnit + ").");
        }
        if (to - from < 0L) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + " cannot have a from (" + from + ") and to (" + to + ") with a gap greater than Long.MAX_VALUE (9223372036854775807).");
        }
        if ((to - from) % incrementUnit != 0L) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + "'s incrementUnit (" + incrementUnit + ") must fit an integer number of times between from (" + from + ") and to (" + to + ").");
        }
    }

    @Override
    public long getSize() {
        return (this.to - this.from) / this.incrementUnit;
    }

    @Override
    public boolean contains(Long value) {
        if (value == null || value < this.from || value >= this.to) {
            return false;
        }
        if (this.incrementUnit == 1L) {
            return true;
        }
        return (value - this.from) % this.incrementUnit == 0L;
    }

    @Override
    public Long get(long index) {
        if (index < 0L || index >= this.getSize()) {
            throw new IndexOutOfBoundsException("The index (" + index + ") must be >= 0 and < size (" + this.getSize() + ").");
        }
        return index * this.incrementUnit + this.from;
    }

    @Override
    public Iterator<Long> createOriginalIterator() {
        return new OriginalLongValueRangeIterator();
    }

    @Override
    public Iterator<Long> createRandomIterator(Random workingRandom) {
        return new RandomLongValueRangeIterator(workingRandom);
    }

    public String toString() {
        return "[" + this.from + "-" + this.to + ")";
    }

    private class OriginalLongValueRangeIterator
    extends ValueRangeIterator<Long> {
        private long upcoming;

        private OriginalLongValueRangeIterator() {
            this.upcoming = LongValueRange.this.from;
        }

        @Override
        public boolean hasNext() {
            return this.upcoming < LongValueRange.this.to;
        }

        @Override
        public Long next() {
            if (this.upcoming >= LongValueRange.this.to) {
                throw new NoSuchElementException();
            }
            long next = this.upcoming;
            this.upcoming += LongValueRange.this.incrementUnit;
            return next;
        }
    }

    private class RandomLongValueRangeIterator
    extends ValueRangeIterator<Long> {
        private final Random workingRandom;
        private final long size;

        public RandomLongValueRangeIterator(Random workingRandom) {
            this.size = LongValueRange.this.getSize();
            this.workingRandom = workingRandom;
        }

        @Override
        public boolean hasNext() {
            return this.size > 0L;
        }

        @Override
        public Long next() {
            if (this.size <= 0L) {
                throw new NoSuchElementException();
            }
            long index = RandomUtils.nextLong(this.workingRandom, this.size);
            return index * LongValueRange.this.incrementUnit + LongValueRange.this.from;
        }
    }
}

