/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.custom;

import ai.timefold.solver.core.api.domain.variable.AbstractVariableListener;
import ai.timefold.solver.core.api.domain.variable.ListVariableListener;
import ai.timefold.solver.core.api.domain.variable.ShadowVariable;
import ai.timefold.solver.core.api.domain.variable.VariableListener;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.policy.DescriptorPolicy;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.listener.VariableListenerWithSources;
import ai.timefold.solver.core.impl.domain.variable.supply.Demand;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CustomShadowVariableDescriptor<Solution_>
extends ShadowVariableDescriptor<Solution_> {
    private final Map<Class<? extends AbstractVariableListener>, List<VariableDescriptor<Solution_>>> listenerClassToSourceDescriptorListMap = new HashMap<Class<? extends AbstractVariableListener>, List<VariableDescriptor<Solution_>>>();

    public CustomShadowVariableDescriptor(EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor) {
        super(entityDescriptor, variableMemberAccessor);
    }

    @Override
    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
    }

    @Override
    public void linkVariableDescriptors(DescriptorPolicy descriptorPolicy) {
        for (ShadowVariable shadowVariable : (ShadowVariable[])this.variableMemberAccessor.getDeclaredAnnotationsByType(ShadowVariable.class)) {
            this.linkSourceVariableDescriptorToListenerClass(shadowVariable);
        }
    }

    private void linkSourceVariableDescriptorToListenerClass(ShadowVariable shadowVariable) {
        EntityDescriptor sourceEntityDescriptor;
        Class<?> sourceEntityClass = shadowVariable.sourceEntityClass();
        if (sourceEntityClass.equals(ShadowVariable.NullEntityClass.class)) {
            sourceEntityDescriptor = this.entityDescriptor;
        } else {
            sourceEntityDescriptor = this.entityDescriptor.getSolutionDescriptor().findEntityDescriptor(sourceEntityClass);
            if (sourceEntityDescriptor == null) {
                throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a @" + ShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with a sourceEntityClass (" + sourceEntityClass + ") which is not a valid planning entity.\nMaybe check the annotations of the class (" + sourceEntityClass + ").\nMaybe add the class (" + sourceEntityClass + ") among planning entities in the solver configuration.");
            }
        }
        String sourceVariableName = shadowVariable.sourceVariableName();
        VariableDescriptor sourceVariableDescriptor = sourceEntityDescriptor.getVariableDescriptor(sourceVariableName);
        if (sourceVariableDescriptor == null) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a @" + ShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sourceVariableName (" + sourceVariableName + ") which is not a valid planning variable on entityClass (" + sourceEntityDescriptor.getEntityClass() + ").\n" + sourceEntityDescriptor.buildInvalidVariableNameExceptionMessage(sourceVariableName));
        }
        Class<? extends AbstractVariableListener> variableListenerClass = shadowVariable.variableListenerClass();
        if (sourceVariableDescriptor.isGenuineListVariable() && !ListVariableListener.class.isAssignableFrom(variableListenerClass)) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a @" + ShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sourceVariable (" + sourceVariableDescriptor.getSimpleEntityAndVariableName() + ") which is a list variable but the variableListenerClass (" + variableListenerClass + ") is not a " + ListVariableListener.class.getSimpleName() + ".\nMaybe make the variableListenerClass (" + variableListenerClass.getSimpleName() + ") implement " + ListVariableListener.class.getSimpleName() + ".");
        }
        if (!sourceVariableDescriptor.isGenuineListVariable() && !VariableListener.class.isAssignableFrom(variableListenerClass)) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a @" + ShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sourceVariable (" + sourceVariableDescriptor.getSimpleEntityAndVariableName() + ") which is a basic variable but the variableListenerClass (" + variableListenerClass + ") is not a " + VariableListener.class.getSimpleName() + ".\nMaybe make the variableListenerClass (" + variableListenerClass.getSimpleName() + ") implement " + VariableListener.class.getSimpleName() + ".");
        }
        sourceVariableDescriptor.registerSinkVariableDescriptor(this);
        this.listenerClassToSourceDescriptorListMap.computeIfAbsent(variableListenerClass, k -> new ArrayList()).add(sourceVariableDescriptor);
    }

    @Override
    public List<VariableDescriptor<Solution_>> getSourceVariableDescriptorList() {
        return this.listenerClassToSourceDescriptorListMap.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    @Override
    public Collection<Class<? extends AbstractVariableListener>> getVariableListenerClasses() {
        return this.listenerClassToSourceDescriptorListMap.keySet();
    }

    @Override
    public Demand<?> getProvidedDemand() {
        throw new UnsupportedOperationException("Custom shadow variable cannot be demanded.");
    }

    @Override
    public Iterable<VariableListenerWithSources<Solution_>> buildVariableListeners(SupplyManager supplyManager) {
        return this.listenerClassToSourceDescriptorListMap.entrySet().stream().map(classListEntry -> {
            AbstractVariableListener variableListener = (AbstractVariableListener)ConfigUtils.newInstance(this::toString, "variableListenerClass", (Class)classListEntry.getKey());
            return new VariableListenerWithSources(variableListener, (Collection)classListEntry.getValue());
        }).collect(Collectors.toList());
    }
}

