/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.listener.support.violation;

import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.listener.support.violation.ShadowVariableSnapshot;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class ShadowVariablesAssert {
    private final List<ShadowVariableSnapshot> shadowVariableSnapshots;

    private ShadowVariablesAssert(List<ShadowVariableSnapshot> shadowVariableSnapshots) {
        this.shadowVariableSnapshots = shadowVariableSnapshots;
    }

    public static <Solution_> ShadowVariablesAssert takeSnapshot(SolutionDescriptor<Solution_> solutionDescriptor, Solution_ workingSolution) {
        ArrayList<ShadowVariableSnapshot> shadowVariableSnapshots = new ArrayList<ShadowVariableSnapshot>();
        solutionDescriptor.visitAllEntities(workingSolution, entity -> solutionDescriptor.findEntityDescriptorOrFail(entity.getClass()).getShadowVariableDescriptors().stream().map(shadowVariableDescriptor -> ShadowVariableSnapshot.of(shadowVariableDescriptor, entity)).forEach(shadowVariableSnapshots::add));
        return new ShadowVariablesAssert(shadowVariableSnapshots);
    }

    public String createShadowVariablesViolationMessage(long violationDisplayLimit) {
        Map<ShadowVariableDescriptor<?>, List<String>> violationListMap = this.collectViolations();
        if (violationListMap.isEmpty()) {
            return null;
        }
        return this.format(violationListMap, violationDisplayLimit);
    }

    private Map<ShadowVariableDescriptor<?>, List<String>> collectViolations() {
        TreeMap violationListMap = new TreeMap(Comparator.comparing(ShadowVariableDescriptor::getGlobalShadowOrder));
        for (ShadowVariableSnapshot shadowVariableSnapshot : this.shadowVariableSnapshots) {
            shadowVariableSnapshot.validate(violationMessage -> violationListMap.computeIfAbsent(shadowVariableSnapshot.getShadowVariableDescriptor(), k -> new ArrayList()).add(violationMessage));
        }
        return violationListMap;
    }

    private String format(Map<ShadowVariableDescriptor<?>, List<String>> violationListMap, long violationDisplayLimit) {
        StringBuilder message = new StringBuilder();
        violationListMap.forEach((shadowVariableDescriptor, violationList) -> {
            violationList.stream().limit(violationDisplayLimit).forEach(message::append);
            if ((long)violationList.size() >= violationDisplayLimit) {
                message.append("  ... ").append((long)violationList.size() - violationDisplayLimit).append(" more\n");
            }
        });
        return message.toString();
    }
}

