/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.entity.decorator;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionListIterator;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

public final class FilteringEntitySelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements EntitySelector<Solution_> {
    private final EntitySelector<Solution_> childEntitySelector;
    private final SelectionFilter<Solution_, Object> selectionFilter;
    private final boolean bailOutEnabled;
    private ScoreDirector<Solution_> scoreDirector = null;

    public FilteringEntitySelector(EntitySelector<Solution_> childEntitySelector, List<SelectionFilter<Solution_, Object>> filterList) {
        this.childEntitySelector = childEntitySelector;
        if (filterList == null || filterList.isEmpty()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must have at least one filter, but got (" + filterList + ").");
        }
        this.selectionFilter = SelectionFilter.compose(filterList);
        this.bailOutEnabled = childEntitySelector.isNeverEnding();
        this.phaseLifecycleSupport.addEventListener(childEntitySelector);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.scoreDirector = phaseScope.getScoreDirector();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.scoreDirector = null;
    }

    @Override
    public EntityDescriptor<Solution_> getEntityDescriptor() {
        return this.childEntitySelector.getEntityDescriptor();
    }

    @Override
    public boolean isCountable() {
        return this.childEntitySelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childEntitySelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return this.childEntitySelector.getSize();
    }

    @Override
    public Iterator<Object> iterator() {
        return new JustInTimeFilteringEntityIterator(this.childEntitySelector.iterator(), this.determineBailOutSize());
    }

    @Override
    public ListIterator<Object> listIterator() {
        return new JustInTimeFilteringEntityListIterator(this.childEntitySelector.listIterator());
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        JustInTimeFilteringEntityListIterator listIterator = new JustInTimeFilteringEntityListIterator(this.childEntitySelector.listIterator());
        for (int i = 0; i < index; ++i) {
            listIterator.next();
        }
        return listIterator;
    }

    @Override
    public Iterator<Object> endingIterator() {
        return new JustInTimeFilteringEntityIterator(this.childEntitySelector.endingIterator(), this.determineBailOutSize());
    }

    private long determineBailOutSize() {
        if (!this.bailOutEnabled) {
            return -1L;
        }
        return this.childEntitySelector.getSize() * 10L;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FilteringEntitySelector that = (FilteringEntitySelector)other;
        return Objects.equals(this.childEntitySelector, that.childEntitySelector) && Objects.equals(this.selectionFilter, that.selectionFilter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.childEntitySelector, this.selectionFilter);
    }

    public String toString() {
        return "Filtering(" + this.childEntitySelector + ")";
    }

    protected class JustInTimeFilteringEntityIterator
    extends UpcomingSelectionIterator<Object> {
        private final Iterator<Object> childEntityIterator;
        private final long bailOutSize;

        public JustInTimeFilteringEntityIterator(Iterator<Object> childEntityIterator, long bailOutSize) {
            this.childEntityIterator = childEntityIterator;
            this.bailOutSize = bailOutSize;
        }

        @Override
        protected Object createUpcomingSelection() {
            Object next;
            long attemptsBeforeBailOut = this.bailOutSize;
            do {
                if (!this.childEntityIterator.hasNext()) {
                    return this.noUpcomingSelection();
                }
                if (!FilteringEntitySelector.this.bailOutEnabled) continue;
                if (attemptsBeforeBailOut <= 0L) {
                    FilteringEntitySelector.this.logger.warn("Bailing out of neverEnding selector ({}) to avoid infinite loop.", (Object)FilteringEntitySelector.this);
                    return this.noUpcomingSelection();
                }
                --attemptsBeforeBailOut;
            } while (!FilteringEntitySelector.this.selectionFilter.accept(FilteringEntitySelector.this.scoreDirector, next = this.childEntityIterator.next()));
            return next;
        }
    }

    protected class JustInTimeFilteringEntityListIterator
    extends UpcomingSelectionListIterator<Object> {
        private final ListIterator<Object> childEntityListIterator;

        public JustInTimeFilteringEntityListIterator(ListIterator<Object> childEntityListIterator) {
            this.childEntityListIterator = childEntityListIterator;
        }

        @Override
        protected Object createUpcomingSelection() {
            Object next;
            do {
                if (this.childEntityListIterator.hasNext()) continue;
                return this.noUpcomingSelection();
            } while (!FilteringEntitySelector.this.selectionFilter.accept(FilteringEntitySelector.this.scoreDirector, next = this.childEntityListIterator.next()));
            return next;
        }

        @Override
        protected Object createPreviousSelection() {
            Object previous;
            do {
                if (this.childEntityListIterator.hasPrevious()) continue;
                return this.noPreviousSelection();
            } while (!FilteringEntitySelector.this.selectionFilter.accept(FilteringEntitySelector.this.scoreDirector, previous = this.childEntityListIterator.previous()));
            return previous;
        }
    }
}

