/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.list;

import ai.timefold.solver.core.impl.heuristic.selector.list.TriangularNumbers;
import java.util.Random;

final class TriangleElementFactory {
    private final int minimumSubListSize;
    private final int maximumSubListSize;
    private final Random workingRandom;

    TriangleElementFactory(int minimumSubListSize, int maximumSubListSize, Random workingRandom) {
        if (minimumSubListSize > maximumSubListSize) {
            throw new IllegalArgumentException("The minimumSubListSize (" + minimumSubListSize + ") must be less than or equal to the maximumSubListSize (" + maximumSubListSize + ").");
        }
        if (minimumSubListSize < 1) {
            throw new IllegalArgumentException("The minimumSubListSize (" + minimumSubListSize + ") must be greater than 0.");
        }
        this.minimumSubListSize = minimumSubListSize;
        this.maximumSubListSize = maximumSubListSize;
        this.workingRandom = workingRandom;
    }

    TriangleElement nextElement(int listSize) throws IllegalArgumentException {
        int subListCount = TriangularNumbers.nthTriangle(listSize - this.minimumSubListSize + 1);
        int topTriangleSize = listSize <= this.maximumSubListSize ? 0 : TriangularNumbers.nthTriangle(listSize - this.maximumSubListSize);
        int subListIndex = this.workingRandom.nextInt(subListCount - topTriangleSize) + topTriangleSize + 1;
        return TriangleElement.valueOf(subListIndex);
    }

    static final class TriangleElement {
        private final int index;
        private final int level;
        private final int indexOnLevel;

        private TriangleElement(int index, int level, int indexOnLevel) {
            this.index = index;
            this.level = level;
            this.indexOnLevel = indexOnLevel;
        }

        static TriangleElement valueOf(int index) {
            int level = (int)Math.ceil(TriangularNumbers.triangularRoot(index));
            return new TriangleElement(index, level, index - TriangularNumbers.nthTriangle(level - 1));
        }

        public int getIndex() {
            return this.index;
        }

        public int getLevel() {
            return this.level;
        }

        public int getIndexOnLevel() {
            return this.indexOnLevel;
        }
    }
}

