/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.list.nearby;

import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.AbstractNearbyDistanceMatrixDemand;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import ai.timefold.solver.core.impl.heuristic.selector.list.ElementDestinationSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.mimic.MimicReplayingSubListSelector;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.ToIntFunction;

final class SubListNearbyDistanceMatrixDemand<Solution_, Origin_, Destination_>
extends AbstractNearbyDistanceMatrixDemand<Origin_, Destination_, ElementDestinationSelector<Solution_>, MimicReplayingSubListSelector<Solution_>> {
    private final ToIntFunction<Origin_> destinationSizeFunction;

    public SubListNearbyDistanceMatrixDemand(NearbyDistanceMeter<Origin_, Destination_> meter, NearbyRandom random, ElementDestinationSelector<Solution_> childDestinationSelector, MimicReplayingSubListSelector<Solution_> replayingOriginSubListSelector, ToIntFunction<Origin_> destinationSizeFunction) {
        super(meter, random, childDestinationSelector, replayingOriginSubListSelector);
        this.destinationSizeFunction = destinationSizeFunction;
    }

    @Override
    protected NearbyDistanceMatrix<Origin_, Destination_> supplyNearbyDistanceMatrix() {
        long childSize = ((ElementDestinationSelector)this.childSelector).getSize();
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The childSize (" + childSize + ") is higher than Integer.MAX_VALUE.");
        }
        long originSize = ((MimicReplayingSubListSelector)this.replayingSelector).getValueCount();
        if (originSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The originSubListSelector (" + this.childSelector + ") has a subListSize (" + originSize + ") which is higher than Integer.MAX_VALUE.");
        }
        Function<Object, Iterator> destinationIteratorProvider = origin -> ((ElementDestinationSelector)this.childSelector).endingIterator();
        NearbyDistanceMatrix nearbyDistanceMatrix = new NearbyDistanceMatrix(this.meter, (int)originSize, destinationIteratorProvider, this.destinationSizeFunction);
        ((MimicReplayingSubListSelector)this.replayingSelector).endingValueIterator().forEachRemaining(origin -> nearbyDistanceMatrix.addAllDestinations(origin));
        return nearbyDistanceMatrix;
    }
}

