/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.composite;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.composite.AbstractCompositeMoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.composite.FixedSelectorProbabilityWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.composite.UnionMoveSelector;
import java.util.HashMap;
import java.util.List;

public class UnionMoveSelectorFactory<Solution_>
extends AbstractCompositeMoveSelectorFactory<Solution_, UnionMoveSelectorConfig> {
    public UnionMoveSelectorFactory(UnionMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    public MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        FixedSelectorProbabilityWeightFactory selectorProbabilityWeightFactory;
        List<MoveSelector<Solution_>> moveSelectorList = this.buildInnerMoveSelectors(((UnionMoveSelectorConfig)this.config).getMoveSelectorList(), configPolicy, minimumCacheType, randomSelection);
        if (((UnionMoveSelectorConfig)this.config).getSelectorProbabilityWeightFactoryClass() != null) {
            if (!randomSelection) {
                throw new IllegalArgumentException("The moveSelectorConfig (" + this.config + ") with selectorProbabilityWeightFactoryClass (" + ((UnionMoveSelectorConfig)this.config).getSelectorProbabilityWeightFactoryClass() + ") has non-random randomSelection (" + randomSelection + ").");
            }
            selectorProbabilityWeightFactory = ConfigUtils.newInstance(this.config, "selectorProbabilityWeightFactoryClass", ((UnionMoveSelectorConfig)this.config).getSelectorProbabilityWeightFactoryClass());
        } else if (randomSelection) {
            HashMap<MoveSelector<Solution_>, Double> fixedProbabilityWeightMap = new HashMap<MoveSelector<Solution_>, Double>(((UnionMoveSelectorConfig)this.config).getMoveSelectorList().size());
            for (int i = 0; i < ((UnionMoveSelectorConfig)this.config).getMoveSelectorList().size(); ++i) {
                MoveSelectorConfig innerMoveSelectorConfig = ((UnionMoveSelectorConfig)this.config).getMoveSelectorList().get(i);
                MoveSelector<Solution_> moveSelector = moveSelectorList.get(i);
                Double fixedProbabilityWeight = innerMoveSelectorConfig.getFixedProbabilityWeight();
                if (fixedProbabilityWeight == null) continue;
                fixedProbabilityWeightMap.put(moveSelector, fixedProbabilityWeight);
            }
            selectorProbabilityWeightFactory = fixedProbabilityWeightMap.isEmpty() ? null : new FixedSelectorProbabilityWeightFactory(fixedProbabilityWeightMap);
        } else {
            selectorProbabilityWeightFactory = null;
        }
        return new UnionMoveSelector<Solution_>(moveSelectorList, randomSelection, selectorProbabilityWeightFactory);
    }
}

