/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list;

import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.index.IndexVariableDemand;
import ai.timefold.solver.core.impl.domain.variable.index.IndexVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonListInverseVariableDemand;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.OriginalListSwapIterator;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.RandomListSwapIterator;
import ai.timefold.solver.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Iterator;

public class ListSwapMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    private final EntityIndependentValueSelector<Solution_> leftValueSelector;
    private final EntityIndependentValueSelector<Solution_> rightValueSelector;
    private final boolean randomSelection;
    private SingletonInverseVariableSupply inverseVariableSupply;
    private IndexVariableSupply indexVariableSupply;

    public ListSwapMoveSelector(EntityIndependentValueSelector<Solution_> leftValueSelector, EntityIndependentValueSelector<Solution_> rightValueSelector, boolean randomSelection) {
        this.leftValueSelector = leftValueSelector;
        this.rightValueSelector = rightValueSelector;
        this.randomSelection = randomSelection;
        this.phaseLifecycleSupport.addEventListener(leftValueSelector);
        if (leftValueSelector != rightValueSelector) {
            this.phaseLifecycleSupport.addEventListener(rightValueSelector);
        }
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        ListVariableDescriptor listVariableDescriptor = (ListVariableDescriptor)this.leftValueSelector.getVariableDescriptor();
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        this.inverseVariableSupply = supplyManager.demand(new SingletonListInverseVariableDemand(listVariableDescriptor));
        this.indexVariableSupply = supplyManager.demand(new IndexVariableDemand(listVariableDescriptor));
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
        this.indexVariableSupply = null;
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        if (this.randomSelection) {
            return new RandomListSwapIterator<Solution_>(this.inverseVariableSupply, this.indexVariableSupply, this.leftValueSelector, this.rightValueSelector);
        }
        return new OriginalListSwapIterator<Solution_>(this.inverseVariableSupply, this.indexVariableSupply, this.leftValueSelector, this.rightValueSelector);
    }

    @Override
    public boolean isCountable() {
        return this.leftValueSelector.isCountable() && this.rightValueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.leftValueSelector.isNeverEnding() || this.rightValueSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return this.leftValueSelector.getSize() * this.rightValueSelector.getSize();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.leftValueSelector + ", " + this.rightValueSelector + ")";
    }
}

