/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubList;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;

public class SubListSwapMove<Solution_>
extends AbstractMove<Solution_> {
    private final ListVariableDescriptor<Solution_> variableDescriptor;
    private final SubList leftSubList;
    private final SubList rightSubList;
    private final boolean reversing;
    private final int rightFromIndex;
    private final int leftToIndex;
    private List<Object> leftPlanningValueList;
    private List<Object> rightPlanningValueList;

    public SubListSwapMove(ListVariableDescriptor<Solution_> variableDescriptor, Object leftEntity, int leftFromIndex, int leftToIndex, Object rightEntity, int rightFromIndex, int rightToIndex, boolean reversing) {
        this(variableDescriptor, new SubList(leftEntity, leftFromIndex, leftToIndex - leftFromIndex), new SubList(rightEntity, rightFromIndex, rightToIndex - rightFromIndex), reversing);
    }

    public SubListSwapMove(ListVariableDescriptor<Solution_> variableDescriptor, SubList leftSubList, SubList rightSubList, boolean reversing) {
        this.variableDescriptor = variableDescriptor;
        if (leftSubList.getEntity() == rightSubList.getEntity() && leftSubList.getFromIndex() > rightSubList.getFromIndex()) {
            this.leftSubList = rightSubList;
            this.rightSubList = leftSubList;
        } else {
            this.leftSubList = leftSubList;
            this.rightSubList = rightSubList;
        }
        this.reversing = reversing;
        this.rightFromIndex = this.rightSubList.getFromIndex();
        this.leftToIndex = this.leftSubList.getToIndex();
    }

    public SubList getLeftSubList() {
        return this.leftSubList;
    }

    public SubList getRightSubList() {
        return this.rightSubList;
    }

    public boolean isReversing() {
        return this.reversing;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return this.leftSubList.getEntity() != this.rightSubList.getEntity() || this.rightFromIndex >= this.leftToIndex;
    }

    @Override
    protected AbstractMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        if (this.leftSubList.getEntity() == this.rightSubList.getEntity()) {
            return new SubListSwapMove<Solution_>(this.variableDescriptor, new SubList(this.leftSubList.getEntity(), this.leftSubList.getFromIndex(), this.rightSubList.getLength()), new SubList(this.rightSubList.getEntity(), this.rightSubList.getFromIndex() - this.leftSubList.getLength() + this.rightSubList.getLength(), this.leftSubList.getLength()), this.reversing);
        }
        return new SubListSwapMove<Solution_>(this.variableDescriptor, new SubList(this.rightSubList.getEntity(), this.rightSubList.getFromIndex(), this.leftSubList.getLength()), new SubList(this.leftSubList.getEntity(), this.leftSubList.getFromIndex(), this.rightSubList.getLength()), this.reversing);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        Object leftEntity = this.leftSubList.getEntity();
        Object rightEntity = this.rightSubList.getEntity();
        int leftSubListLength = this.leftSubList.getLength();
        int rightSubListLength = this.rightSubList.getLength();
        int leftFromIndex = this.leftSubList.getFromIndex();
        List<Object> leftList = this.variableDescriptor.getListVariable(leftEntity);
        List<Object> rightList = this.variableDescriptor.getListVariable(rightEntity);
        List<Object> leftSubListView = this.subList(this.leftSubList);
        List<Object> rightSubListView = this.subList(this.rightSubList);
        this.leftPlanningValueList = CollectionUtils.copy(leftSubListView, this.reversing);
        this.rightPlanningValueList = CollectionUtils.copy(rightSubListView, this.reversing);
        if (leftEntity == rightEntity) {
            int fromIndex = Math.min(leftFromIndex, this.rightFromIndex);
            int toIndex = leftFromIndex > this.rightFromIndex ? leftFromIndex + leftSubListLength : this.rightFromIndex + rightSubListLength;
            int leftSubListDestinationIndex = this.rightFromIndex + rightSubListLength - leftSubListLength;
            innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, leftEntity, fromIndex, toIndex);
            rightSubListView.clear();
            this.subList(this.leftSubList).clear();
            leftList.addAll(leftFromIndex, this.rightPlanningValueList);
            rightList.addAll(leftSubListDestinationIndex, this.leftPlanningValueList);
            innerScoreDirector.afterListVariableChanged(this.variableDescriptor, leftEntity, fromIndex, toIndex);
        } else {
            innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, leftEntity, leftFromIndex, leftFromIndex + leftSubListLength);
            innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, rightEntity, this.rightFromIndex, this.rightFromIndex + rightSubListLength);
            rightSubListView.clear();
            leftSubListView.clear();
            leftList.addAll(leftFromIndex, this.rightPlanningValueList);
            rightList.addAll(this.rightFromIndex, this.leftPlanningValueList);
            innerScoreDirector.afterListVariableChanged(this.variableDescriptor, leftEntity, leftFromIndex, leftFromIndex + rightSubListLength);
            innerScoreDirector.afterListVariableChanged(this.variableDescriptor, rightEntity, this.rightFromIndex, this.rightFromIndex + leftSubListLength);
        }
    }

    @Override
    public SubListSwapMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new SubListSwapMove<Solution_>(this.variableDescriptor, this.leftSubList.rebase(destinationScoreDirector), this.rightSubList.rebase(destinationScoreDirector), this.reversing);
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<Object> getPlanningEntities() {
        LinkedHashSet<Object> entities = new LinkedHashSet<Object>(2);
        entities.add(this.leftSubList.getEntity());
        entities.add(this.rightSubList.getEntity());
        return entities;
    }

    @Override
    public Collection<Object> getPlanningValues() {
        return CollectionUtils.concat(this.leftPlanningValueList, this.rightPlanningValueList);
    }

    private List<Object> subList(SubList subList) {
        return this.variableDescriptor.getListVariable(subList.getEntity()).subList(subList.getFromIndex(), subList.getToIndex());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubListSwapMove other = (SubListSwapMove)o;
        return this.reversing == other.reversing && this.rightFromIndex == other.rightFromIndex && this.leftToIndex == other.leftToIndex && this.variableDescriptor.equals(other.variableDescriptor) && this.leftSubList.equals(other.leftSubList) && this.rightSubList.equals(other.rightSubList);
    }

    public int hashCode() {
        return Objects.hash(this.variableDescriptor, this.leftSubList, this.rightSubList, this.reversing, this.rightFromIndex, this.leftToIndex);
    }

    public String toString() {
        return "{" + this.leftSubList + "} <-" + (this.reversing ? "reversing-" : "") + "> {" + this.rightSubList + "}";
    }
}

