/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt;

import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.index.IndexVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public final class EntityOrderInfo {
    final Object[] entities;
    final int[] offsets;
    final Map<Object, Integer> entityToEntityIndex;

    public <Node_> EntityOrderInfo(Node_[] pickedValues, SingletonInverseVariableSupply inverseVariableSupply, ListVariableDescriptor<?> listVariableDescriptor) {
        this.entityToEntityIndex = new IdentityHashMap<Object, Integer>();
        for (int i = 1; i < pickedValues.length && pickedValues[i] != null; ++i) {
            this.entityToEntityIndex.computeIfAbsent(inverseVariableSupply.getInverseSingleton(pickedValues[i]), entity -> this.entityToEntityIndex.size());
        }
        this.entities = new Object[this.entityToEntityIndex.size()];
        this.offsets = new int[this.entities.length];
        for (Map.Entry<Object, Integer> entry : this.entityToEntityIndex.entrySet()) {
            this.entities[entry.getValue().intValue()] = entry.getKey();
        }
        for (int i = 1; i < this.offsets.length; ++i) {
            this.offsets[i] = this.offsets[i - 1] + listVariableDescriptor.getListSize(this.entities[i - 1]);
        }
    }

    public EntityOrderInfo(Object[] entities, Map<Object, Integer> entityToEntityIndex, int[] offsets) {
        this.entities = entities;
        this.entityToEntityIndex = entityToEntityIndex;
        this.offsets = offsets;
    }

    public <Node_> EntityOrderInfo withNewNode(Node_ node, ListVariableDescriptor<?> listVariableDescriptor, SingletonInverseVariableSupply inverseVariableSupply) {
        Object entity = inverseVariableSupply.getInverseSingleton(node);
        if (this.entityToEntityIndex.containsKey(entity)) {
            return this;
        }
        Object[] newEntities = Arrays.copyOf(this.entities, this.entities.length + 1);
        IdentityHashMap<Object, Integer> newEntityToEntityIndex = new IdentityHashMap<Object, Integer>(this.entityToEntityIndex);
        int[] newOffsets = Arrays.copyOf(this.offsets, this.offsets.length + 1);
        newEntities[this.entities.length] = entity;
        newEntityToEntityIndex.put(entity, this.entities.length);
        newOffsets[this.entities.length] = this.offsets[this.entities.length - 1] + listVariableDescriptor.getListSize(this.entities[this.entities.length - 1]);
        return new EntityOrderInfo(newEntities, newEntityToEntityIndex, newOffsets);
    }

    public <Node_> Node_ successor(Node_ object, ListVariableDescriptor<?> listVariableDescriptor, IndexVariableSupply indexVariableSupply, SingletonInverseVariableSupply inverseVariableSupply) {
        List<Object> listVariable;
        Object entity = inverseVariableSupply.getInverseSingleton(object);
        int indexInEntityList = indexVariableSupply.getIndex(object);
        if (indexInEntityList == (listVariable = listVariableDescriptor.getListVariable(entity)).size() - 1) {
            int nextEntityIndex = (this.entityToEntityIndex.get(entity) + 1) % this.entities.length;
            return (Node_)listVariableDescriptor.getListVariable(this.entities[nextEntityIndex]).get(0);
        }
        return (Node_)listVariable.get(indexInEntityList + 1);
    }

    public <Node_> Node_ predecessor(Node_ object, ListVariableDescriptor<?> listVariableDescriptor, IndexVariableSupply indexVariableSupply, SingletonInverseVariableSupply inverseVariableSupply) {
        Object entity = inverseVariableSupply.getInverseSingleton(object);
        int indexInEntityList = indexVariableSupply.getIndex(object);
        List<Object> listVariable = listVariableDescriptor.getListVariable(entity);
        if (indexInEntityList == 0) {
            int previousEntityIndex = (this.entityToEntityIndex.get(entity) - 1 + this.entities.length) % this.entities.length;
            listVariable = listVariableDescriptor.getListVariable(this.entities[previousEntityIndex]);
            return (Node_)listVariable.get(listVariable.size() - 1);
        }
        return (Node_)listVariable.get(indexInEntityList - 1);
    }

    public <Node_> boolean between(Node_ start, Node_ middle, Node_ end, IndexVariableSupply indexVariableSupply, SingletonInverseVariableSupply inverseVariableSupply) {
        int startEntityIndex = this.entityToEntityIndex.get(inverseVariableSupply.getInverseSingleton(start));
        int middleEntityIndex = this.entityToEntityIndex.get(inverseVariableSupply.getInverseSingleton(middle));
        int endEntityIndex = this.entityToEntityIndex.get(inverseVariableSupply.getInverseSingleton(end));
        int startIndex = indexVariableSupply.getIndex(start) + this.offsets[startEntityIndex];
        int middleIndex = indexVariableSupply.getIndex(middle) + this.offsets[middleEntityIndex];
        int endIndex = indexVariableSupply.getIndex(end) + this.offsets[endEntityIndex];
        if (startIndex <= endIndex) {
            return startIndex <= middleIndex && middleIndex <= endIndex;
        }
        return middleIndex >= startIndex || middleIndex <= endIndex;
    }
}

