/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonListInverseVariableDemand;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.FlipSublistAction;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.KOptAffectedElements;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.KOptDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.MultipleDelegateList;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class KOptListMove<Solution_>
extends AbstractMove<Solution_> {
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final KOptDescriptor<?> descriptor;
    private final List<FlipSublistAction> equivalent2Opts;
    private final KOptAffectedElements affectedElementsInfo;
    private final MultipleDelegateList<?> combinedList;
    private final int postShiftAmount;
    private final int[] newEndIndices;
    private final Object[] originalEntities;

    public KOptListMove(ListVariableDescriptor<Solution_> listVariableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, KOptDescriptor<?> descriptor, List<FlipSublistAction> equivalent2Opts, int postShiftAmount, int[] newEndIndices) {
        this.listVariableDescriptor = listVariableDescriptor;
        this.descriptor = descriptor;
        this.equivalent2Opts = equivalent2Opts;
        this.postShiftAmount = postShiftAmount;
        this.newEndIndices = newEndIndices;
        if (equivalent2Opts.isEmpty()) {
            this.affectedElementsInfo = KOptAffectedElements.forMiddleRange(0, 0);
            this.combinedList = new MultipleDelegateList(new List[0]);
        } else if (postShiftAmount != 0) {
            this.affectedElementsInfo = KOptAffectedElements.forMiddleRange(0, equivalent2Opts.get(0).getCombinedList().size());
            this.combinedList = equivalent2Opts.get(0).getCombinedList();
        } else {
            KOptAffectedElements currentAffectedElements = equivalent2Opts.get(0).getAffectedElements();
            this.combinedList = equivalent2Opts.get(0).getCombinedList();
            for (int i = 1; i < equivalent2Opts.size(); ++i) {
                currentAffectedElements = currentAffectedElements.merge(equivalent2Opts.get(i).getAffectedElements());
            }
            this.affectedElementsInfo = currentAffectedElements;
        }
        this.originalEntities = new Object[this.combinedList.delegates.length];
        for (int i = 0; i < this.originalEntities.length; ++i) {
            this.originalEntities[i] = inverseVariableSupply.getInverseSingleton(this.combinedList.delegates[i].get(0));
        }
    }

    KOptDescriptor<?> getDescriptor() {
        return this.descriptor;
    }

    @Override
    protected AbstractMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        if (this.equivalent2Opts.isEmpty()) {
            return this;
        }
        ArrayList<FlipSublistAction> inverse2Opts = new ArrayList<FlipSublistAction>(this.equivalent2Opts.size());
        for (int i = this.equivalent2Opts.size() - 1; i >= 0; --i) {
            inverse2Opts.add(this.equivalent2Opts.get(i).createUndoMove());
        }
        int[] originalEndIndices = new int[this.newEndIndices.length];
        for (int i = 0; i < originalEndIndices.length - 1; ++i) {
            originalEndIndices[i] = this.combinedList.offsets[i + 1] - 1;
        }
        originalEndIndices[originalEndIndices.length - 1] = this.combinedList.size() - 1;
        return new UndoKOptListMove(this.listVariableDescriptor, this.descriptor, inverse2Opts, -this.postShiftAmount, originalEndIndices, this.originalEntities);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        this.combinedList.actOnAffectedElements(this.originalEntities, (entity, start, end) -> innerScoreDirector.beforeListVariableChanged(this.listVariableDescriptor, entity, (int)start, (int)end));
        for (FlipSublistAction move : this.equivalent2Opts) {
            move.doMoveOnGenuineVariables();
        }
        this.combinedList.moveElementsOfDelegates(this.newEndIndices);
        Collections.rotate(this.combinedList, this.postShiftAmount);
        this.combinedList.actOnAffectedElements(this.originalEntities, (entity, start, end) -> innerScoreDirector.afterListVariableChanged(this.listVariableDescriptor, entity, (int)start, (int)end));
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return !this.equivalent2Opts.isEmpty();
    }

    @Override
    public Move<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        ArrayList<FlipSublistAction> rebasedEquivalent2Opts = new ArrayList<FlipSublistAction>(this.equivalent2Opts.size());
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)destinationScoreDirector;
        for (FlipSublistAction twoOpt : this.equivalent2Opts) {
            rebasedEquivalent2Opts.add(twoOpt.rebase(innerScoreDirector));
        }
        return new KOptListMove<Solution_>(this.listVariableDescriptor, innerScoreDirector.getSupplyManager().demand(new SingletonListInverseVariableDemand<Solution_>(this.listVariableDescriptor)), this.descriptor, rebasedEquivalent2Opts, this.postShiftAmount, this.newEndIndices);
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.descriptor.getK() + "-opt(" + this.listVariableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<?> getPlanningEntities() {
        return List.of(this.originalEntities);
    }

    @Override
    public Collection<?> getPlanningValues() {
        ArrayList out = new ArrayList();
        if (this.affectedElementsInfo.getWrappedStartIndex() != -1) {
            out.addAll(this.combinedList.subList(this.affectedElementsInfo.getWrappedStartIndex(), this.combinedList.size()));
            out.addAll(this.combinedList.subList(0, this.affectedElementsInfo.getWrappedEndIndex()));
        }
        for (Pair<Integer, Integer> affectedInterval : this.affectedElementsInfo.getAffectedMiddleRangeList()) {
            out.addAll(this.combinedList.subList(affectedInterval.getKey(), affectedInterval.getValue()));
        }
        return out;
    }

    public String toString() {
        return this.descriptor.toString();
    }

    private static final class UndoKOptListMove<Solution_, Node_>
    extends AbstractMove<Solution_> {
        private final ListVariableDescriptor<Solution_> listVariableDescriptor;
        private final KOptDescriptor<Node_> descriptor;
        private final List<FlipSublistAction> equivalent2Opts;
        private final MultipleDelegateList<?> combinedList;
        private final int preShiftAmount;
        private final int[] newEndIndices;
        private final Object[] originalEntities;

        public UndoKOptListMove(ListVariableDescriptor<Solution_> listVariableDescriptor, KOptDescriptor<Node_> descriptor, List<FlipSublistAction> equivalent2Opts, int preShiftAmount, int[] newEndIndices, Object[] originalEntities) {
            this.listVariableDescriptor = listVariableDescriptor;
            this.descriptor = descriptor;
            this.equivalent2Opts = equivalent2Opts;
            this.preShiftAmount = preShiftAmount;
            this.combinedList = equivalent2Opts.get(0).getCombinedList();
            this.newEndIndices = newEndIndices;
            this.originalEntities = originalEntities;
        }

        @Override
        public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
            return true;
        }

        @Override
        protected AbstractMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
            InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
            this.combinedList.actOnAffectedElements(this.originalEntities, (entity, start, end) -> innerScoreDirector.beforeListVariableChanged(this.listVariableDescriptor, entity, (int)start, (int)end));
            Collections.rotate(this.combinedList, this.preShiftAmount);
            this.combinedList.moveElementsOfDelegates(this.newEndIndices);
            for (FlipSublistAction move : this.equivalent2Opts) {
                move.doMoveOnGenuineVariables();
            }
            this.combinedList.actOnAffectedElements(this.originalEntities, (entity, start, end) -> innerScoreDirector.afterListVariableChanged(this.listVariableDescriptor, entity, (int)start, (int)end));
        }

        public String toString() {
            return "Undo" + this.descriptor.toString();
        }
    }
}

