/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.value.nearby;

import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.AbstractNearbyDistanceMatrixDemand;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.RandomNearbyIterator;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.mimic.MimicReplayingEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.nearby.AbstractNearbyValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.nearby.OriginalNearbyValueIterator;
import ai.timefold.solver.core.impl.heuristic.selector.value.nearby.ValueNearbyDistanceMatrixDemand;
import java.util.Iterator;

public final class NearEntityNearbyValueSelector<Solution_>
extends AbstractNearbyValueSelector<Solution_, ValueSelector<Solution_>, EntitySelector<Solution_>> {
    private final boolean discardNearbyIndexZero;

    public NearEntityNearbyValueSelector(ValueSelector<Solution_> childValueSelector, EntitySelector<Solution_> originEntitySelector, NearbyDistanceMeter<?, ?> nearbyDistanceMeter, NearbyRandom nearbyRandom, boolean randomSelection) {
        super(childValueSelector, originEntitySelector, nearbyDistanceMeter, nearbyRandom, randomSelection);
        this.discardNearbyIndexZero = childValueSelector.getVariableDescriptor().getVariablePropertyType().isAssignableFrom(originEntitySelector.getEntityDescriptor().getEntityClass());
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return ((ValueSelector)this.childSelector).getVariableDescriptor();
    }

    @Override
    protected EntitySelector<Solution_> castReplayingSelector(Object uncastReplayingSelector) {
        if (!(uncastReplayingSelector instanceof MimicReplayingEntitySelector)) {
            throw new IllegalStateException("Impossible state: Nearby value selector (" + this + ") did not receive a replaying entity selector (" + uncastReplayingSelector + ").");
        }
        return (EntitySelector)uncastReplayingSelector;
    }

    @Override
    protected AbstractNearbyDistanceMatrixDemand<?, ?, ?, ?> createDemand() {
        return new ValueNearbyDistanceMatrixDemand(this.nearbyDistanceMeter, this.nearbyRandom, (ValueSelector)this.childSelector, (EntitySelector)this.replayingSelector, this::computeDestinationSize);
    }

    private int computeDestinationSize(Object origin) {
        long childSize = ((ValueSelector)this.childSelector).getSize(origin);
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The childValueSelector (" + this.childSelector + ") has a valueSize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        int destinationSize = (int)childSize;
        if (this.randomSelection) {
            int overallSizeMaximum = this.nearbyRandom.getOverallSizeMaximum();
            if (this.discardNearbyIndexZero && overallSizeMaximum < Integer.MAX_VALUE) {
                ++overallSizeMaximum;
            }
            if (destinationSize > overallSizeMaximum) {
                destinationSize = overallSizeMaximum;
            }
        }
        return destinationSize;
    }

    @Override
    public boolean isCountable() {
        return ((ValueSelector)this.childSelector).isCountable();
    }

    @Override
    public long getSize(Object entity) {
        return ((ValueSelector)this.childSelector).getSize(entity) - (long)(this.discardNearbyIndexZero ? 1 : 0);
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        Iterator<Object> replayingOriginEntityIterator = ((EntitySelector)this.replayingSelector).iterator();
        if (!this.randomSelection) {
            return new OriginalNearbyValueIterator(this.nearbyDistanceMatrix, replayingOriginEntityIterator, ((ValueSelector)this.childSelector).getSize(entity), this.discardNearbyIndexZero);
        }
        return new RandomNearbyIterator(this.nearbyDistanceMatrix, this.nearbyRandom, this.workingRandom, replayingOriginEntityIterator, ((ValueSelector)this.childSelector).getSize(entity), this.discardNearbyIndexZero);
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return ((ValueSelector)this.childSelector).endingIterator(entity);
    }
}

