/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.partitionedsearch;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.config.phase.PhaseConfig;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.partitionedsearch.PartitionSolver;
import ai.timefold.solver.core.impl.partitionedsearch.PartitionedSearchPhase;
import ai.timefold.solver.core.impl.partitionedsearch.event.PartitionedSearchPhaseLifecycleListener;
import ai.timefold.solver.core.impl.partitionedsearch.partitioner.SolutionPartitioner;
import ai.timefold.solver.core.impl.partitionedsearch.queue.PartitionQueue;
import ai.timefold.solver.core.impl.partitionedsearch.scope.PartitionChangeMove;
import ai.timefold.solver.core.impl.partitionedsearch.scope.PartitionedSearchPhaseScope;
import ai.timefold.solver.core.impl.partitionedsearch.scope.PartitionedSearchStepScope;
import ai.timefold.solver.core.impl.phase.AbstractPhase;
import ai.timefold.solver.core.impl.phase.Phase;
import ai.timefold.solver.core.impl.phase.PhaseFactory;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.recaller.BestSolutionRecaller;
import ai.timefold.solver.core.impl.solver.recaller.BestSolutionRecallerFactory;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.ChildThreadPlumbingTermination;
import ai.timefold.solver.core.impl.solver.termination.OrCompositeTermination;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;
import ai.timefold.solver.core.impl.solver.thread.ThreadUtils;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;

public class DefaultPartitionedSearchPhase<Solution_>
extends AbstractPhase<Solution_>
implements PartitionedSearchPhase<Solution_>,
PartitionedSearchPhaseLifecycleListener<Solution_> {
    protected final SolutionPartitioner<Solution_> solutionPartitioner;
    protected final ThreadFactory threadFactory;
    protected final Integer runnablePartThreadLimit;
    protected final List<PhaseConfig> phaseConfigList;
    protected final HeuristicConfigPolicy<Solution_> configPolicy;

    private DefaultPartitionedSearchPhase(Builder<Solution_> builder) {
        super(builder);
        this.solutionPartitioner = builder.solutionPartitioner;
        this.threadFactory = builder.threadFactory;
        this.runnablePartThreadLimit = builder.runnablePartThreadLimit;
        this.phaseConfigList = builder.phaseConfigList;
        this.configPolicy = builder.configPolicy;
    }

    @Override
    public String getPhaseTypeString() {
        return "Partitioned Search";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void solve(SolverScope<Solution_> solverScope) {
        PartitionedSearchPhaseScope<Solution_> phaseScope = new PartitionedSearchPhaseScope<Solution_>(solverScope);
        List<Solution_> partList = this.solutionPartitioner.splitWorkingSolution(solverScope.getScoreDirector(), this.runnablePartThreadLimit);
        int partCount = partList.size();
        phaseScope.setPartCount(partCount);
        this.phaseStarted(phaseScope);
        ExecutorService executor = this.createThreadPoolExecutor(partCount);
        ChildThreadPlumbingTermination childThreadPlumbingTermination = new ChildThreadPlumbingTermination();
        PartitionQueue partitionQueue = new PartitionQueue(partCount);
        Semaphore runnablePartThreadSemaphore = this.runnablePartThreadLimit == null ? null : new Semaphore(this.runnablePartThreadLimit, true);
        try {
            ListIterator<Solution_> it = partList.listIterator();
            while (it.hasNext()) {
                int partIndex = it.nextIndex();
                Solution_ part = it.next();
                PartitionSolver partitionSolver = this.buildPartitionSolver(childThreadPlumbingTermination, runnablePartThreadSemaphore, solverScope);
                partitionSolver.addEventListener(event -> {
                    InnerScoreDirector childScoreDirector = partitionSolver.solverScope.getScoreDirector();
                    Move move = PartitionChangeMove.createMove(childScoreDirector, partIndex);
                    InnerScoreDirector parentScoreDirector = solverScope.getScoreDirector();
                    move = move.rebase((ScoreDirector)parentScoreDirector);
                    partitionQueue.addMove(partIndex, move);
                });
                executor.submit(() -> {
                    try {
                        partitionSolver.solve(part);
                        long partCalculationCount = partitionSolver.getScoreCalculationCount();
                        partitionQueue.addFinish(partIndex, partCalculationCount);
                    }
                    catch (Throwable throwable) {
                        this.logger.trace("{}            Part thread ({}) exception that will be propagated to the solver thread.", new Object[]{this.logIndentation, partIndex, throwable});
                        partitionQueue.addExceptionThrown(partIndex, throwable);
                    }
                });
            }
            for (PartitionChangeMove step : partitionQueue) {
                PartitionedSearchStepScope stepScope = new PartitionedSearchStepScope(phaseScope);
                this.stepStarted(stepScope);
                stepScope.setStep(step);
                if (this.logger.isDebugEnabled()) {
                    stepScope.setStepString(step.toString());
                }
                this.doStep(stepScope);
                this.stepEnded(stepScope);
                phaseScope.setLastCompletedStepScope(stepScope);
            }
            phaseScope.addChildThreadsScoreCalculationCount(partitionQueue.getPartsCalculationCount());
        }
        finally {
            childThreadPlumbingTermination.terminateChildren();
            ThreadUtils.shutdownAwaitOrKill(executor, this.logIndentation, "Partitioned Search");
        }
        this.phaseEnded(phaseScope);
    }

    private ExecutorService createThreadPoolExecutor(int partCount) {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(partCount, this.threadFactory);
        if (threadPoolExecutor.getMaximumPoolSize() < partCount) {
            throw new IllegalStateException("The threadPoolExecutor's maximumPoolSize (" + threadPoolExecutor.getMaximumPoolSize() + ") is less than the partCount (" + partCount + "), so some partitions will starve.\nNormally this is impossible because the threadPoolExecutor should be unbounded. Use runnablePartThreadLimit (" + this.runnablePartThreadLimit + ") instead to avoid CPU hogging and live locks.");
        }
        return threadPoolExecutor;
    }

    public PartitionSolver<Solution_> buildPartitionSolver(ChildThreadPlumbingTermination<Solution_> childThreadPlumbingTermination, Semaphore runnablePartThreadSemaphore, SolverScope<Solution_> solverScope) {
        BestSolutionRecaller bestSolutionRecaller = BestSolutionRecallerFactory.create().buildBestSolutionRecaller(this.configPolicy.getEnvironmentMode());
        OrCompositeTermination partTermination = new OrCompositeTermination(childThreadPlumbingTermination, this.phaseTermination.createChildThreadTermination(solverScope, ChildThreadType.PART_THREAD));
        List<Phase<Solution_>> phaseList = PhaseFactory.buildPhases(this.phaseConfigList, this.configPolicy, bestSolutionRecaller, partTermination);
        SolverScope<Solution_> partSolverScope = solverScope.createChildThreadSolverScope(ChildThreadType.PART_THREAD);
        partSolverScope.setRunnableThreadSemaphore(runnablePartThreadSemaphore);
        return new PartitionSolver(bestSolutionRecaller, partTermination, phaseList, partSolverScope);
    }

    protected void doStep(PartitionedSearchStepScope<Solution_> stepScope) {
        PartitionChangeMove<Solution_> nextStep = stepScope.getStep();
        nextStep.doMoveOnly(stepScope.getScoreDirector());
        this.calculateWorkingStepScore(stepScope, nextStep);
        this.solver.getBestSolutionRecaller().processWorkingSolutionDuringStep(stepScope);
    }

    @Override
    public void phaseStarted(PartitionedSearchPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
    }

    @Override
    public void stepStarted(PartitionedSearchStepScope<Solution_> stepScope) {
        super.stepStarted(stepScope);
    }

    @Override
    public void stepEnded(PartitionedSearchStepScope<Solution_> stepScope) {
        super.stepEnded(stepScope);
        AbstractPhaseScope phaseScope = stepScope.getPhaseScope();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}    PS step ({}), time spent ({}), score ({}), {} best score ({}), picked move ({}).", new Object[]{this.logIndentation, stepScope.getStepIndex(), phaseScope.calculateSolverTimeMillisSpentUpToNow(), stepScope.getScore(), stepScope.getBestScoreImproved() ? "new" : "   ", phaseScope.getBestScore(), stepScope.getStepString()});
        }
    }

    @Override
    public void phaseEnded(PartitionedSearchPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        phaseScope.endingNow();
        this.logger.info("{}Partitioned Search phase ({}) ended: time spent ({}), best score ({}), score calculation speed ({}/sec), step total ({}), partCount ({}), runnablePartThreadLimit ({}).", new Object[]{this.logIndentation, this.phaseIndex, phaseScope.calculateSolverTimeMillisSpentUpToNow(), phaseScope.getBestScore(), phaseScope.getPhaseScoreCalculationSpeed(), phaseScope.getNextStepIndex(), phaseScope.getPartCount(), this.runnablePartThreadLimit});
    }

    public static class Builder<Solution_>
    extends AbstractPhase.Builder<Solution_> {
        private final SolutionPartitioner<Solution_> solutionPartitioner;
        private final ThreadFactory threadFactory;
        private final Integer runnablePartThreadLimit;
        private final List<PhaseConfig> phaseConfigList;
        private final HeuristicConfigPolicy<Solution_> configPolicy;

        public Builder(int phaseIndex, String logIndentation, Termination<Solution_> phaseTermination, SolutionPartitioner<Solution_> solutionPartitioner, ThreadFactory threadFactory, Integer runnablePartThreadLimit, List<PhaseConfig> phaseConfigList, HeuristicConfigPolicy<Solution_> configPolicy) {
            super(phaseIndex, logIndentation, phaseTermination);
            this.solutionPartitioner = solutionPartitioner;
            this.threadFactory = threadFactory;
            this.runnablePartThreadLimit = runnablePartThreadLimit;
            this.phaseConfigList = List.copyOf(phaseConfigList);
            this.configPolicy = configPolicy;
        }

        @Override
        public DefaultPartitionedSearchPhase<Solution_> build() {
            return new DefaultPartitionedSearchPhase(this);
        }
    }
}

