/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.constraint;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatch;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import ai.timefold.solver.core.api.score.stream.ConstraintJustification;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class DefaultIndictment<Score_ extends Score<Score_>>
implements Indictment<Score_> {
    private final Object indictedObject;
    private final Set<ConstraintMatch<Score_>> constraintMatchSet = new LinkedHashSet<ConstraintMatch<Score_>>();
    private List<ConstraintJustification> constraintJustificationList;
    private Score_ score;

    public DefaultIndictment(Object indictedObject, Score_ zeroScore) {
        this.indictedObject = indictedObject;
        this.score = zeroScore;
    }

    @Override
    public <IndictedObject_> IndictedObject_ getIndictedObject() {
        return (IndictedObject_)this.indictedObject;
    }

    @Override
    public Set<ConstraintMatch<Score_>> getConstraintMatchSet() {
        return this.constraintMatchSet;
    }

    @Override
    public List<ConstraintJustification> getJustificationList() {
        if (this.constraintJustificationList == null) {
            this.constraintJustificationList = this.constraintMatchSet.stream().map(s -> s.getJustification()).distinct().collect(Collectors.toList());
        }
        return this.constraintJustificationList;
    }

    @Override
    public Score_ getScore() {
        return this.score;
    }

    public void addConstraintMatch(ConstraintMatch<Score_> constraintMatch) {
        this.score = this.score.add(constraintMatch.getScore());
        boolean added = this.constraintMatchSet.add(constraintMatch);
        if (!added) {
            throw new IllegalStateException("The indictment (" + this + ") could not add constraintMatch (" + constraintMatch + ") to its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
        this.constraintJustificationList = null;
    }

    public void removeConstraintMatch(ConstraintMatch<Score_> constraintMatch) {
        this.score = this.score.subtract(constraintMatch.getScore());
        boolean removed = this.constraintMatchSet.remove(constraintMatch);
        if (!removed) {
            throw new IllegalStateException("The indictment (" + this + ") could not remove constraintMatch (" + constraintMatch + ") from its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
        this.constraintJustificationList = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DefaultIndictment) {
            DefaultIndictment other = (DefaultIndictment)o;
            return this.indictedObject.equals(other.indictedObject);
        }
        return false;
    }

    public int hashCode() {
        return this.indictedObject.hashCode();
    }

    public String toString() {
        return this.indictedObject + "=" + this.score;
    }
}

