/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.trend.InitializingScoreTrend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScoreDirectorFactory<Solution_, Score_ extends Score<Score_>>
implements InnerScoreDirectorFactory<Solution_, Score_> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SolutionDescriptor<Solution_> solutionDescriptor;
    protected InitializingScoreTrend initializingScoreTrend;
    protected InnerScoreDirectorFactory<Solution_, Score_> assertionScoreDirectorFactory = null;
    protected boolean assertClonedSolution = false;

    public AbstractScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
    }

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    @Override
    public ScoreDefinition<Score_> getScoreDefinition() {
        return this.solutionDescriptor.getScoreDefinition();
    }

    @Override
    public InitializingScoreTrend getInitializingScoreTrend() {
        return this.initializingScoreTrend;
    }

    public void setInitializingScoreTrend(InitializingScoreTrend initializingScoreTrend) {
        this.initializingScoreTrend = initializingScoreTrend;
    }

    public InnerScoreDirectorFactory<Solution_, Score_> getAssertionScoreDirectorFactory() {
        return this.assertionScoreDirectorFactory;
    }

    public void setAssertionScoreDirectorFactory(InnerScoreDirectorFactory<Solution_, Score_> assertionScoreDirectorFactory) {
        this.assertionScoreDirectorFactory = assertionScoreDirectorFactory;
    }

    public boolean isAssertClonedSolution() {
        return this.assertClonedSolution;
    }

    public void setAssertClonedSolution(boolean assertClonedSolution) {
        this.assertClonedSolution = assertClonedSolution;
    }

    @Override
    public InnerScoreDirector<Solution_, Score_> buildScoreDirector() {
        return this.buildScoreDirector(true, true);
    }

    @Override
    public void assertScoreFromScratch(Solution_ solution) {
        Score score = this.getSolutionDescriptor().getScore(solution);
        try (InnerScoreDirector uncorruptedScoreDirector = this.buildScoreDirector(false, true);){
            uncorruptedScoreDirector.setWorkingSolution(solution);
            Object uncorruptedScore = uncorruptedScoreDirector.calculateScore();
            if (!score.equals(uncorruptedScore)) {
                throw new IllegalStateException("Score corruption (" + score.subtract(uncorruptedScore).toShortString() + "): the solution's score (" + score + ") is not the uncorruptedScore (" + uncorruptedScore + ").");
            }
        }
    }
}

