/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director.easy;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.calculator.EasyScoreCalculator;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatch;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirector;
import ai.timefold.solver.core.impl.score.director.easy.EasyScoreDirectorFactory;
import java.util.Map;

public class EasyScoreDirector<Solution_, Score_ extends Score<Score_>>
extends AbstractScoreDirector<Solution_, Score_, EasyScoreDirectorFactory<Solution_, Score_>> {
    private final EasyScoreCalculator<Solution_, Score_> easyScoreCalculator;

    public EasyScoreDirector(EasyScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory, boolean lookUpEnabled, boolean constraintMatchEnabledPreference, EasyScoreCalculator<Solution_, Score_> easyScoreCalculator) {
        super(scoreDirectorFactory, lookUpEnabled, constraintMatchEnabledPreference);
        this.easyScoreCalculator = easyScoreCalculator;
    }

    public EasyScoreCalculator<Solution_, Score_> getEasyScoreCalculator() {
        return this.easyScoreCalculator;
    }

    @Override
    public Score_ calculateScore() {
        this.variableListenerSupport.assertNotificationQueuesAreEmpty();
        Score_ score = this.easyScoreCalculator.calculateScore(this.workingSolution);
        if (score == null) {
            throw new IllegalStateException("The easyScoreCalculator (" + this.easyScoreCalculator.getClass() + ") must return a non-null score (" + score + ") in the method calculateScore().");
        }
        if (!score.isSolutionInitialized()) {
            throw new IllegalStateException("The score (" + this + ")'s initScore (" + score.initScore() + ") should be 0.\nMaybe the score calculator (" + this.easyScoreCalculator.getClass() + ") is calculating the initScore too, although it's the score director's responsibility.");
        }
        if (this.workingInitScore != 0) {
            score = score.withInitScore(this.workingInitScore);
        }
        this.setCalculatedScore(score);
        return score;
    }

    @Override
    public boolean isConstraintMatchEnabled() {
        return false;
    }

    @Override
    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        throw new IllegalStateException(ConstraintMatch.class.getSimpleName() + " is not supported by " + EasyScoreDirector.class.getSimpleName() + ".");
    }

    @Override
    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        throw new IllegalStateException(ConstraintMatch.class.getSimpleName() + " is not supported by " + EasyScoreDirector.class.getSimpleName() + ".");
    }

    @Override
    public boolean requiresFlushing() {
        return false;
    }
}

