/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.solver.Solver;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import ai.timefold.solver.core.config.constructionheuristic.placer.EntityPlacerConfig;
import ai.timefold.solver.core.config.constructionheuristic.placer.QueuedEntityPlacerConfig;
import ai.timefold.solver.core.config.localsearch.LocalSearchPhaseConfig;
import ai.timefold.solver.core.config.phase.PhaseConfig;
import ai.timefold.solver.core.config.score.director.ScoreDirectorFactoryConfig;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.config.solver.monitoring.MonitoringConfig;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.config.solver.random.RandomType;
import ai.timefold.solver.core.config.solver.termination.TerminationConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.AbstractFromConfigFactory;
import ai.timefold.solver.core.impl.constructionheuristic.DefaultConstructionHeuristicPhaseFactory;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.phase.Phase;
import ai.timefold.solver.core.impl.phase.PhaseFactory;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.ScoreDirectorFactoryFactory;
import ai.timefold.solver.core.impl.solver.ClassInstanceCache;
import ai.timefold.solver.core.impl.solver.DefaultSolver;
import ai.timefold.solver.core.impl.solver.change.DefaultProblemChangeDirector;
import ai.timefold.solver.core.impl.solver.random.DefaultRandomFactory;
import ai.timefold.solver.core.impl.solver.random.RandomFactory;
import ai.timefold.solver.core.impl.solver.recaller.BestSolutionRecaller;
import ai.timefold.solver.core.impl.solver.recaller.BestSolutionRecallerFactory;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.BasicPlumbingTermination;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import ai.timefold.solver.core.impl.solver.termination.TerminationFactory;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSolverFactory<Solution_>
implements SolverFactory<Solution_> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSolverFactory.class);
    private static final long DEFAULT_RANDOM_SEED = 0L;
    private final SolverConfig solverConfig;
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final InnerScoreDirectorFactory<Solution_, ?> scoreDirectorFactory;

    public DefaultSolverFactory(SolverConfig solverConfig) {
        this.solverConfig = Objects.requireNonNull(solverConfig, "The solverConfig (" + solverConfig + ") cannot be null.");
        this.solutionDescriptor = this.buildSolutionDescriptor();
        this.scoreDirectorFactory = this.buildScoreDirectorFactory();
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public <Score_ extends Score<Score_>> InnerScoreDirectorFactory<Solution_, Score_> getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    @Override
    public Solver<Solution_> buildSolver() {
        boolean daemon_ = Objects.requireNonNullElse(this.solverConfig.getDaemon(), false);
        SolverScope<Solution_> solverScope = new SolverScope<Solution_>();
        MonitoringConfig monitoringConfig = this.solverConfig.determineMetricConfig();
        solverScope.setMonitoringTags(Tags.empty());
        if (!monitoringConfig.getSolverMetricList().isEmpty()) {
            solverScope.setSolverMetricSet(EnumSet.copyOf(monitoringConfig.getSolverMetricList()));
        } else {
            solverScope.setSolverMetricSet(EnumSet.noneOf(SolverMetric.class));
        }
        EnvironmentMode environmentMode_ = this.solverConfig.determineEnvironmentMode();
        InnerScoreDirector<Solution_, ?> innerScoreDirector = this.scoreDirectorFactory.buildScoreDirector(true, environmentMode_.isAsserted());
        solverScope.setScoreDirector(innerScoreDirector);
        solverScope.setProblemChangeDirector(new DefaultProblemChangeDirector<Solution_>(innerScoreDirector));
        if ((solverScope.isMetricEnabled(SolverMetric.CONSTRAINT_MATCH_TOTAL_STEP_SCORE) || solverScope.isMetricEnabled(SolverMetric.CONSTRAINT_MATCH_TOTAL_BEST_SCORE)) && !solverScope.getScoreDirector().isConstraintMatchEnabled()) {
            LOGGER.warn("The metrics [{}, {}] cannot function properly because ConstraintMatches are not supported on the ScoreDirector.", (Object)SolverMetric.CONSTRAINT_MATCH_TOTAL_STEP_SCORE.getMeterId(), (Object)SolverMetric.CONSTRAINT_MATCH_TOTAL_BEST_SCORE.getMeterId());
        }
        Integer moveThreadCount_ = new MoveThreadCountResolver().resolveMoveThreadCount(this.solverConfig.getMoveThreadCount());
        BestSolutionRecaller bestSolutionRecaller = BestSolutionRecallerFactory.create().buildBestSolutionRecaller(environmentMode_);
        HeuristicConfigPolicy<Solution_> configPolicy = new HeuristicConfigPolicy.Builder<Solution_>(environmentMode_, moveThreadCount_, this.solverConfig.getMoveThreadBufferSize(), this.solverConfig.getThreadFactoryClass(), this.scoreDirectorFactory.getInitializingScoreTrend(), this.solutionDescriptor, ClassInstanceCache.create()).build();
        TerminationConfig terminationConfig_ = Objects.requireNonNullElseGet(this.solverConfig.getTerminationConfig(), TerminationConfig::new);
        BasicPlumbingTermination basicPlumbingTermination = new BasicPlumbingTermination(daemon_);
        Termination termination = TerminationFactory.create(terminationConfig_).buildTermination(configPolicy, basicPlumbingTermination);
        List<Phase<Solution_>> phaseList = this.buildPhaseList(configPolicy, bestSolutionRecaller, termination);
        RandomFactory randomFactory = this.buildRandomFactory(environmentMode_);
        return new DefaultSolver(environmentMode_, randomFactory, bestSolutionRecaller, basicPlumbingTermination, termination, phaseList, solverScope, moveThreadCount_ == null ? "NONE" : Integer.toString(moveThreadCount_));
    }

    private SolutionDescriptor<Solution_> buildSolutionDescriptor() {
        if (this.solverConfig.getSolutionClass() == null) {
            throw new IllegalArgumentException("The solver configuration must have a solutionClass (" + this.solverConfig.getSolutionClass() + "). If you're using the Quarkus extension or Spring Boot starter, it should have been filled in already.");
        }
        if (ConfigUtils.isEmptyCollection(this.solverConfig.getEntityClassList())) {
            throw new IllegalArgumentException("The solver configuration must have at least 1 entityClass (" + this.solverConfig.getEntityClassList() + "). If you're using the Quarkus extension or Spring Boot starter, it should have been filled in already.");
        }
        SolutionDescriptor<?> solutionDescriptor = SolutionDescriptor.buildSolutionDescriptor(this.solverConfig.determineDomainAccessType(), this.solverConfig.getSolutionClass(), this.solverConfig.getGizmoMemberAccessorMap(), this.solverConfig.getGizmoSolutionClonerMap(), this.solverConfig.getEntityClassList());
        EnvironmentMode environmentMode = this.solverConfig.determineEnvironmentMode();
        if (environmentMode.isAsserted()) {
            solutionDescriptor.setAssertModelForCloning(true);
        }
        return solutionDescriptor;
    }

    private InnerScoreDirectorFactory<Solution_, ?> buildScoreDirectorFactory() {
        EnvironmentMode environmentMode = this.solverConfig.determineEnvironmentMode();
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig_ = Objects.requireNonNullElseGet(this.solverConfig.getScoreDirectorFactoryConfig(), ScoreDirectorFactoryConfig::new);
        ScoreDirectorFactoryFactory scoreDirectorFactoryFactory = new ScoreDirectorFactoryFactory(scoreDirectorFactoryConfig_);
        return scoreDirectorFactoryFactory.buildScoreDirectorFactory(this.solverConfig.getClassLoader(), environmentMode, this.solutionDescriptor);
    }

    private RandomFactory buildRandomFactory(EnvironmentMode environmentMode_) {
        RandomFactory randomFactory;
        if (this.solverConfig.getRandomFactoryClass() != null) {
            if (this.solverConfig.getRandomType() != null || this.solverConfig.getRandomSeed() != null) {
                throw new IllegalArgumentException("The solverConfig with randomFactoryClass (" + this.solverConfig.getRandomFactoryClass() + ") has a non-null randomType (" + this.solverConfig.getRandomType() + ") or a non-null randomSeed (" + this.solverConfig.getRandomSeed() + ").");
            }
            randomFactory = ConfigUtils.newInstance(this.solverConfig, "randomFactoryClass", this.solverConfig.getRandomFactoryClass());
        } else {
            RandomType randomType_ = Objects.requireNonNullElse(this.solverConfig.getRandomType(), RandomType.JDK);
            Long randomSeed_ = this.solverConfig.getRandomSeed();
            if (this.solverConfig.getRandomSeed() == null && environmentMode_ != EnvironmentMode.NON_REPRODUCIBLE) {
                randomSeed_ = 0L;
            }
            randomFactory = new DefaultRandomFactory(randomType_, randomSeed_);
        }
        return randomFactory;
    }

    private List<Phase<Solution_>> buildPhaseList(HeuristicConfigPolicy<Solution_> configPolicy, BestSolutionRecaller<Solution_> bestSolutionRecaller, Termination<Solution_> termination) {
        List<PhaseConfig> phaseConfigList_ = this.solverConfig.getPhaseConfigList();
        if (ConfigUtils.isEmptyCollection(phaseConfigList_)) {
            Collection<EntityDescriptor<Solution_>> genuineEntityDescriptors = configPolicy.getSolutionDescriptor().getGenuineEntityDescriptors();
            Map entityClassToListVariableDescriptorListMap = configPolicy.getSolutionDescriptor().getListVariableDescriptors().stream().collect(Collectors.groupingBy(listVariableDescriptor -> listVariableDescriptor.getEntityDescriptor().getEntityClass(), Collectors.mapping(Function.identity(), Collectors.toList())));
            phaseConfigList_ = new ArrayList<PhaseConfig>(genuineEntityDescriptors.size() + 1);
            for (EntityDescriptor<Solution_> genuineEntityDescriptor : genuineEntityDescriptors) {
                EntityPlacerConfig entityPlacerConfig;
                ConstructionHeuristicPhaseConfig constructionHeuristicPhaseConfig = new ConstructionHeuristicPhaseConfig();
                if (entityClassToListVariableDescriptorListMap.containsKey(genuineEntityDescriptor.getEntityClass())) {
                    List listVariableDescriptorList = entityClassToListVariableDescriptorListMap.get(genuineEntityDescriptor.getEntityClass());
                    if (listVariableDescriptorList.size() != 1) {
                        throw new IllegalArgumentException("Construction Heuristic phase does not support multiple list variables (" + listVariableDescriptorList + ") for planning entity (" + genuineEntityDescriptor.getEntityClass() + ").");
                    }
                    entityPlacerConfig = DefaultConstructionHeuristicPhaseFactory.buildListVariableQueuedValuePlacerConfig(configPolicy, (ListVariableDescriptor)listVariableDescriptorList.get(0));
                } else {
                    entityPlacerConfig = new QueuedEntityPlacerConfig().withEntitySelectorConfig(AbstractFromConfigFactory.getDefaultEntitySelectorConfigForEntity(configPolicy, genuineEntityDescriptor));
                }
                constructionHeuristicPhaseConfig.setEntityPlacerConfig(entityPlacerConfig);
                phaseConfigList_.add(constructionHeuristicPhaseConfig);
            }
            phaseConfigList_.add(new LocalSearchPhaseConfig());
        }
        return PhaseFactory.buildPhases(phaseConfigList_, configPolicy, bestSolutionRecaller, termination);
    }

    protected static class MoveThreadCountResolver {
        protected MoveThreadCountResolver() {
        }

        protected Integer resolveMoveThreadCount(String moveThreadCount) {
            Integer resolvedMoveThreadCount;
            int availableProcessorCount = this.getAvailableProcessors();
            if (moveThreadCount == null || moveThreadCount.equals("NONE")) {
                return null;
            }
            if (moveThreadCount.equals("AUTO")) {
                resolvedMoveThreadCount = availableProcessorCount - 2;
                if (resolvedMoveThreadCount > 4) {
                    resolvedMoveThreadCount = 4;
                }
                if (resolvedMoveThreadCount <= 1) {
                    return null;
                }
            } else {
                resolvedMoveThreadCount = ConfigUtils.resolvePoolSize("moveThreadCount", moveThreadCount, "NONE", "AUTO");
            }
            if (resolvedMoveThreadCount < 1) {
                throw new IllegalArgumentException("The moveThreadCount (" + moveThreadCount + ") resulted in a resolvedMoveThreadCount (" + resolvedMoveThreadCount + ") that is lower than 1.");
            }
            if (resolvedMoveThreadCount > availableProcessorCount) {
                LOGGER.warn("The resolvedMoveThreadCount ({}) is higher than the availableProcessorCount ({}), which is counter-efficient.", (Object)resolvedMoveThreadCount, (Object)availableProcessorCount);
            }
            return resolvedMoveThreadCount;
        }

        protected int getAvailableProcessors() {
            return Runtime.getRuntime().availableProcessors();
        }
    }
}

