/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.termination;

import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.AbstractTermination;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;

public class ChildThreadPlumbingTermination<Solution_>
extends AbstractTermination<Solution_> {
    protected boolean terminateChildren = false;

    public synchronized boolean terminateChildren() {
        boolean terminationEarlySuccessful = !this.terminateChildren;
        this.terminateChildren = true;
        return terminationEarlySuccessful;
    }

    @Override
    public synchronized boolean isSolverTerminated(SolverScope<Solution_> solverScope) {
        if (Thread.currentThread().isInterrupted()) {
            this.logger.info("A child solver thread got interrupted, so these child solvers are terminating early.");
            this.terminateChildren = true;
        }
        return this.terminateChildren;
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope<Solution_> phaseScope) {
        throw new IllegalStateException(ChildThreadPlumbingTermination.class.getSimpleName() + " configured only as solver termination. It is always bridged to phase termination.");
    }

    @Override
    public double calculateSolverTimeGradient(SolverScope<Solution_> solverScope) {
        return -1.0;
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope<Solution_> phaseScope) {
        throw new IllegalStateException(ChildThreadPlumbingTermination.class.getSimpleName() + " configured only as solver termination. It is always bridged to phase termination.");
    }

    @Override
    public Termination<Solution_> createChildThreadTermination(SolverScope<Solution_> solverScope, ChildThreadType childThreadType) {
        return this;
    }

    public String toString() {
        return "ChildThreadPlumbing()";
    }
}

