/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.buildin.simple;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.ScoreUtil;
import java.util.Objects;

public final class SimpleScore
implements Score<SimpleScore> {
    public static final SimpleScore ZERO = new SimpleScore(0, 0);
    public static final SimpleScore ONE = new SimpleScore(0, 1);
    private static final SimpleScore MINUS_ONE = new SimpleScore(0, -1);
    private final int initScore;
    private final int score;

    public static SimpleScore parseScore(String scoreString) {
        String[] scoreTokens = ScoreUtil.parseScoreTokens(SimpleScore.class, scoreString, "");
        int initScore = ScoreUtil.parseInitScore(SimpleScore.class, scoreString, scoreTokens[0]);
        int score = ScoreUtil.parseLevelAsInt(SimpleScore.class, scoreString, scoreTokens[1]);
        return SimpleScore.ofUninitialized(initScore, score);
    }

    public static SimpleScore ofUninitialized(int initScore, int score) {
        if (initScore == 0) {
            return SimpleScore.of(score);
        }
        return new SimpleScore(initScore, score);
    }

    public static SimpleScore of(int score) {
        return switch (score) {
            case -1 -> MINUS_ONE;
            case 0 -> ZERO;
            case 1 -> ONE;
            default -> new SimpleScore(0, score);
        };
    }

    private SimpleScore() {
        this(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    private SimpleScore(int initScore, int score) {
        this.initScore = initScore;
        this.score = score;
    }

    @Override
    public int initScore() {
        return this.initScore;
    }

    public int score() {
        return this.score;
    }

    @Deprecated(forRemoval=true)
    public int getScore() {
        return this.score;
    }

    @Override
    public SimpleScore withInitScore(int newInitScore) {
        return SimpleScore.ofUninitialized(newInitScore, this.score);
    }

    @Override
    public SimpleScore add(SimpleScore addend) {
        return SimpleScore.ofUninitialized(this.initScore + addend.initScore(), this.score + addend.score());
    }

    @Override
    public SimpleScore subtract(SimpleScore subtrahend) {
        return SimpleScore.ofUninitialized(this.initScore - subtrahend.initScore(), this.score - subtrahend.score());
    }

    @Override
    public SimpleScore multiply(double multiplicand) {
        return SimpleScore.ofUninitialized((int)Math.floor((double)this.initScore * multiplicand), (int)Math.floor((double)this.score * multiplicand));
    }

    @Override
    public SimpleScore divide(double divisor) {
        return SimpleScore.ofUninitialized((int)Math.floor((double)this.initScore / divisor), (int)Math.floor((double)this.score / divisor));
    }

    @Override
    public SimpleScore power(double exponent) {
        return SimpleScore.ofUninitialized((int)Math.floor(Math.pow(this.initScore, exponent)), (int)Math.floor(Math.pow(this.score, exponent)));
    }

    @Override
    public SimpleScore abs() {
        return SimpleScore.ofUninitialized(Math.abs(this.initScore), Math.abs(this.score));
    }

    @Override
    public SimpleScore zero() {
        return ZERO;
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0;
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.score};
    }

    public boolean equals(Object o) {
        if (o instanceof SimpleScore) {
            SimpleScore other = (SimpleScore)o;
            return this.initScore == other.initScore() && this.score == other.score();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, this.score);
    }

    @Override
    public int compareTo(SimpleScore other) {
        if (this.initScore != other.initScore()) {
            return Integer.compare(this.initScore, other.initScore());
        }
        return Integer.compare(this.score, other.score());
    }

    @Override
    public String toShortString() {
        return ScoreUtil.buildShortString(this, n -> n.intValue() != 0, "");
    }

    public String toString() {
        return ScoreUtil.getInitPrefix(this.initScore) + this.score;
    }
}

