/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.stream.bi;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintStream;
import ai.timefold.solver.core.api.score.stream.Joiners;
import ai.timefold.solver.core.api.score.stream.bi.BiConstraintBuilder;
import ai.timefold.solver.core.api.score.stream.bi.BiConstraintCollector;
import ai.timefold.solver.core.api.score.stream.quad.QuadConstraintStream;
import ai.timefold.solver.core.api.score.stream.tri.TriConstraintStream;
import ai.timefold.solver.core.api.score.stream.tri.TriJoiner;
import ai.timefold.solver.core.api.score.stream.uni.UniConstraintStream;
import ai.timefold.solver.core.impl.util.ConstantLambdaUtils;
import java.math.BigDecimal;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;

public interface BiConstraintStream<A, B>
extends ConstraintStream {
    public BiConstraintStream<A, B> filter(BiPredicate<A, B> var1);

    default public <C> TriConstraintStream<A, B, C> join(UniConstraintStream<C> otherStream) {
        return this.join(otherStream, new TriJoiner[0]);
    }

    default public <C> TriConstraintStream<A, B, C> join(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> joiner) {
        return this.join(otherStream, new TriJoiner[]{joiner});
    }

    default public <C> TriConstraintStream<A, B, C> join(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2) {
        return this.join(otherStream, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> TriConstraintStream<A, B, C> join(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3) {
        return this.join(otherStream, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> TriConstraintStream<A, B, C> join(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3, TriJoiner<A, B, C> joiner4) {
        return this.join(otherStream, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> TriConstraintStream<A, B, C> join(UniConstraintStream<C> var1, TriJoiner<A, B, C> ... var2);

    default public <C> TriConstraintStream<A, B, C> join(Class<C> otherClass) {
        return this.join(otherClass, new TriJoiner[0]);
    }

    default public <C> TriConstraintStream<A, B, C> join(Class<C> otherClass, TriJoiner<A, B, C> joiner) {
        return this.join(otherClass, new TriJoiner[]{joiner});
    }

    default public <C> TriConstraintStream<A, B, C> join(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2) {
        return this.join(otherClass, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> TriConstraintStream<A, B, C> join(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3) {
        return this.join(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> TriConstraintStream<A, B, C> join(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3, TriJoiner<A, B, C> joiner4) {
        return this.join(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> TriConstraintStream<A, B, C> join(Class<C> var1, TriJoiner<A, B, C> ... var2);

    default public <C> BiConstraintStream<A, B> ifExists(Class<C> otherClass, TriJoiner<A, B, C> joiner) {
        return this.ifExists(otherClass, new TriJoiner[]{joiner});
    }

    default public <C> BiConstraintStream<A, B> ifExists(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2) {
        return this.ifExists(otherClass, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> BiConstraintStream<A, B> ifExists(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3) {
        return this.ifExists(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> BiConstraintStream<A, B> ifExists(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3, TriJoiner<A, B, C> joiner4) {
        return this.ifExists(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> BiConstraintStream<A, B> ifExists(Class<C> var1, TriJoiner<A, B, C> ... var2);

    default public <C> BiConstraintStream<A, B> ifExists(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> joiner) {
        return this.ifExists(otherStream, new TriJoiner[]{joiner});
    }

    default public <C> BiConstraintStream<A, B> ifExists(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2) {
        return this.ifExists(otherStream, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> BiConstraintStream<A, B> ifExists(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3) {
        return this.ifExists(otherStream, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> BiConstraintStream<A, B> ifExists(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3, TriJoiner<A, B, C> joiner4) {
        return this.ifExists(otherStream, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> BiConstraintStream<A, B> ifExists(UniConstraintStream<C> var1, TriJoiner<A, B, C> ... var2);

    default public <C> BiConstraintStream<A, B> ifExistsIncludingUnassigned(Class<C> otherClass, TriJoiner<A, B, C> joiner) {
        return this.ifExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner});
    }

    default public <C> BiConstraintStream<A, B> ifExistsIncludingUnassigned(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2) {
        return this.ifExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> BiConstraintStream<A, B> ifExistsIncludingUnassigned(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3) {
        return this.ifExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> BiConstraintStream<A, B> ifExistsIncludingUnassigned(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3, TriJoiner<A, B, C> joiner4) {
        return this.ifExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> BiConstraintStream<A, B> ifExistsIncludingUnassigned(Class<C> var1, TriJoiner<A, B, C> ... var2);

    default public <C> BiConstraintStream<A, B> ifNotExists(Class<C> otherClass, TriJoiner<A, B, C> joiner) {
        return this.ifNotExists(otherClass, new TriJoiner[]{joiner});
    }

    default public <C> BiConstraintStream<A, B> ifNotExists(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2) {
        return this.ifNotExists(otherClass, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> BiConstraintStream<A, B> ifNotExists(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3) {
        return this.ifNotExists(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> BiConstraintStream<A, B> ifNotExists(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3, TriJoiner<A, B, C> joiner4) {
        return this.ifNotExists(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> BiConstraintStream<A, B> ifNotExists(Class<C> var1, TriJoiner<A, B, C> ... var2);

    default public <C> BiConstraintStream<A, B> ifNotExists(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> joiner) {
        return this.ifNotExists(otherStream, new TriJoiner[]{joiner});
    }

    default public <C> BiConstraintStream<A, B> ifNotExists(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2) {
        return this.ifNotExists(otherStream, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> BiConstraintStream<A, B> ifNotExists(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3) {
        return this.ifNotExists(otherStream, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> BiConstraintStream<A, B> ifNotExists(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3, TriJoiner<A, B, C> joiner4) {
        return this.ifNotExists(otherStream, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> BiConstraintStream<A, B> ifNotExists(UniConstraintStream<C> var1, TriJoiner<A, B, C> ... var2);

    default public <C> BiConstraintStream<A, B> ifNotExistsIncludingUnassigned(Class<C> otherClass, TriJoiner<A, B, C> joiner) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner});
    }

    default public <C> BiConstraintStream<A, B> ifNotExistsIncludingUnassigned(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> BiConstraintStream<A, B> ifNotExistsIncludingUnassigned(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> BiConstraintStream<A, B> ifNotExistsIncludingUnassigned(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3, TriJoiner<A, B, C> joiner4) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> BiConstraintStream<A, B> ifNotExistsIncludingUnassigned(Class<C> var1, TriJoiner<A, B, C> ... var2);

    public <ResultContainer_, Result_> UniConstraintStream<Result_> groupBy(BiConstraintCollector<A, B, ResultContainer_, Result_> var1);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_> BiConstraintStream<ResultA_, ResultB_> groupBy(BiConstraintCollector<A, B, ResultContainerA_, ResultA_> var1, BiConstraintCollector<A, B, ResultContainerB_, ResultB_> var2);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<ResultA_, ResultB_, ResultC_> groupBy(BiConstraintCollector<A, B, ResultContainerA_, ResultA_> var1, BiConstraintCollector<A, B, ResultContainerB_, ResultB_> var2, BiConstraintCollector<A, B, ResultContainerC_, ResultC_> var3);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<ResultA_, ResultB_, ResultC_, ResultD_> groupBy(BiConstraintCollector<A, B, ResultContainerA_, ResultA_> var1, BiConstraintCollector<A, B, ResultContainerB_, ResultB_> var2, BiConstraintCollector<A, B, ResultContainerC_, ResultC_> var3, BiConstraintCollector<A, B, ResultContainerD_, ResultD_> var4);

    public <GroupKey_> UniConstraintStream<GroupKey_> groupBy(BiFunction<A, B, GroupKey_> var1);

    public <GroupKey_, ResultContainer_, Result_> BiConstraintStream<GroupKey_, Result_> groupBy(BiFunction<A, B, GroupKey_> var1, BiConstraintCollector<A, B, ResultContainer_, Result_> var2);

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<GroupKey_, ResultB_, ResultC_> groupBy(BiFunction<A, B, GroupKey_> var1, BiConstraintCollector<A, B, ResultContainerB_, ResultB_> var2, BiConstraintCollector<A, B, ResultContainerC_, ResultC_> var3);

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKey_, ResultB_, ResultC_, ResultD_> groupBy(BiFunction<A, B, GroupKey_> var1, BiConstraintCollector<A, B, ResultContainerB_, ResultB_> var2, BiConstraintCollector<A, B, ResultContainerC_, ResultC_> var3, BiConstraintCollector<A, B, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_> BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(BiFunction<A, B, GroupKeyA_> var1, BiFunction<A, B, GroupKeyB_> var2);

    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(BiFunction<A, B, GroupKeyA_> var1, BiFunction<A, B, GroupKeyB_> var2, BiConstraintCollector<A, B, ResultContainer_, Result_> var3);

    public <GroupKeyA_, GroupKeyB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, ResultC_, ResultD_> groupBy(BiFunction<A, B, GroupKeyA_> var1, BiFunction<A, B, GroupKeyB_> var2, BiConstraintCollector<A, B, ResultContainerC_, ResultC_> var3, BiConstraintCollector<A, B, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_> TriConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_> groupBy(BiFunction<A, B, GroupKeyA_> var1, BiFunction<A, B, GroupKeyB_> var2, BiFunction<A, B, GroupKeyC_> var3);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultD_> groupBy(BiFunction<A, B, GroupKeyA_> var1, BiFunction<A, B, GroupKeyB_> var2, BiFunction<A, B, GroupKeyC_> var3, BiConstraintCollector<A, B, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> groupBy(BiFunction<A, B, GroupKeyA_> var1, BiFunction<A, B, GroupKeyB_> var2, BiFunction<A, B, GroupKeyC_> var3, BiFunction<A, B, GroupKeyD_> var4);

    public <ResultA_> UniConstraintStream<ResultA_> map(BiFunction<A, B, ResultA_> var1);

    public <ResultA_, ResultB_> BiConstraintStream<ResultA_, ResultB_> map(BiFunction<A, B, ResultA_> var1, BiFunction<A, B, ResultB_> var2);

    public <ResultA_, ResultB_, ResultC_> TriConstraintStream<ResultA_, ResultB_, ResultC_> map(BiFunction<A, B, ResultA_> var1, BiFunction<A, B, ResultB_> var2, BiFunction<A, B, ResultC_> var3);

    public <ResultA_, ResultB_, ResultC_, ResultD_> QuadConstraintStream<ResultA_, ResultB_, ResultC_, ResultD_> map(BiFunction<A, B, ResultA_> var1, BiFunction<A, B, ResultB_> var2, BiFunction<A, B, ResultC_> var3, BiFunction<A, B, ResultD_> var4);

    public <ResultB_> BiConstraintStream<A, ResultB_> flattenLast(Function<B, Iterable<ResultB_>> var1);

    public BiConstraintStream<A, B> distinct();

    default public BiConstraintStream<A, B> concat(UniConstraintStream<A> otherStream) {
        return this.concat(otherStream, ConstantLambdaUtils.uniConstantNull());
    }

    public BiConstraintStream<A, B> concat(UniConstraintStream<A> var1, Function<A, B> var2);

    public BiConstraintStream<A, B> concat(BiConstraintStream<A, B> var1);

    default public <C> TriConstraintStream<A, B, C> concat(TriConstraintStream<A, B, C> otherStream) {
        return this.concat(otherStream, ConstantLambdaUtils.biConstantNull());
    }

    public <C> TriConstraintStream<A, B, C> concat(TriConstraintStream<A, B, C> var1, BiFunction<A, B, C> var2);

    default public <C, D> QuadConstraintStream<A, B, C, D> concat(QuadConstraintStream<A, B, C, D> otherStream) {
        return this.concat(otherStream, ConstantLambdaUtils.biConstantNull(), ConstantLambdaUtils.biConstantNull());
    }

    public <C, D> QuadConstraintStream<A, B, C, D> concat(QuadConstraintStream<A, B, C, D> var1, BiFunction<A, B, C> var2, BiFunction<A, B, D> var3);

    public <ResultC_> TriConstraintStream<A, B, ResultC_> expand(BiFunction<A, B, ResultC_> var1);

    public <ResultC_, ResultD_> QuadConstraintStream<A, B, ResultC_, ResultD_> expand(BiFunction<A, B, ResultC_> var1, BiFunction<A, B, ResultD_> var2);

    default public <Score_ extends Score<Score_>> BiConstraintBuilder<A, B, Score_> penalize(Score_ constraintWeight) {
        return this.penalize(constraintWeight, ConstantLambdaUtils.biConstantOne());
    }

    default public <Score_ extends Score<Score_>> BiConstraintBuilder<A, B, Score_> penalizeLong(Score_ constraintWeight) {
        return this.penalizeLong(constraintWeight, ConstantLambdaUtils.biConstantOneLong());
    }

    default public <Score_ extends Score<Score_>> BiConstraintBuilder<A, B, Score_> penalizeBigDecimal(Score_ constraintWeight) {
        return this.penalizeBigDecimal(constraintWeight, ConstantLambdaUtils.biConstantOneBigDecimal());
    }

    public <Score_ extends Score<Score_>> BiConstraintBuilder<A, B, Score_> penalize(Score_ var1, ToIntBiFunction<A, B> var2);

    public <Score_ extends Score<Score_>> BiConstraintBuilder<A, B, Score_> penalizeLong(Score_ var1, ToLongBiFunction<A, B> var2);

    public <Score_ extends Score<Score_>> BiConstraintBuilder<A, B, Score_> penalizeBigDecimal(Score_ var1, BiFunction<A, B, BigDecimal> var2);

    @Deprecated(forRemoval=true, since="1.13.0")
    default public BiConstraintBuilder<A, B, ?> penalizeConfigurable() {
        return this.penalizeConfigurable(ConstantLambdaUtils.biConstantOne());
    }

    @Deprecated(forRemoval=true, since="1.13.0")
    public BiConstraintBuilder<A, B, ?> penalizeConfigurable(ToIntBiFunction<A, B> var1);

    @Deprecated(forRemoval=true, since="1.13.0")
    public BiConstraintBuilder<A, B, ?> penalizeConfigurableLong(ToLongBiFunction<A, B> var1);

    @Deprecated(forRemoval=true, since="1.13.0")
    public BiConstraintBuilder<A, B, ?> penalizeConfigurableBigDecimal(BiFunction<A, B, BigDecimal> var1);

    default public <Score_ extends Score<Score_>> BiConstraintBuilder<A, B, Score_> reward(Score_ constraintWeight) {
        return this.reward(constraintWeight, ConstantLambdaUtils.biConstantOne());
    }

    public <Score_ extends Score<Score_>> BiConstraintBuilder<A, B, Score_> reward(Score_ var1, ToIntBiFunction<A, B> var2);

    public <Score_ extends Score<Score_>> BiConstraintBuilder<A, B, Score_> rewardLong(Score_ var1, ToLongBiFunction<A, B> var2);

    public <Score_ extends Score<Score_>> BiConstraintBuilder<A, B, Score_> rewardBigDecimal(Score_ var1, BiFunction<A, B, BigDecimal> var2);

    @Deprecated(forRemoval=true, since="1.13.0")
    default public BiConstraintBuilder<A, B, ?> rewardConfigurable() {
        return this.rewardConfigurable(ConstantLambdaUtils.biConstantOne());
    }

    @Deprecated(forRemoval=true, since="1.13.0")
    public BiConstraintBuilder<A, B, ?> rewardConfigurable(ToIntBiFunction<A, B> var1);

    @Deprecated(forRemoval=true, since="1.13.0")
    public BiConstraintBuilder<A, B, ?> rewardConfigurableLong(ToLongBiFunction<A, B> var1);

    @Deprecated(forRemoval=true, since="1.13.0")
    public BiConstraintBuilder<A, B, ?> rewardConfigurableBigDecimal(BiFunction<A, B, BigDecimal> var1);

    default public <Score_ extends Score<Score_>> BiConstraintBuilder<A, B, Score_> impact(Score_ constraintWeight) {
        return this.impact(constraintWeight, ConstantLambdaUtils.biConstantOne());
    }

    public <Score_ extends Score<Score_>> BiConstraintBuilder<A, B, Score_> impact(Score_ var1, ToIntBiFunction<A, B> var2);

    public <Score_ extends Score<Score_>> BiConstraintBuilder<A, B, Score_> impactLong(Score_ var1, ToLongBiFunction<A, B> var2);

    public <Score_ extends Score<Score_>> BiConstraintBuilder<A, B, Score_> impactBigDecimal(Score_ var1, BiFunction<A, B, BigDecimal> var2);

    @Deprecated(forRemoval=true, since="1.13.0")
    default public BiConstraintBuilder<A, B, ?> impactConfigurable() {
        return this.impactConfigurable(ConstantLambdaUtils.biConstantOne());
    }

    @Deprecated(forRemoval=true, since="1.13.0")
    public BiConstraintBuilder<A, B, ?> impactConfigurable(ToIntBiFunction<A, B> var1);

    @Deprecated(forRemoval=true, since="1.13.0")
    public BiConstraintBuilder<A, B, ?> impactConfigurableLong(ToLongBiFunction<A, B> var1);

    @Deprecated(forRemoval=true, since="1.13.0")
    public BiConstraintBuilder<A, B, ?> impactConfigurableBigDecimal(BiFunction<A, B, BigDecimal> var1);

    default public BiConstraintStream<A, B> complement(Class<A> otherClass) {
        return this.complement(otherClass, ConstantLambdaUtils.uniConstantNull());
    }

    default public BiConstraintStream<A, B> complement(Class<A> otherClass, Function<A, B> paddingFunction) {
        BiConstraintStream firstStream = this;
        UniConstraintStream remapped = firstStream.map(ConstantLambdaUtils.biPickFirst());
        UniConstraintStream<A> secondStream = this.getConstraintFactory().forEach(otherClass).ifNotExists(remapped, Joiners.equal());
        return firstStream.concat(secondStream, paddingFunction);
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner) {
        return this.ifExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2) {
        return this.ifExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3) {
        return this.ifExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3, TriJoiner<A, B, C> joiner4) {
        return this.ifExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> ... joiners) {
        return this.ifExistsIncludingUnassigned(otherClass, joiners);
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifNotExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifNotExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifNotExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifNotExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3, TriJoiner<A, B, C> joiner4) {
        return this.ifNotExistsIncludingUnassigned(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    @Deprecated(forRemoval=true, since="1.8.0")
    default public <C> BiConstraintStream<A, B> ifNotExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> ... joiners) {
        return this.ifNotExistsIncludingUnassigned(otherClass, joiners);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalize(String constraintName, Score<?> constraintWeight, ToIntBiFunction<A, B> matchWeigher) {
        return this.penalize(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalize(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntBiFunction<A, B> matchWeigher) {
        return this.penalize(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeLong(String constraintName, Score<?> constraintWeight, ToLongBiFunction<A, B> matchWeigher) {
        return this.penalizeLong(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongBiFunction<A, B> matchWeigher) {
        return this.penalizeLong(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeBigDecimal(String constraintName, Score<?> constraintWeight, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.penalizeBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.penalizeBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurable(String constraintName, ToIntBiFunction<A, B> matchWeigher) {
        return this.penalizeConfigurable(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurable(String constraintPackage, String constraintName, ToIntBiFunction<A, B> matchWeigher) {
        return this.penalizeConfigurable(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurableLong(String constraintName, ToLongBiFunction<A, B> matchWeigher) {
        return this.penalizeConfigurableLong(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurableLong(String constraintPackage, String constraintName, ToLongBiFunction<A, B> matchWeigher) {
        return this.penalizeConfigurableLong(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurableBigDecimal(String constraintName, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.penalizeConfigurableBigDecimal(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurableBigDecimal(String constraintPackage, String constraintName, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.penalizeConfigurableBigDecimal(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint reward(String constraintName, Score<?> constraintWeight, ToIntBiFunction<A, B> matchWeigher) {
        return this.reward(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint reward(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntBiFunction<A, B> matchWeigher) {
        return this.reward(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardLong(String constraintName, Score<?> constraintWeight, ToLongBiFunction<A, B> matchWeigher) {
        return this.rewardLong(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongBiFunction<A, B> matchWeigher) {
        return this.rewardLong(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardBigDecimal(String constraintName, Score<?> constraintWeight, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.rewardBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.rewardBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurable(String constraintName, ToIntBiFunction<A, B> matchWeigher) {
        return this.rewardConfigurable(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated
    default public Constraint rewardConfigurable(String constraintPackage, String constraintName, ToIntBiFunction<A, B> matchWeigher) {
        return this.rewardConfigurable(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurableLong(String constraintName, ToLongBiFunction<A, B> matchWeigher) {
        return this.rewardConfigurableLong(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurableLong(String constraintPackage, String constraintName, ToLongBiFunction<A, B> matchWeigher) {
        return this.rewardConfigurableLong(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurableBigDecimal(String constraintName, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.rewardConfigurableBigDecimal(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurableBigDecimal(String constraintPackage, String constraintName, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.rewardConfigurableBigDecimal(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impact(String constraintName, Score<?> constraintWeight, ToIntBiFunction<A, B> matchWeigher) {
        return this.impact(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impact(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntBiFunction<A, B> matchWeigher) {
        return this.impact(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactLong(String constraintName, Score<?> constraintWeight, ToLongBiFunction<A, B> matchWeigher) {
        return this.impactLong(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongBiFunction<A, B> matchWeigher) {
        return this.impactLong(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactBigDecimal(String constraintName, Score<?> constraintWeight, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.impactBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.impactBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurable(String constraintName, ToIntBiFunction<A, B> matchWeigher) {
        return this.impactConfigurable(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurable(String constraintPackage, String constraintName, ToIntBiFunction<A, B> matchWeigher) {
        return this.impactConfigurable(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurableLong(String constraintName, ToLongBiFunction<A, B> matchWeigher) {
        return this.impactConfigurableLong(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurableLong(String constraintPackage, String constraintName, ToLongBiFunction<A, B> matchWeigher) {
        return this.impactConfigurableLong(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurableBigDecimal(String constraintName, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.impactConfigurableBigDecimal(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurableBigDecimal(String constraintPackage, String constraintName, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.impactConfigurableBigDecimal(matchWeigher).asConstraint(constraintPackage, constraintName);
    }
}

