/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.solver;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public record ProblemSizeStatistics(long entityCount, long variableCount, long approximateValueCount, double approximateProblemSizeLog) {
    private static final Locale FORMATTER_LOCALE = Locale.getDefault();
    private static final DecimalFormat BASIC_FORMATTER = new DecimalFormat("#,###");
    private static final DecimalFormat EXPONENT_FORMATTER = new DecimalFormat("#");
    private static final DecimalFormat SIGNIFICANT_FIGURE_FORMATTER = new DecimalFormat("0.######");

    public long approximateProblemScaleLogAsFixedPointLong() {
        return Math.round(this.approximateProblemSizeLog * 1000000.0);
    }

    public String approximateProblemScaleAsFormattedString() {
        return this.approximateProblemScaleAsFormattedString(Locale.getDefault());
    }

    String approximateProblemScaleAsFormattedString(Locale locale) {
        if (Double.isNaN(this.approximateProblemSizeLog) || Double.isInfinite(this.approximateProblemSizeLog)) {
            return "0";
        }
        if (this.approximateProblemSizeLog < 10.0) {
            return "%s".formatted(ProblemSizeStatistics.format(Math.pow(10.0, this.approximateProblemSizeLog), BASIC_FORMATTER, locale));
        }
        double exponentPart = Math.floor(this.approximateProblemSizeLog);
        double remainderPartAsExponent = this.approximateProblemSizeLog - exponentPart;
        double remainderPart = Math.pow(10.0, remainderPartAsExponent);
        return "%s \u00d7 10^%s".formatted(ProblemSizeStatistics.format(remainderPart, SIGNIFICANT_FIGURE_FORMATTER, locale), ProblemSizeStatistics.format(exponentPart, EXPONENT_FORMATTER, locale));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String format(double number, DecimalFormat decimalFormat, Locale locale) {
        if (locale.equals(FORMATTER_LOCALE)) {
            return decimalFormat.format(number);
        }
        try {
            decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(locale));
            String string = decimalFormat.format(number);
            return string;
        }
        finally {
            decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(FORMATTER_LOCALE));
        }
    }
}

