/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.solver;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.ScoreExplanation;
import ai.timefold.solver.core.api.score.analysis.ScoreAnalysis;
import ai.timefold.solver.core.api.solver.RecommendedFit;
import ai.timefold.solver.core.api.solver.ScoreAnalysisFetchPolicy;
import ai.timefold.solver.core.api.solver.SolutionUpdatePolicy;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.api.solver.SolverManager;
import ai.timefold.solver.core.impl.solver.DefaultSolutionManager;
import java.util.List;
import java.util.function.Function;

public interface SolutionManager<Solution_, Score_ extends Score<Score_>> {
    public static <Solution_, Score_ extends Score<Score_>> SolutionManager<Solution_, Score_> create(SolverFactory<Solution_> solverFactory) {
        return new DefaultSolutionManager(solverFactory);
    }

    public static <Solution_, Score_ extends Score<Score_>, ProblemId_> SolutionManager<Solution_, Score_> create(SolverManager<Solution_, ProblemId_> solverManager) {
        return new DefaultSolutionManager(solverManager);
    }

    default public Score_ update(Solution_ solution) {
        return this.update(solution, SolutionUpdatePolicy.UPDATE_ALL);
    }

    public Score_ update(Solution_ var1, SolutionUpdatePolicy var2);

    default public ScoreExplanation<Solution_, Score_> explain(Solution_ solution) {
        return this.explain(solution, SolutionUpdatePolicy.UPDATE_ALL);
    }

    public ScoreExplanation<Solution_, Score_> explain(Solution_ var1, SolutionUpdatePolicy var2);

    default public ScoreAnalysis<Score_> analyze(Solution_ solution) {
        return this.analyze(solution, ScoreAnalysisFetchPolicy.FETCH_ALL, SolutionUpdatePolicy.UPDATE_ALL);
    }

    default public ScoreAnalysis<Score_> analyze(Solution_ solution, ScoreAnalysisFetchPolicy fetchPolicy) {
        return this.analyze(solution, fetchPolicy, SolutionUpdatePolicy.UPDATE_ALL);
    }

    public ScoreAnalysis<Score_> analyze(Solution_ var1, ScoreAnalysisFetchPolicy var2, SolutionUpdatePolicy var3);

    default public <EntityOrElement_, Proposition_> List<RecommendedFit<Proposition_, Score_>> recommendFit(Solution_ solution, EntityOrElement_ fittedEntityOrElement, Function<EntityOrElement_, Proposition_> propositionFunction) {
        return this.recommendFit(solution, fittedEntityOrElement, propositionFunction, ScoreAnalysisFetchPolicy.FETCH_ALL);
    }

    public <EntityOrElement_, Proposition_> List<RecommendedFit<Proposition_, Score_>> recommendFit(Solution_ var1, EntityOrElement_ var2, Function<EntityOrElement_, Proposition_> var3, ScoreAnalysisFetchPolicy var4);
}

