/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.solver;

import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.api.solver.SolverJob;
import ai.timefold.solver.core.api.solver.SolverJobBuilder;
import ai.timefold.solver.core.api.solver.SolverStatus;
import ai.timefold.solver.core.api.solver.change.ProblemChange;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.config.solver.SolverManagerConfig;
import ai.timefold.solver.core.impl.solver.DefaultSolverManager;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public interface SolverManager<Solution_, ProblemId_>
extends AutoCloseable {
    public static <Solution_, ProblemId_> SolverManager<Solution_, ProblemId_> create(SolverConfig solverConfig) {
        return SolverManager.create(solverConfig, new SolverManagerConfig());
    }

    public static <Solution_, ProblemId_> SolverManager<Solution_, ProblemId_> create(SolverConfig solverConfig, SolverManagerConfig solverManagerConfig) {
        return SolverManager.create(SolverFactory.create(solverConfig), solverManagerConfig);
    }

    public static <Solution_, ProblemId_> SolverManager<Solution_, ProblemId_> create(SolverFactory<Solution_> solverFactory) {
        return SolverManager.create(solverFactory, new SolverManagerConfig());
    }

    public static <Solution_, ProblemId_> SolverManager<Solution_, ProblemId_> create(SolverFactory<Solution_> solverFactory, SolverManagerConfig solverManagerConfig) {
        return new DefaultSolverManager(solverFactory, solverManagerConfig);
    }

    public SolverJobBuilder<Solution_, ProblemId_> solveBuilder();

    default public SolverJob<Solution_, ProblemId_> solve(ProblemId_ problemId, Solution_ problem) {
        return this.solveBuilder().withProblemId(problemId).withProblem(problem).run();
    }

    default public SolverJob<Solution_, ProblemId_> solve(ProblemId_ problemId, Solution_ problem, Consumer<? super Solution_> finalBestSolutionConsumer) {
        SolverJobBuilder<? super Solution_, ProblemId_> builder = this.solveBuilder().withProblemId(problemId).withProblem(problem);
        if (finalBestSolutionConsumer != null) {
            builder.withFinalBestSolutionConsumer(finalBestSolutionConsumer);
        }
        return builder.run();
    }

    @Deprecated(forRemoval=true, since="1.6.0")
    default public SolverJob<Solution_, ProblemId_> solve(ProblemId_ problemId, Solution_ problem, Consumer<? super Solution_> finalBestSolutionConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        SolverJobBuilder<? super Solution_, ? super ProblemId_> builder = this.solveBuilder().withProblemId(problemId).withProblem(problem);
        if (finalBestSolutionConsumer != null) {
            builder.withFinalBestSolutionConsumer(finalBestSolutionConsumer);
        }
        if (exceptionHandler != null) {
            builder.withExceptionHandler(exceptionHandler);
        }
        return builder.run();
    }

    @Deprecated(forRemoval=true, since="1.6.0")
    default public SolverJob<Solution_, ProblemId_> solve(ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> finalBestSolutionConsumer) {
        SolverJobBuilder<? super Solution_, ProblemId_> builder = this.solveBuilder().withProblemId(problemId).withProblemFinder(problemFinder);
        if (finalBestSolutionConsumer != null) {
            builder.withFinalBestSolutionConsumer(finalBestSolutionConsumer);
        }
        return builder.run();
    }

    @Deprecated(forRemoval=true, since="1.6.0")
    default public SolverJob<Solution_, ProblemId_> solve(ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> finalBestSolutionConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        SolverJobBuilder<? super Solution_, ? super ProblemId_> builder = this.solveBuilder().withProblemId(problemId).withProblemFinder(problemFinder);
        if (finalBestSolutionConsumer != null) {
            builder.withFinalBestSolutionConsumer(finalBestSolutionConsumer);
        }
        if (exceptionHandler != null) {
            builder.withExceptionHandler(exceptionHandler);
        }
        return builder.run();
    }

    @Deprecated(forRemoval=true, since="1.6.0")
    default public SolverJob<Solution_, ProblemId_> solveAndListen(ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> bestSolutionConsumer) {
        SolverJobBuilder<? super Solution_, ProblemId_> builder = this.solveBuilder().withProblemId(problemId).withProblemFinder(problemFinder);
        if (bestSolutionConsumer != null) {
            builder.withBestSolutionConsumer(bestSolutionConsumer);
        }
        return builder.run();
    }

    default public SolverJob<Solution_, ProblemId_> solveAndListen(ProblemId_ problemId, Solution_ problem, Consumer<? super Solution_> bestSolutionConsumer) {
        return this.solveBuilder().withProblemId(problemId).withProblem(problem).withBestSolutionConsumer(bestSolutionConsumer).run();
    }

    @Deprecated(forRemoval=true, since="1.6.0")
    default public SolverJob<Solution_, ProblemId_> solveAndListen(ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> bestSolutionConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        SolverJobBuilder<Solution_, ? super ProblemId_> builder = this.solveBuilder().withProblemId(problemId).withProblemFinder(problemFinder).withBestSolutionConsumer(bestSolutionConsumer);
        if (exceptionHandler != null) {
            builder.withExceptionHandler(exceptionHandler);
        }
        return builder.run();
    }

    @Deprecated(forRemoval=true, since="1.6.0")
    default public SolverJob<Solution_, ProblemId_> solveAndListen(ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> bestSolutionConsumer, Consumer<? super Solution_> finalBestSolutionConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        SolverJobBuilder<? super Solution_, ? super ProblemId_> builder = this.solveBuilder().withProblemId(problemId).withProblemFinder(problemFinder).withBestSolutionConsumer(bestSolutionConsumer);
        if (finalBestSolutionConsumer != null) {
            builder.withFinalBestSolutionConsumer(finalBestSolutionConsumer);
        }
        if (exceptionHandler != null) {
            builder.withExceptionHandler(exceptionHandler);
        }
        return builder.run();
    }

    public SolverStatus getSolverStatus(ProblemId_ var1);

    public CompletableFuture<Void> addProblemChange(ProblemId_ var1, ProblemChange<Solution_> var2);

    public void terminateEarly(ProblemId_ var1);

    @Override
    public void close();
}

