/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.heuristic.selector.list;

import ai.timefold.solver.core.config.heuristic.selector.SelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.function.Consumer;

@XmlType(propOrder={"id", "mimicSelectorRef", "valueSelectorConfig", "nearbySelectionConfig", "minimumSubListSize", "maximumSubListSize"})
public class SubListSelectorConfig
extends SelectorConfig<SubListSelectorConfig> {
    @XmlAttribute
    private String id = null;
    @XmlAttribute
    private String mimicSelectorRef = null;
    @XmlElement(name="valueSelector")
    private ValueSelectorConfig valueSelectorConfig = null;
    @XmlElement(name="nearbySelection")
    private NearbySelectionConfig nearbySelectionConfig = null;
    private Integer minimumSubListSize = null;
    private Integer maximumSubListSize = null;

    public SubListSelectorConfig() {
    }

    public SubListSelectorConfig(SubListSelectorConfig inheritedConfig) {
        if (inheritedConfig != null) {
            this.inherit(inheritedConfig);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMimicSelectorRef() {
        return this.mimicSelectorRef;
    }

    public void setMimicSelectorRef(String mimicSelectorRef) {
        this.mimicSelectorRef = mimicSelectorRef;
    }

    public ValueSelectorConfig getValueSelectorConfig() {
        return this.valueSelectorConfig;
    }

    public void setValueSelectorConfig(ValueSelectorConfig valueSelectorConfig) {
        this.valueSelectorConfig = valueSelectorConfig;
    }

    public NearbySelectionConfig getNearbySelectionConfig() {
        return this.nearbySelectionConfig;
    }

    public void setNearbySelectionConfig(NearbySelectionConfig nearbySelectionConfig) {
        this.nearbySelectionConfig = nearbySelectionConfig;
    }

    public Integer getMinimumSubListSize() {
        return this.minimumSubListSize;
    }

    public void setMinimumSubListSize(Integer minimumSubListSize) {
        this.minimumSubListSize = minimumSubListSize;
    }

    public Integer getMaximumSubListSize() {
        return this.maximumSubListSize;
    }

    public void setMaximumSubListSize(Integer maximumSubListSize) {
        this.maximumSubListSize = maximumSubListSize;
    }

    public SubListSelectorConfig withId(String id) {
        this.setId(id);
        return this;
    }

    public SubListSelectorConfig withMimicSelectorRef(String mimicSelectorRef) {
        this.setMimicSelectorRef(mimicSelectorRef);
        return this;
    }

    public SubListSelectorConfig withValueSelectorConfig(ValueSelectorConfig valueSelectorConfig) {
        this.setValueSelectorConfig(valueSelectorConfig);
        return this;
    }

    public SubListSelectorConfig withNearbySelectionConfig(NearbySelectionConfig nearbySelectionConfig) {
        this.setNearbySelectionConfig(nearbySelectionConfig);
        return this;
    }

    public SubListSelectorConfig withMinimumSubListSize(Integer minimumSubListSize) {
        this.setMinimumSubListSize(minimumSubListSize);
        return this;
    }

    public SubListSelectorConfig withMaximumSubListSize(Integer maximumSubListSize) {
        this.setMaximumSubListSize(maximumSubListSize);
        return this;
    }

    @Override
    public SubListSelectorConfig inherit(SubListSelectorConfig inheritedConfig) {
        this.id = ConfigUtils.inheritOverwritableProperty(this.id, inheritedConfig.id);
        this.mimicSelectorRef = ConfigUtils.inheritOverwritableProperty(this.mimicSelectorRef, inheritedConfig.mimicSelectorRef);
        this.valueSelectorConfig = ConfigUtils.inheritConfig(this.valueSelectorConfig, inheritedConfig.valueSelectorConfig);
        this.nearbySelectionConfig = ConfigUtils.inheritConfig(this.nearbySelectionConfig, inheritedConfig.nearbySelectionConfig);
        this.minimumSubListSize = ConfigUtils.inheritOverwritableProperty(this.minimumSubListSize, inheritedConfig.minimumSubListSize);
        this.maximumSubListSize = ConfigUtils.inheritOverwritableProperty(this.maximumSubListSize, inheritedConfig.maximumSubListSize);
        return this;
    }

    @Override
    public SubListSelectorConfig copyConfig() {
        return new SubListSelectorConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(Consumer<Class<?>> classVisitor) {
        if (this.valueSelectorConfig != null) {
            this.valueSelectorConfig.visitReferencedClasses(classVisitor);
        }
        if (this.nearbySelectionConfig != null) {
            this.nearbySelectionConfig.visitReferencedClasses(classVisitor);
        }
    }

    @Override
    public boolean hasNearbySelectionConfig() {
        return this.nearbySelectionConfig != null || this.valueSelectorConfig != null && this.valueSelectorConfig.hasNearbySelectionConfig();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.valueSelectorConfig + ")";
    }
}

