/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.phase.custom;

import ai.timefold.solver.core.config.phase.PhaseConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.io.jaxb.adapter.JaxbCustomPropertiesAdapter;
import ai.timefold.solver.core.impl.phase.custom.CustomPhaseCommand;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

@XmlType(propOrder={"customPhaseCommandClassList", "customProperties"})
public class CustomPhaseConfig
extends PhaseConfig<CustomPhaseConfig> {
    public static final String XML_ELEMENT_NAME = "customPhase";
    @XmlElement(name="customPhaseCommandClass")
    protected List<Class<? extends CustomPhaseCommand>> customPhaseCommandClassList = null;
    @XmlJavaTypeAdapter(value=JaxbCustomPropertiesAdapter.class)
    protected Map<String, String> customProperties = null;
    @XmlTransient
    protected List<CustomPhaseCommand> customPhaseCommandList = null;

    public List<Class<? extends CustomPhaseCommand>> getCustomPhaseCommandClassList() {
        return this.customPhaseCommandClassList;
    }

    public void setCustomPhaseCommandClassList(List<Class<? extends CustomPhaseCommand>> customPhaseCommandClassList) {
        this.customPhaseCommandClassList = customPhaseCommandClassList;
    }

    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
    }

    public List<CustomPhaseCommand> getCustomPhaseCommandList() {
        return this.customPhaseCommandList;
    }

    public void setCustomPhaseCommandList(List<CustomPhaseCommand> customPhaseCommandList) {
        this.customPhaseCommandList = customPhaseCommandList;
    }

    public CustomPhaseConfig withCustomPhaseCommandClassList(List<Class<? extends CustomPhaseCommand>> customPhaseCommandClassList) {
        this.customPhaseCommandClassList = customPhaseCommandClassList;
        return this;
    }

    public CustomPhaseConfig withCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
        return this;
    }

    public CustomPhaseConfig withCustomPhaseCommandList(List<CustomPhaseCommand> customPhaseCommandList) {
        boolean hasNullCommand = Objects.requireNonNullElse(customPhaseCommandList, Collections.emptyList()).stream().anyMatch(Objects::isNull);
        if (hasNullCommand) {
            throw new IllegalArgumentException("Custom phase commands (" + customPhaseCommandList + ") must not contain a null element.");
        }
        this.customPhaseCommandList = customPhaseCommandList;
        return this;
    }

    public <Solution_> CustomPhaseConfig withCustomPhaseCommands(CustomPhaseCommand<Solution_> ... customPhaseCommands) {
        boolean hasNullCommand = Arrays.stream(customPhaseCommands).anyMatch(Objects::isNull);
        if (hasNullCommand) {
            throw new IllegalArgumentException("Custom phase commands (" + Arrays.toString(customPhaseCommands) + ") must not contain a null element.");
        }
        this.customPhaseCommandList = Arrays.asList(customPhaseCommands);
        return this;
    }

    @Override
    public CustomPhaseConfig inherit(CustomPhaseConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.customPhaseCommandClassList = ConfigUtils.inheritMergeableListProperty(this.customPhaseCommandClassList, inheritedConfig.getCustomPhaseCommandClassList());
        this.customPhaseCommandList = ConfigUtils.inheritMergeableListProperty(this.customPhaseCommandList, inheritedConfig.getCustomPhaseCommandList());
        this.customProperties = ConfigUtils.inheritMergeableMapProperty(this.customProperties, inheritedConfig.getCustomProperties());
        return this;
    }

    @Override
    public CustomPhaseConfig copyConfig() {
        return new CustomPhaseConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(Consumer<Class<?>> classVisitor) {
        if (this.getTerminationConfig() != null) {
            this.getTerminationConfig().visitReferencedClasses(classVisitor);
        }
        if (this.customPhaseCommandClassList != null) {
            this.customPhaseCommandClassList.forEach(classVisitor);
        }
    }
}

