/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.lookup;

import ai.timefold.solver.core.api.domain.common.DomainAccessType;
import ai.timefold.solver.core.api.domain.lookup.LookUpStrategyType;
import ai.timefold.solver.core.api.domain.lookup.PlanningId;
import ai.timefold.solver.core.api.domain.solution.PlanningSolution;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import ai.timefold.solver.core.impl.domain.lookup.EqualsLookUpStrategy;
import ai.timefold.solver.core.impl.domain.lookup.ImmutableLookUpStrategy;
import ai.timefold.solver.core.impl.domain.lookup.LookUpStrategy;
import ai.timefold.solver.core.impl.domain.lookup.NoneLookUpStrategy;
import ai.timefold.solver.core.impl.domain.lookup.PlanningIdLookUpStrategy;
import ai.timefold.solver.core.impl.domain.policy.DescriptorPolicy;
import ai.timefold.solver.core.impl.domain.solution.cloner.DeepCloningUtils;
import ai.timefold.solver.core.impl.util.ConcurrentMemoization;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentMap;

public final class LookUpStrategyResolver {
    private final LookUpStrategyType lookUpStrategyType;
    private final DomainAccessType domainAccessType;
    private final MemberAccessorFactory memberAccessorFactory;
    private final ConcurrentMap<Class<?>, LookUpStrategy> decisionCache = new ConcurrentMemoization();

    public LookUpStrategyResolver(DescriptorPolicy descriptorPolicy, LookUpStrategyType lookUpStrategyType) {
        this.lookUpStrategyType = lookUpStrategyType;
        this.domainAccessType = descriptorPolicy.getDomainAccessType();
        this.memberAccessorFactory = descriptorPolicy.getMemberAccessorFactory();
    }

    public LookUpStrategy determineLookUpStrategy(Object object) {
        return this.decisionCache.computeIfAbsent(object.getClass(), objectClass -> {
            if (DeepCloningUtils.isImmutable(objectClass)) {
                return new ImmutableLookUpStrategy();
            }
            return switch (this.lookUpStrategyType) {
                default -> throw new IncompatibleClassChangeError();
                case LookUpStrategyType.PLANNING_ID_OR_NONE -> {
                    MemberAccessor memberAccessor = ConfigUtils.findPlanningIdMemberAccessor(objectClass, this.memberAccessorFactory, this.domainAccessType);
                    if (memberAccessor == null) {
                        NoneLookUpStrategy var2_5;
                        yield var2_5 = new NoneLookUpStrategy();
                    }
                    PlanningIdLookUpStrategy var2_6 = new PlanningIdLookUpStrategy(memberAccessor);
                    yield var2_6;
                }
                case LookUpStrategyType.PLANNING_ID_OR_FAIL_FAST -> {
                    MemberAccessor memberAccessor = ConfigUtils.findPlanningIdMemberAccessor(objectClass, this.memberAccessorFactory, this.domainAccessType);
                    if (memberAccessor == null) {
                        throw new IllegalArgumentException("The class (" + objectClass + ") does not have a @" + PlanningId.class.getSimpleName() + " annotation, but the lookUpStrategyType (" + this.lookUpStrategyType + ") requires it.\nMaybe add the @" + PlanningId.class.getSimpleName() + " annotation or change the @" + PlanningSolution.class.getSimpleName() + " annotation's " + LookUpStrategyType.class.getSimpleName() + ".");
                    }
                    PlanningIdLookUpStrategy var2_7 = new PlanningIdLookUpStrategy(memberAccessor);
                    yield var2_7;
                }
                case LookUpStrategyType.EQUALITY -> {
                    Method hashCodeMethod;
                    Method equalsMethod;
                    try {
                        equalsMethod = objectClass.getMethod("equals", Object.class);
                        hashCodeMethod = objectClass.getMethod("hashCode", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        throw new IllegalStateException("Impossible state because equals() and hashCode() always exist.", e);
                    }
                    if (equalsMethod.getDeclaringClass().equals(Object.class)) {
                        throw new IllegalArgumentException("The class (" + objectClass.getSimpleName() + ") doesn't override the equals() method, neither does any superclass.");
                    }
                    if (hashCodeMethod.getDeclaringClass().equals(Object.class)) {
                        throw new IllegalArgumentException("The class (" + objectClass.getSimpleName() + ") overrides equals() but neither it nor any superclass overrides the hashCode() method.");
                    }
                    EqualsLookUpStrategy var2_8 = new EqualsLookUpStrategy();
                    yield var2_8;
                }
                case LookUpStrategyType.NONE -> {
                    NoneLookUpStrategy var2_9;
                    yield var2_9 = new NoneLookUpStrategy();
                }
            };
        });
    }
}

