/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.policy;

import ai.timefold.solver.core.api.domain.common.DomainAccessType;
import ai.timefold.solver.core.api.domain.solution.cloner.SolutionCloner;
import ai.timefold.solver.core.api.domain.valuerange.ValueRangeProvider;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DescriptorPolicy {
    private Map<String, SolutionCloner> generatedSolutionClonerMap = new LinkedHashMap<String, SolutionCloner>();
    private final Map<String, MemberAccessor> fromSolutionValueRangeProviderMap = new LinkedHashMap<String, MemberAccessor>();
    private final Set<MemberAccessor> anonymousFromSolutionValueRangeProviderSet = new LinkedHashSet<MemberAccessor>();
    private final Map<String, MemberAccessor> fromEntityValueRangeProviderMap = new LinkedHashMap<String, MemberAccessor>();
    private final Set<MemberAccessor> anonymousFromEntityValueRangeProviderSet = new LinkedHashSet<MemberAccessor>();
    private DomainAccessType domainAccessType = DomainAccessType.REFLECTION;
    private MemberAccessorFactory memberAccessorFactory;

    public void addFromSolutionValueRangeProvider(MemberAccessor memberAccessor) {
        String id = this.extractValueRangeProviderId(memberAccessor);
        if (id == null) {
            this.anonymousFromSolutionValueRangeProviderSet.add(memberAccessor);
        } else {
            this.fromSolutionValueRangeProviderMap.put(id, memberAccessor);
        }
    }

    public boolean isFromSolutionValueRangeProvider(MemberAccessor memberAccessor) {
        return this.fromSolutionValueRangeProviderMap.containsValue(memberAccessor) || this.anonymousFromSolutionValueRangeProviderSet.contains(memberAccessor);
    }

    public boolean hasFromSolutionValueRangeProvider(String id) {
        return this.fromSolutionValueRangeProviderMap.containsKey(id);
    }

    public MemberAccessor getFromSolutionValueRangeProvider(String id) {
        return this.fromSolutionValueRangeProviderMap.get(id);
    }

    public Set<MemberAccessor> getAnonymousFromSolutionValueRangeProviderSet() {
        return this.anonymousFromSolutionValueRangeProviderSet;
    }

    public void addFromEntityValueRangeProvider(MemberAccessor memberAccessor) {
        String id = this.extractValueRangeProviderId(memberAccessor);
        if (id == null) {
            this.anonymousFromEntityValueRangeProviderSet.add(memberAccessor);
        } else {
            this.fromEntityValueRangeProviderMap.put(id, memberAccessor);
        }
    }

    public boolean isFromEntityValueRangeProvider(MemberAccessor memberAccessor) {
        return this.fromEntityValueRangeProviderMap.containsValue(memberAccessor) || this.anonymousFromEntityValueRangeProviderSet.contains(memberAccessor);
    }

    public boolean hasFromEntityValueRangeProvider(String id) {
        return this.fromEntityValueRangeProviderMap.containsKey(id);
    }

    public Set<MemberAccessor> getAnonymousFromEntityValueRangeProviderSet() {
        return this.anonymousFromEntityValueRangeProviderSet;
    }

    public DomainAccessType getDomainAccessType() {
        return this.domainAccessType;
    }

    public void setDomainAccessType(DomainAccessType domainAccessType) {
        this.domainAccessType = domainAccessType;
    }

    public Map<String, SolutionCloner> getGeneratedSolutionClonerMap() {
        return this.generatedSolutionClonerMap;
    }

    public void setGeneratedSolutionClonerMap(Map<String, SolutionCloner> generatedSolutionClonerMap) {
        this.generatedSolutionClonerMap = generatedSolutionClonerMap;
    }

    public MemberAccessorFactory getMemberAccessorFactory() {
        return this.memberAccessorFactory;
    }

    public void setMemberAccessorFactory(MemberAccessorFactory memberAccessorFactory) {
        this.memberAccessorFactory = memberAccessorFactory;
    }

    public MemberAccessor getFromEntityValueRangeProvider(String id) {
        return this.fromEntityValueRangeProviderMap.get(id);
    }

    private String extractValueRangeProviderId(MemberAccessor memberAccessor) {
        ValueRangeProvider annotation = memberAccessor.getAnnotation(ValueRangeProvider.class);
        String id = annotation.id();
        if (id == null || id.isEmpty()) {
            return null;
        }
        this.validateUniqueValueRangeProviderId(id, memberAccessor);
        return id;
    }

    private void validateUniqueValueRangeProviderId(String id, MemberAccessor memberAccessor) {
        MemberAccessor duplicate = this.fromSolutionValueRangeProviderMap.get(id);
        if (duplicate != null) {
            throw new IllegalStateException("2 members (" + duplicate + ", " + memberAccessor + ") with a @" + ValueRangeProvider.class.getSimpleName() + " annotation must not have the same id (" + id + ").");
        }
        duplicate = this.fromEntityValueRangeProviderMap.get(id);
        if (duplicate != null) {
            throw new IllegalStateException("2 members (" + duplicate + ", " + memberAccessor + ") with a @" + ValueRangeProvider.class.getSimpleName() + " annotation must not have the same id (" + id + ").");
        }
    }

    public Collection<String> getValueRangeProviderIds() {
        ArrayList<String> valueRangeProviderIds = new ArrayList<String>(this.fromSolutionValueRangeProviderMap.size() + this.fromEntityValueRangeProviderMap.size());
        valueRangeProviderIds.addAll(this.fromSolutionValueRangeProviderMap.keySet());
        valueRangeProviderIds.addAll(this.fromEntityValueRangeProviderMap.keySet());
        return valueRangeProviderIds;
    }
}

