/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution;

import ai.timefold.solver.core.api.domain.common.DomainAccessType;
import ai.timefold.solver.core.api.score.IBendableScore;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import ai.timefold.solver.core.impl.domain.score.descriptor.ScoreDescriptor;
import ai.timefold.solver.core.impl.domain.solution.ConstraintConfigurationDescriptor;
import ai.timefold.solver.core.impl.domain.solution.ConstraintWeightDescriptor;
import ai.timefold.solver.core.impl.domain.solution.ConstraintWeightSupplier;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.score.definition.AbstractBendableScoreDefinition;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@Deprecated(forRemoval=true, since="1.13.0")
public final class ConstraintConfigurationBasedConstraintWeightSupplier<Score_ extends Score<Score_>, Solution_>
implements ConstraintWeightSupplier<Solution_, Score_> {
    private final ConstraintConfigurationDescriptor<Solution_> constraintConfigurationDescriptor;
    private final Map<ConstraintRef, Function<Solution_, Score_>> constraintWeightExtractorMap = new LinkedHashMap<ConstraintRef, Function<Solution_, Score_>>();

    public static <Solution_, Score_ extends Score<Score_>> ConstraintWeightSupplier<Solution_, Score_> create(SolutionDescriptor<Solution_> solutionDescriptor, Class<?> constraintConfigurationClass) {
        ConstraintConfigurationDescriptor<Solution_> configDescriptor = new ConstraintConfigurationDescriptor<Solution_>(Objects.requireNonNull(solutionDescriptor), Objects.requireNonNull(constraintConfigurationClass));
        return new ConstraintConfigurationBasedConstraintWeightSupplier<Score_, Solution_>(configDescriptor);
    }

    private ConstraintConfigurationBasedConstraintWeightSupplier(ConstraintConfigurationDescriptor<Solution_> constraintConfigurationDescriptor) {
        this.constraintConfigurationDescriptor = Objects.requireNonNull(constraintConfigurationDescriptor);
    }

    @Override
    public void initialize(SolutionDescriptor<Solution_> solutionDescriptor, MemberAccessorFactory memberAccessorFactory, DomainAccessType domainAccessType) {
        ScoreDescriptor scoreDescriptor = solutionDescriptor.getScoreDescriptor();
        this.constraintConfigurationDescriptor.processAnnotations(memberAccessorFactory, domainAccessType, scoreDescriptor.getScoreDefinition());
        this.constraintConfigurationDescriptor.getSupportedConstraints().forEach(constraintRef -> {
            ConstraintWeightDescriptor<Solution_> descriptor = this.constraintConfigurationDescriptor.findConstraintWeightDescriptor((ConstraintRef)constraintRef);
            Function<Solution_, Score<?>> weightExtractor = descriptor.createExtractor(solutionDescriptor.getConstraintConfigurationMemberAccessor());
            this.constraintWeightExtractorMap.put((ConstraintRef)constraintRef, (Function<Solution_, Score_>)weightExtractor);
        });
    }

    @Override
    public void validate(Solution_ workingSolution, Set<ConstraintRef> userDefinedConstraints) {
        Set missingConstraints = userDefinedConstraints.stream().filter(constraintRef -> !this.constraintWeightExtractorMap.containsKey(constraintRef)).collect(Collectors.toSet());
        if (!missingConstraints.isEmpty()) {
            throw new IllegalStateException("The constraintConfigurationClass (%s) does not support the following constraints (%s).\nMaybe ensure your constraint configuration contains all constraints defined in your %s.".formatted(this.constraintConfigurationDescriptor.getConstraintConfigurationClass(), missingConstraints, ConstraintProvider.class.getSimpleName()));
        }
    }

    @Override
    public Class<?> getProblemFactClass() {
        return this.constraintConfigurationDescriptor.getConstraintConfigurationClass();
    }

    @Override
    public String getDefaultConstraintPackage() {
        return this.constraintConfigurationDescriptor.getConstraintPackage();
    }

    @Override
    public Score_ getConstraintWeight(ConstraintRef constraintRef, Solution_ workingSolution) {
        Function<Solution_, Score_> weightExtractor = this.constraintWeightExtractorMap.get(constraintRef);
        if (weightExtractor == null) {
            throw new IllegalStateException("Impossible state: Constraint (%s) not supported by constraint configuration class (%s).".formatted(constraintRef, this.constraintConfigurationDescriptor.getConstraintConfigurationClass()));
        }
        Score weight = (Score)weightExtractor.apply(workingSolution);
        this.validateConstraintWeight(constraintRef, weight);
        return (Score_)weight;
    }

    private void validateConstraintWeight(ConstraintRef constraintRef, Score_ constraintWeight) {
        if (constraintWeight == null) {
            throw new IllegalArgumentException("The constraintWeight for constraint (%s) must not be null.\nMaybe validate the data input of your constraintConfigurationClass (%s) for that constraint.".formatted(constraintRef, this.constraintConfigurationDescriptor.getConstraintConfigurationClass()));
        }
        ScoreDescriptor scoreDescriptor = this.constraintConfigurationDescriptor.getSolutionDescriptor().getScoreDescriptor();
        if (!scoreDescriptor.getScoreClass().isAssignableFrom(constraintWeight.getClass())) {
            throw new IllegalArgumentException("The constraintWeight (%s) of class (%s) for constraint (%s) must be of the scoreClass (%s).\nMaybe validate the data input of your constraintConfigurationClass (%s) for that constraint.".formatted(constraintWeight, constraintWeight.getClass(), constraintRef, scoreDescriptor.getScoreClass(), this.constraintConfigurationDescriptor.getConstraintConfigurationClass()));
        }
        if (constraintWeight.initScore() != 0) {
            throw new IllegalArgumentException("The constraintWeight (%s) for constraint (%s) must have an initScore (%d) equal to 0.\nMaybe validate the data input of your constraintConfigurationClass (%s) for that constraint.".formatted(constraintWeight, constraintRef, constraintWeight.initScore(), this.constraintConfigurationDescriptor.getConstraintConfigurationClass()));
        }
        if (!scoreDescriptor.getScoreDefinition().isPositiveOrZero(constraintWeight)) {
            throw new IllegalArgumentException("The constraintWeight (%s) for constraint (%s) must be positive or zero.\nMaybe validate the data input of your constraintConfigurationClass (%s).".formatted(constraintWeight, constraintRef, this.constraintConfigurationDescriptor.getConstraintConfigurationClass()));
        }
        if (constraintWeight instanceof IBendableScore) {
            IBendableScore bendableConstraintWeight = (IBendableScore)constraintWeight;
            AbstractBendableScoreDefinition bendableScoreDefinition = (AbstractBendableScoreDefinition)scoreDescriptor.getScoreDefinition();
            if (bendableConstraintWeight.hardLevelsSize() != bendableScoreDefinition.getHardLevelsSize() || bendableConstraintWeight.softLevelsSize() != bendableScoreDefinition.getSoftLevelsSize()) {
                throw new IllegalArgumentException("The bendable constraintWeight (%s) for constraint (%s) has a hardLevelsSize (%d) or a softLevelsSize (%d) that doesn't match the score definition's hardLevelsSize (%d) or softLevelsSize (%d).\nMaybe validate the data input of your constraintConfigurationClass (%s).".formatted(bendableConstraintWeight, constraintRef, bendableConstraintWeight.hardLevelsSize(), bendableConstraintWeight.softLevelsSize(), bendableScoreDefinition.getHardLevelsSize(), bendableScoreDefinition.getSoftLevelsSize(), this.constraintConfigurationDescriptor.getConstraintConfigurationClass()));
            }
        }
    }

    ConstraintConfigurationDescriptor<Solution_> getConstraintConfigurationDescriptor() {
        return this.constraintConfigurationDescriptor;
    }

    public String toString() {
        return "Constraint weights based on " + this.constraintConfigurationDescriptor.getConstraintConfigurationClass() + ".";
    }
}

