/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution;

import ai.timefold.solver.core.api.domain.common.DomainAccessType;
import ai.timefold.solver.core.api.domain.solution.ConstraintWeightOverrides;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.impl.domain.common.ReflectionHelper;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import ai.timefold.solver.core.impl.domain.policy.DescriptorPolicy;
import ai.timefold.solver.core.impl.domain.solution.ConstraintWeightSupplier;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraint;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class OverridesBasedConstraintWeightSupplier<Score_ extends Score<Score_>, Solution_>
implements ConstraintWeightSupplier<Solution_, Score_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final MemberAccessor overridesAccessor;
    private final Class<? extends ConstraintWeightOverrides<Score_>> overridesClass;

    public static <Solution_, Score_ extends Score<Score_>> ConstraintWeightSupplier<Solution_, Score_> create(SolutionDescriptor<Solution_> solutionDescriptor, DescriptorPolicy descriptorPolicy, Field field) {
        Class<?> overridesClass;
        AccessibleObject member;
        Method method = ReflectionHelper.getGetterMethod(field.getDeclaringClass(), field.getName());
        if (method == null) {
            member = field;
            overridesClass = field.getType();
        } else {
            member = method;
            overridesClass = method.getReturnType();
        }
        MemberAccessor memberAccessor = descriptorPolicy.getMemberAccessorFactory().buildAndCacheMemberAccessor((Member)((Object)member), MemberAccessorFactory.MemberAccessorType.FIELD_OR_GETTER_METHOD_WITH_SETTER, descriptorPolicy.getDomainAccessType());
        return new OverridesBasedConstraintWeightSupplier<Score_, Solution_>(solutionDescriptor, memberAccessor, overridesClass);
    }

    private OverridesBasedConstraintWeightSupplier(SolutionDescriptor<Solution_> solutionDescriptor, MemberAccessor overridesAccessor, Class<? extends ConstraintWeightOverrides<Score_>> overridesClass) {
        this.solutionDescriptor = Objects.requireNonNull(solutionDescriptor);
        this.overridesAccessor = Objects.requireNonNull(overridesAccessor);
        this.overridesClass = Objects.requireNonNull(overridesClass);
    }

    @Override
    public void initialize(SolutionDescriptor<Solution_> solutionDescriptor, MemberAccessorFactory memberAccessorFactory, DomainAccessType domainAccessType) {
    }

    @Override
    public void validate(Solution_ workingSolution, Set<ConstraintRef> userDefinedConstraints) {
        Set userDefinedConstraintNames = userDefinedConstraints.stream().map(ConstraintRef::constraintName).collect(Collectors.toSet());
        ConstraintWeightOverrides overrides = workingSolution == null ? ConstraintWeightOverrides.none() : Objects.requireNonNull(this.getConstraintWeights(workingSolution));
        Set<String> supportedConstraints = overrides.getKnownConstraintNames();
        Set excessiveConstraints = supportedConstraints.stream().filter(constraintName -> !userDefinedConstraintNames.contains(constraintName)).collect(Collectors.toSet());
        if (!excessiveConstraints.isEmpty()) {
            throw new IllegalStateException("The constraint weight overrides contain the following constraints (%s) that are not in the user-defined constraints (%s).\nMaybe check your %s for missing constraints.".formatted(excessiveConstraints, userDefinedConstraintNames, ConstraintProvider.class.getSimpleName()));
        }
    }

    private ConstraintWeightOverrides<Score_> getConstraintWeights(Solution_ workingSolution) {
        return (ConstraintWeightOverrides)this.overridesAccessor.executeGetter(workingSolution);
    }

    @Override
    public Class<?> getProblemFactClass() {
        return this.overridesClass;
    }

    @Override
    public String getDefaultConstraintPackage() {
        return this.solutionDescriptor.getSolutionClass().getPackageName();
    }

    @Override
    public Score_ getConstraintWeight(ConstraintRef constraintRef, Solution_ workingSolution) {
        if (!constraintRef.packageName().equals(this.getDefaultConstraintPackage())) {
            throw new IllegalStateException("The constraint (%s) is not in the default package (%s).\nConstraint packages are deprecated, check your constraint implementation.".formatted(constraintRef, this.getDefaultConstraintPackage()));
        }
        if (workingSolution == null) {
            return null;
        }
        Score_ weight = this.getConstraintWeights(workingSolution).getConstraintWeight(constraintRef.constraintName());
        if (weight == null) {
            return null;
        }
        AbstractConstraint.validateWeight(this.solutionDescriptor, constraintRef, weight);
        return weight;
    }

    public String toString() {
        return "Constraint weights based on " + this.overridesAccessor + ".";
    }
}

