/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution.descriptor;

import ai.timefold.solver.core.impl.util.MathUtils;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

public class ProblemScaleTracker {
    private final long logBase;
    private final Set<Object> visitedAnchorSet = Collections.newSetFromMap(new IdentityHashMap());
    private long basicProblemScaleLog = 0L;
    private int listPinnedValueCount = 0;
    private int listTotalEntityCount = 0;
    private int listMovableEntityCount = 0;
    private int listTotalValueCount = 0;

    public ProblemScaleTracker(long logBase) {
        this.logBase = logBase;
    }

    public long getBasicProblemScaleLog() {
        return this.basicProblemScaleLog;
    }

    public int getListPinnedValueCount() {
        return this.listPinnedValueCount;
    }

    public int getListTotalEntityCount() {
        return this.listTotalEntityCount;
    }

    public int getListMovableEntityCount() {
        return this.listMovableEntityCount;
    }

    public int getListTotalValueCount() {
        return this.listTotalValueCount;
    }

    public void setListTotalValueCount(int listTotalValueCount) {
        this.listTotalValueCount = listTotalValueCount;
    }

    public boolean isAnchorVisited(Object anchor) {
        if (this.visitedAnchorSet.contains(anchor)) {
            return true;
        }
        this.visitedAnchorSet.add(anchor);
        return false;
    }

    public void addListValueCount(int count) {
        this.listTotalValueCount += count;
    }

    public void addPinnedListValueCount(int count) {
        this.listPinnedValueCount += count;
    }

    public void incrementListEntityCount(boolean isMovable) {
        ++this.listTotalEntityCount;
        if (isMovable) {
            ++this.listMovableEntityCount;
        }
    }

    public void addBasicProblemScale(long count) {
        this.basicProblemScaleLog += MathUtils.getScaledApproximateLog(1000000L, this.logBase, count);
    }
}

