/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution.mutation;

import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import java.util.Iterator;
import java.util.List;

public class MutationCounter<Solution_> {
    protected final SolutionDescriptor<Solution_> solutionDescriptor;

    public MutationCounter(SolutionDescriptor<Solution_> solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
    }

    public int countMutations(Solution_ a, Solution_ b) {
        int mutationCount = 0;
        for (EntityDescriptor<Solution_> entityDescriptor : this.solutionDescriptor.getGenuineEntityDescriptors()) {
            List<Object> aEntities = entityDescriptor.extractEntities(a);
            List<Object> bEntities = entityDescriptor.extractEntities(b);
            Iterator<Object> aIt = aEntities.iterator();
            Iterator<Object> bIt = bEntities.iterator();
            while (aIt.hasNext() && bIt.hasNext()) {
                Object aEntity = aIt.next();
                Object bEntity = bIt.next();
                for (GenuineVariableDescriptor<Solution_> variableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
                    Object bValue;
                    if (variableDescriptor.isListVariable()) {
                        int bSize;
                        ListVariableDescriptor listVariableDescriptor = (ListVariableDescriptor)variableDescriptor;
                        Object aValues = listVariableDescriptor.getValue(aEntity);
                        Object bValues = listVariableDescriptor.getValue(bEntity);
                        int aSize = aValues.size();
                        if (aSize != (bSize = bValues.size())) {
                            mutationCount += Math.abs(aSize - bSize);
                        }
                        int shorterListSize = Math.min(aSize, bSize);
                        for (int i = 0; i < shorterListSize; ++i) {
                            Object bValue2;
                            Object aValue = aValues.get(i);
                            if (!this.areDifferent(aValue, bValue2 = bValues.get(i))) continue;
                            ++mutationCount;
                        }
                        continue;
                    }
                    Object aValue = variableDescriptor.getValue(aEntity);
                    if (!this.areDifferent(aValue, bValue = variableDescriptor.getValue(bEntity))) continue;
                    ++mutationCount;
                }
            }
            if (aEntities.size() == bEntities.size()) continue;
            mutationCount += Math.abs(aEntities.size() - bEntities.size()) * entityDescriptor.getGenuineVariableDescriptorList().size();
        }
        return mutationCount;
    }

    private boolean areDifferent(Object aValue, Object bValue) {
        EntityDescriptor<Solution_> aValueEntityDescriptor = this.solutionDescriptor.findEntityDescriptor(aValue.getClass());
        EntityDescriptor<Solution_> bValueEntityDescriptor = this.solutionDescriptor.findEntityDescriptor(bValue.getClass());
        if (aValueEntityDescriptor == null && bValueEntityDescriptor == null) {
            if (aValue == bValue) {
                return false;
            }
            return this.areDifferentPlanningIds(aValue, bValue);
        }
        if (aValueEntityDescriptor != null && bValueEntityDescriptor != null) {
            if (aValueEntityDescriptor != bValueEntityDescriptor) {
                return true;
            }
            return this.areDifferentPlanningIds(aValue, bValue);
        }
        return true;
    }

    private boolean areDifferentPlanningIds(Object aValue, Object bValue) {
        MemberAccessor aIdAccessor = this.solutionDescriptor.getPlanningIdAccessor(aValue.getClass());
        MemberAccessor bIdAccessor = this.solutionDescriptor.getPlanningIdAccessor(bValue.getClass());
        if (aIdAccessor != null && bIdAccessor != null) {
            Object bId;
            Object aId = aIdAccessor.executeGetter(aValue);
            return !aId.equals(bId = bIdAccessor.executeGetter(bValue));
        }
        return aValue != bValue;
    }

    public String toString() {
        return "MutationCounter(" + this.solutionDescriptor + ")";
    }
}

