/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.valuerange.buildin.primint;

import ai.timefold.solver.core.impl.domain.valuerange.AbstractCountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.util.ValueRangeIterator;
import ai.timefold.solver.core.impl.solver.random.RandomUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;

public final class IntValueRange
extends AbstractCountableValueRange<Integer> {
    private final int from;
    private final int to;
    private final int incrementUnit;

    public IntValueRange(int from, int to) {
        this(from, to, 1);
    }

    public IntValueRange(int from, int to, int incrementUnit) {
        this.from = from;
        this.to = to;
        this.incrementUnit = incrementUnit;
        if (to < from) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + " cannot have a from (" + from + ") which is strictly higher than its to (" + to + ").");
        }
        if (incrementUnit <= 0) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + " must have strictly positive incrementUnit (" + incrementUnit + ").");
        }
        if (((long)to - (long)from) % (long)incrementUnit != 0L) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + "'s incrementUnit (" + incrementUnit + ") must fit an integer number of times between from (" + from + ") and to (" + to + ").");
        }
    }

    @Override
    public long getSize() {
        return ((long)this.to - (long)this.from) / (long)this.incrementUnit;
    }

    @Override
    public boolean contains(Integer value) {
        if (value == null || value < this.from || value >= this.to) {
            return false;
        }
        if (this.incrementUnit == 1) {
            return true;
        }
        return ((long)value.intValue() - (long)this.from) % (long)this.incrementUnit == 0L;
    }

    @Override
    public Integer get(long index) {
        if (index < 0L || index >= this.getSize()) {
            throw new IndexOutOfBoundsException("The index (" + index + ") must be >= 0 and < size (" + this.getSize() + ").");
        }
        return (int)(index * (long)this.incrementUnit + (long)this.from);
    }

    @Override
    public Iterator<Integer> createOriginalIterator() {
        return new OriginalIntValueRangeIterator();
    }

    @Override
    public Iterator<Integer> createRandomIterator(Random workingRandom) {
        return new RandomIntValueRangeIterator(workingRandom);
    }

    public String toString() {
        return "[" + this.from + "-" + this.to + ")";
    }

    private class OriginalIntValueRangeIterator
    extends ValueRangeIterator<Integer> {
        private int upcoming;

        private OriginalIntValueRangeIterator() {
            this.upcoming = IntValueRange.this.from;
        }

        @Override
        public boolean hasNext() {
            return this.upcoming < IntValueRange.this.to;
        }

        @Override
        public Integer next() {
            if (this.upcoming >= IntValueRange.this.to) {
                throw new NoSuchElementException();
            }
            int next = this.upcoming;
            this.upcoming += IntValueRange.this.incrementUnit;
            return next;
        }
    }

    private class RandomIntValueRangeIterator
    extends ValueRangeIterator<Integer> {
        private final Random workingRandom;
        private final long size;

        public RandomIntValueRangeIterator(Random workingRandom) {
            this.size = IntValueRange.this.getSize();
            this.workingRandom = workingRandom;
        }

        @Override
        public boolean hasNext() {
            return this.size > 0L;
        }

        @Override
        public Integer next() {
            if (this.size <= 0L) {
                throw new NoSuchElementException();
            }
            long index = RandomUtils.nextLong(this.workingRandom, this.size);
            return (int)(index * (long)IntValueRange.this.incrementUnit + (long)IntValueRange.this.from);
        }
    }
}

