/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.valuerange.descriptor;

import ai.timefold.solver.core.api.domain.valuerange.CountableValueRange;
import ai.timefold.solver.core.api.domain.valuerange.ValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.composite.CompositeCountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.AbstractValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.EntityIndependentValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import java.util.ArrayList;
import java.util.List;

public class CompositeValueRangeDescriptor<Solution_>
extends AbstractValueRangeDescriptor<Solution_>
implements EntityIndependentValueRangeDescriptor<Solution_> {
    protected final List<ValueRangeDescriptor<Solution_>> childValueRangeDescriptorList;
    protected boolean entityIndependent;

    public CompositeValueRangeDescriptor(GenuineVariableDescriptor<Solution_> variableDescriptor, boolean addNullInValueRange, List<ValueRangeDescriptor<Solution_>> childValueRangeDescriptorList) {
        super(variableDescriptor, addNullInValueRange);
        this.childValueRangeDescriptorList = childValueRangeDescriptorList;
        this.entityIndependent = true;
        for (ValueRangeDescriptor<Solution_> valueRangeDescriptor : childValueRangeDescriptorList) {
            if (!valueRangeDescriptor.isCountable()) {
                throw new IllegalStateException("The valueRangeDescriptor (" + this + ") has a childValueRangeDescriptor (" + valueRangeDescriptor + ") with countable (" + valueRangeDescriptor.isCountable() + ").");
            }
            if (valueRangeDescriptor.isEntityIndependent()) continue;
            this.entityIndependent = false;
        }
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isEntityIndependent() {
        return this.entityIndependent;
    }

    @Override
    public ValueRange<?> extractValueRange(Solution_ solution, Object entity) {
        return this.innerExtractValueRange(solution, entity);
    }

    private <T> ValueRange<T> innerExtractValueRange(Solution_ solution, Object entity) {
        ArrayList<CountableValueRange> childValueRangeList = new ArrayList<CountableValueRange>(this.childValueRangeDescriptorList.size());
        for (ValueRangeDescriptor<Solution_> valueRangeDescriptor : this.childValueRangeDescriptorList) {
            childValueRangeList.add((CountableValueRange)valueRangeDescriptor.extractValueRange(solution, entity));
        }
        return this.doNullInValueRangeWrapping(new CompositeCountableValueRange(childValueRangeList));
    }

    @Override
    public ValueRange<?> extractValueRange(Solution_ solution) {
        return this.innerExtractValueRange(solution);
    }

    private <T> ValueRange<T> innerExtractValueRange(Solution_ solution) {
        ArrayList<CountableValueRange> childValueRangeList = new ArrayList<CountableValueRange>(this.childValueRangeDescriptorList.size());
        for (ValueRangeDescriptor<Solution_> valueRangeDescriptor : this.childValueRangeDescriptorList) {
            EntityIndependentValueRangeDescriptor entityIndependentValueRangeDescriptor = (EntityIndependentValueRangeDescriptor)valueRangeDescriptor;
            childValueRangeList.add((CountableValueRange)entityIndependentValueRangeDescriptor.extractValueRange(solution));
        }
        return this.doNullInValueRangeWrapping(new CompositeCountableValueRange(childValueRangeList));
    }

    @Override
    public long extractValueRangeSize(Solution_ solution, Object entity) {
        long size = this.addNullInValueRange ? 1L : 0L;
        for (ValueRangeDescriptor<Solution_> valueRangeDescriptor : this.childValueRangeDescriptorList) {
            size += ((CountableValueRange)valueRangeDescriptor.extractValueRange(solution, entity)).getSize();
        }
        return size;
    }

    @Override
    public long extractValueRangeSize(Solution_ solution) {
        long size = this.addNullInValueRange ? 1L : 0L;
        for (ValueRangeDescriptor<Solution_> valueRangeDescriptor : this.childValueRangeDescriptorList) {
            EntityIndependentValueRangeDescriptor entityIndependentValueRangeDescriptor = (EntityIndependentValueRangeDescriptor)valueRangeDescriptor;
            size += ((CountableValueRange)entityIndependentValueRangeDescriptor.extractValueRange(solution)).getSize();
        }
        return size;
    }
}

