/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.inverserelation;

import ai.timefold.solver.core.api.domain.variable.ListVariableListener;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import java.util.Iterator;

public class SingletonListInverseVariableListener<Solution_>
implements ListVariableListener<Solution_, Object, Object>,
SingletonInverseVariableSupply {
    protected final InverseRelationShadowVariableDescriptor<Solution_> shadowVariableDescriptor;
    protected final ListVariableDescriptor<Solution_> sourceVariableDescriptor;

    public SingletonListInverseVariableListener(InverseRelationShadowVariableDescriptor<Solution_> shadowVariableDescriptor, ListVariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.shadowVariableDescriptor = shadowVariableDescriptor;
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public void resetWorkingSolution(ScoreDirector<Solution_> scoreDirector) {
        if (this.sourceVariableDescriptor.supportsPinning()) {
            EntityDescriptor entityDescriptor = this.sourceVariableDescriptor.getEntityDescriptor();
            entityDescriptor.getSolutionDescriptor().visitEntitiesByEntityClass(scoreDirector.getWorkingSolution(), entityDescriptor.getEntityClass(), entity -> {
                this.beforeEntityAdded(scoreDirector, entity);
                this.afterEntityAdded(scoreDirector, entity);
                return false;
            });
        }
    }

    @Override
    public void beforeEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
        Iterator iterator = this.sourceVariableDescriptor.getValue(entity).iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            this.setInverse((InnerScoreDirector)scoreDirector, element, entity, null);
        }
    }

    @Override
    public void beforeEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        Iterator iterator = this.sourceVariableDescriptor.getValue(entity).iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            this.setInverse(innerScoreDirector, element, null, entity);
        }
    }

    @Override
    public void afterListVariableElementUnassigned(ScoreDirector<Solution_> scoreDirector, Object element) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        innerScoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, element);
        this.shadowVariableDescriptor.setValue(element, null);
        innerScoreDirector.afterVariableChanged(this.shadowVariableDescriptor, element);
    }

    @Override
    public void beforeListVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity, int fromIndex, int toIndex) {
    }

    @Override
    public void afterListVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity, int fromIndex, int toIndex) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        Object listVariable = this.sourceVariableDescriptor.getValue(entity);
        for (int i = fromIndex; i < toIndex; ++i) {
            Object element = listVariable.get(i);
            if (this.getInverseSingleton(element) == entity) continue;
            innerScoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, element);
            this.shadowVariableDescriptor.setValue(element, entity);
            innerScoreDirector.afterVariableChanged(this.shadowVariableDescriptor, element);
        }
    }

    private void setInverse(InnerScoreDirector<Solution_, ?> scoreDirector, Object element, Object inverseEntity, Object expectedOldInverseEntity) {
        Object oldInverseEntity = this.getInverseSingleton(element);
        if (oldInverseEntity == inverseEntity) {
            return;
        }
        if (scoreDirector.expectShadowVariablesInCorrectState() && oldInverseEntity != expectedOldInverseEntity) {
            throw new IllegalStateException("The entity (" + inverseEntity + ") has a list variable (" + this.sourceVariableDescriptor.getVariableName() + ") and one of its elements (" + element + ") which has a shadow variable (" + this.shadowVariableDescriptor.getVariableName() + ") has an oldInverseEntity (" + oldInverseEntity + ") which is not that entity.\nVerify the consistency of your input problem for that shadow variable.");
        }
        scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, element);
        this.shadowVariableDescriptor.setValue(element, inverseEntity);
        scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, element);
    }

    @Override
    public Object getInverseSingleton(Object planningValue) {
        return this.shadowVariableDescriptor.getValue(planningValue);
    }
}

