/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.listener.support.violation;

import ai.timefold.solver.core.api.domain.variable.VariableListener;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.listener.SourcedVariableListener;
import ai.timefold.solver.core.impl.domain.variable.listener.support.violation.VariableId;
import ai.timefold.solver.core.impl.domain.variable.supply.Demand;
import ai.timefold.solver.core.impl.domain.variable.supply.Supply;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import java.util.ArrayList;
import java.util.List;

public class VariableTracker<Solution_>
implements SourcedVariableListener<Solution_>,
VariableListener<Solution_, Object>,
Supply {
    private final VariableDescriptor<Solution_> variableDescriptor;
    private final List<Object> beforeVariableChangedEntityList;
    private final List<Object> afterVariableChangedEntityList;

    public VariableTracker(VariableDescriptor<Solution_> variableDescriptor) {
        this.variableDescriptor = variableDescriptor;
        this.beforeVariableChangedEntityList = new ArrayList<Object>();
        this.afterVariableChangedEntityList = new ArrayList<Object>();
    }

    @Override
    public VariableDescriptor<Solution_> getSourceVariableDescriptor() {
        return this.variableDescriptor;
    }

    @Override
    public void beforeEntityAdded(ScoreDirector<Solution_> scoreDirector, Object object) {
    }

    @Override
    public void afterEntityAdded(ScoreDirector<Solution_> scoreDirector, Object object) {
    }

    @Override
    public void beforeEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object object) {
    }

    @Override
    public void afterEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object object) {
    }

    @Override
    public void resetWorkingSolution(ScoreDirector<Solution_> scoreDirector) {
        this.beforeVariableChangedEntityList.clear();
        this.afterVariableChangedEntityList.clear();
    }

    @Override
    public void beforeVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.beforeVariableChangedEntityList.add(entity);
    }

    @Override
    public void afterVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.afterVariableChangedEntityList.add(entity);
    }

    public List<String> getEntitiesMissingBeforeAfterEvents(List<VariableId<Solution_>> changedVariables) {
        ArrayList<String> out = new ArrayList<String>();
        for (VariableId<Solution_> changedVariable : changedVariables) {
            if (!this.variableDescriptor.equals(changedVariable.variableDescriptor())) continue;
            Object entity = changedVariable.entity();
            if (!this.beforeVariableChangedEntityList.contains(entity)) {
                out.add("Entity (" + entity + ") is missing a beforeVariableChanged call for variable (" + this.variableDescriptor.getVariableName() + ").");
            }
            if (this.afterVariableChangedEntityList.contains(entity)) continue;
            out.add("Entity (" + entity + ") is missing a afterVariableChanged call for variable (" + this.variableDescriptor.getVariableName() + ").");
        }
        this.beforeVariableChangedEntityList.clear();
        this.afterVariableChangedEntityList.clear();
        return out;
    }

    public TrackerDemand demand() {
        return new TrackerDemand();
    }

    public class TrackerDemand
    implements Demand<VariableTracker<Solution_>> {
        @Override
        public VariableTracker<Solution_> createExternalizedSupply(SupplyManager supplyManager) {
            return VariableTracker.this;
        }
    }
}

