/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.move;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import java.util.Collection;
import java.util.Objects;

public abstract class AbstractUndoMove<Solution_>
implements Move<Solution_> {
    protected final Move<Solution_> parentMove;

    protected AbstractUndoMove(Move<Solution_> parentMove) {
        this.parentMove = Objects.requireNonNull(parentMove);
    }

    @Override
    public final boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return true;
    }

    @Override
    public final Move<Solution_> doMove(ScoreDirector<Solution_> scoreDirector) {
        throw new UnsupportedOperationException("Impossible state: undo move (%s) can't be undone.\ndoMoveOnly(...) should have been called instead.".formatted(this));
    }

    @Override
    public final void doMoveOnly(ScoreDirector<Solution_> scoreDirector) {
        this.doMoveOnGenuineVariables(scoreDirector);
        scoreDirector.triggerVariableListeners();
    }

    protected abstract void doMoveOnGenuineVariables(ScoreDirector<Solution_> var1);

    @Override
    public final Collection<?> getPlanningEntities() {
        return this.parentMove.getPlanningEntities();
    }

    @Override
    public final Collection<?> getPlanningValues() {
        return this.parentMove.getPlanningValues();
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return "Undo(" + this.parentMove.getSimpleMoveTypeDescription() + ")";
    }

    public String toString() {
        return this.getSimpleMoveTypeDescription();
    }
}

