/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.move;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractSimplifiedMove;
import ai.timefold.solver.core.impl.heuristic.move.ChangeAction;
import ai.timefold.solver.core.impl.heuristic.move.ListVariableAfterAssignmentAction;
import ai.timefold.solver.core.impl.heuristic.move.ListVariableAfterChangeAction;
import ai.timefold.solver.core.impl.heuristic.move.ListVariableAfterUnassignmentAction;
import ai.timefold.solver.core.impl.heuristic.move.ListVariableBeforeAssignmentAction;
import ai.timefold.solver.core.impl.heuristic.move.ListVariableBeforeChangeAction;
import ai.timefold.solver.core.impl.heuristic.move.ListVariableBeforeUnassignmentAction;
import ai.timefold.solver.core.impl.heuristic.move.VariableChangeAction;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirector;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorCache;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

final class VariableChangeRecordingScoreDirector<Solution_>
implements VariableDescriptorAwareScoreDirector<Solution_> {
    private final AbstractScoreDirector<Solution_, ?, ?> delegate;
    private final List<ChangeAction<Solution_>> variableChanges;
    private final Map<Object, Integer> cache = new IdentityHashMap<Object, Integer>();

    VariableChangeRecordingScoreDirector(ScoreDirector<Solution_> delegate) {
        this.delegate = (AbstractScoreDirector)delegate;
        this.variableChanges = new ArrayList<ChangeAction<Solution_>>();
    }

    public List<ChangeAction<Solution_>> getVariableChanges() {
        return this.variableChanges;
    }

    @Override
    public void beforeVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        this.variableChanges.add(new VariableChangeAction<Solution_, Object, Object>(entity, variableDescriptor.getValue(entity), variableDescriptor));
        this.delegate.beforeVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        this.delegate.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void beforeListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        this.cache.put(entity, fromIndex);
        this.variableChanges.add(new ListVariableBeforeChangeAction(entity, new ArrayList(variableDescriptor.getValue(entity).subList(fromIndex, toIndex)), fromIndex, toIndex, variableDescriptor));
        this.delegate.beforeListVariableChanged(variableDescriptor, entity, fromIndex, toIndex);
    }

    @Override
    public void afterListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        Integer requiredFromIndex = this.cache.remove(entity);
        if (requiredFromIndex != fromIndex) {
            throw new IllegalArgumentException("The fromIndex of afterListVariableChanged (%d) must match the fromIndex of its beforeListVariableChanged counterpart (%d).\nMaybe check implementation of your %s.".formatted(fromIndex, requiredFromIndex, AbstractSimplifiedMove.class.getSimpleName()));
        }
        this.variableChanges.add(new ListVariableAfterChangeAction(entity, fromIndex, toIndex, variableDescriptor));
        this.delegate.afterListVariableChanged(variableDescriptor, entity, fromIndex, toIndex);
    }

    @Override
    public void beforeListVariableElementAssigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.variableChanges.add(new ListVariableBeforeAssignmentAction<Solution_>(element, variableDescriptor));
        this.delegate.beforeListVariableElementAssigned(variableDescriptor, element);
    }

    @Override
    public void afterListVariableElementAssigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.variableChanges.add(new ListVariableAfterAssignmentAction<Solution_>(element, variableDescriptor));
        this.delegate.afterListVariableElementAssigned(variableDescriptor, element);
    }

    @Override
    public void beforeListVariableElementUnassigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.variableChanges.add(new ListVariableBeforeUnassignmentAction<Solution_>(element, variableDescriptor));
        this.delegate.beforeListVariableElementUnassigned(variableDescriptor, element);
    }

    @Override
    public void afterListVariableElementUnassigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.variableChanges.add(new ListVariableAfterUnassignmentAction<Solution_>(element, variableDescriptor));
        this.delegate.afterListVariableElementUnassigned(variableDescriptor, element);
    }

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.delegate.getSolutionDescriptor();
    }

    @Override
    public Solution_ getWorkingSolution() {
        return this.delegate.getWorkingSolution();
    }

    @Override
    public VariableDescriptorCache<Solution_> getVariableDescriptorCache() {
        return this.delegate.getVariableDescriptorCache();
    }

    @Override
    public void triggerVariableListeners() {
        this.delegate.triggerVariableListeners();
    }

    @Override
    public <E> E lookUpWorkingObject(E externalObject) {
        return this.delegate.lookUpWorkingObject(externalObject);
    }

    @Override
    public <E> E lookUpWorkingObjectOrReturnNull(E externalObject) {
        return this.delegate.lookUpWorkingObjectOrReturnNull(externalObject);
    }

    @Override
    public void changeVariableFacade(VariableDescriptor<Solution_> variableDescriptor, Object entity, Object newValue) {
        this.delegate.changeVariableFacade(variableDescriptor, entity, newValue);
    }
}

